TITLE leakAWC
: A passive leak current

UNITS {
(mA) = (milliamp)
	(S) = (siemens)
	(mV) = (millivolt)

}

NEURON {
SUFFIX leakAWC
NONSPECIFIC_CURRENT i
RANGE i, e, gbar
}



PARAMETER {
gbar = 0.27  (S/cm2)  
e = -90  (mV)
}

ASSIGNED {
i  (mA/cm2)
v  (mV)
}

BREAKPOINT { i = gbar*(v - e) }