TITLE GCNcurrent
: cgn currents (tax-2/4)

UNITS {
    (mA) = (milliamp)
    (S) = (siemens)
    (mV) = (millivolt)
    (molar) = (1/liter)
    (mM)=(millimolar)
    (uM)=(micromolar)
}

NEURON {
SUFFIX cng
USEION c READ ci VALENCE 0
USEION myca WRITE imyca VALENCE 2
RANGE e, gbar, n1
}



PARAMETER {
e = 0.08 (mV)
gbar=1e-6 (S/cm2)
n1=1.46
kcng=2.72e-3 (mM)
}

ASSIGNED {
imyca (mA/cm2)
ci (mM)
v  (mV)
}

BREAKPOINT {
imyca= gbar*(v - e)*activ(ci)
}
 
 FUNCTION activ(ci (mM)){
 UNITSOFF
 activ=((ci^n1)/((ci^n1)+(kcng^n1)))
 UNITSON
  }