TITLE KVS1
: kvs1
: Cai 2007



UNITS {
   (mA) = (milliamp)
	(S) = (siemens)
	(mV) = (millivolt)

}


NEURON {
	SUFFIX kvs1
	USEION k READ ek WRITE ik
        RANGE gbar,g,curr
	
}


PARAMETER{
   ek (mV)
   celsius		(degC)
   gbar=0.8 (S/cm2)
   va_kvs1=57.1 (mV)
   ka_kvs1=25   (mV)
   vi_kvs1=47.3  (mV)
   ki_kvs1=11.1   (mV)
   
   p1tmkvs1=30.0000 (ms)
   p2tmkvs1=18.1232 (mV)
   p3tmkvs1=-20.0000 (mV)
   p4tmkvs1=1.000    (ms)
  
   p1thkvs1=88.4715 (ms)
   p2thkvs1=50.00   (mV)
   p3thkvs1=-15      (mV)
   p4thkvs1=53.4060  (ms)
   skvs1=30           (mV)
   cthkvs1=0.1       
}


ASSIGNED{
		 ik (mA/cm2)
		 g (S/cm2)
		 curr (mA/cm2)
		 v (mV)
	}
	

STATE {
	m h
}


BREAKPOINT {
	SOLVE states METHOD cnexp
	g=gbar*m*h
	curr=gbar*m*h*(v-ek)
	ik = gbar*m*h*(v-ek)
}


INITIAL {
	m=minf(v)
	h=hinf(v)
}

DERIVATIVE states {     
        m' = (minf(v) - m)/mtau(v)
		h'=(hinf(v)-h)/htau(v)
	}



FUNCTION minf(v (mV)) { 
		UNITSOFF
        minf=1/(1+exp(-(v-va_kvs1+skvs1)/ka_kvs1))
		UNITSON
		}
		
FUNCTION hinf(v (mV)){
		UNITSOFF
        hinf = 1/(1+exp((v-vi_kvs1+skvs1)/(ki_kvs1)))
		UNITSON
		}
		
FUNCTION mtau(v (mV)){
		UNITSOFF
        mtau=(p1tmkvs1/(1+exp(-(v-p2tmkvs1)/p3tmkvs1))+p4tmkvs1)/10
		UNITSON
		}

FUNCTION htau(v (mV)){
		UNITSOFF
		htau=(p1thkvs1/(1+exp(-(v-p2thkvs1)/p3thkvs1))+p4thkvs1)*cthkvs1
		UNITSON
		}












