TITLE SHL1
: Shal current cultured myocites
: Fawcett 2006



UNITS {
(mA) = (milliamp)
	(S) = (siemens)
	(mV) = (millivolt)
}


NEURON {
	SUFFIX shl1
	USEION k READ ek WRITE ik
    RANGE gbar,g,curr
	}


PARAMETER{
   ek (mV)
   celsius	(degC)
   gbar=2.9 (S/cm2)
   vashal=11.2 (mV)
   kashal=14.1  (mV)
   kishal=8.3   (mV)
   vishal=-33.1  (mV)
   shalsfhit=18  (mV)
   
   ptmshal1=13.8  (ms)
   ptmshal2=-17.5165 (mV)
   ptmshal3=12.9213 (mV)
   ptmshal4=-3.7082 (mV)
   ptmshal5=6.4876 (mV)
   ptmshal6=1.8849 (ms)
  
  pthfshal1=539.1584  (ms)
   pthfshal2=-28.1990 (mV)
   pthfshal3=4.9199   (mV)
   pthfshal4=27.2811  (ms)

   pthsshal1=8422     (ms)
   pthsshal2=-37.7391 (mV)
   pthsshal3=6.3785    (mV)
   pthsshal4=118.8983  (ms)
   
   cshal=0.1  (1)
   c2shal=0.1  (1)
   c3shal=0.1   (1)
 
  
}

ASSIGNED{
		 ik (mA/cm2)
		 curr (mA/cm2)
		 g (S/cm2)
		 v (mV)
		
    }
	

STATE {
	m hs hf
}


BREAKPOINT {
	SOLVE states METHOD cnexp
	g=gbar*m*m*m*((0.7*hf)+(0.3*hs))
	curr=gbar*m*m*m*((0.7*hf)+(0.3*hs))*(v-ek)
	ik = gbar*m*m*m*((0.7*hf)+(0.3*hs))*(v-ek)

}


INITIAL {
	m=minf(v)
	hs=hinf(v)
	hf=hinf(v)
}

DERIVATIVE states {     
        m' = (minf(v) - m)/mtau(v)
		hs'=(hinf(v)-hs)/htaus(v)
		hf'=(hinf(v)-hf)/htauf(v)
}


FUNCTION minf(v (mV)) { 
        UNITSOFF	
        minf=1/(1+exp(-(v-vashal+shalsfhit)/kashal)) 
	    UNITSON
		}
		
FUNCTION hinf(v (mV)){
		UNITSOFF
        hinf = 1/(1+exp((v-vishal+shalsfhit)/kishal))
		UNITSON
		}
		
FUNCTION mtau(v(mV)){
	    UNITSOFF
        mtau=(ptmshal1/(exp(-(v-ptmshal2)/ptmshal3)+exp((v-ptmshal4)/ptmshal5))+ptmshal6)*cshal
		UNITSON
		}
		
FUNCTION htauf(v(mV)){
	    UNITSOFF
		htauf=(pthfshal1/(1+exp((v-pthfshal2)/pthfshal3))+pthfshal4)*c3shal
		UNITSON
		}
		
FUNCTION htaus(v(mV)){
		
		htaus=(pthsshal1/(1+exp((v-pthsshal2)/pthsshal3))+pthsshal4)*c2shal
		
}
