Gallimore, A. R., Hepburn, I., Georgiev, S. V., Rizzoli, S. O., & De Schutter, E. (2024) A Detailed Spatial Model of the Complete Synaptic Vesicle Cycle. *Science Advances*


This model, described in the above study, was run on the STEPS software ([https://steps.sourceforge.net](https://steps.sourceforge.net)) on a pre-release version of STEPS 5, which is available at [https://steps.sourceforge.net/STEPS/download/STEPS_5.0.0_alpha.zip](https://steps.sourceforge.net/STEPS/download/STEPS_5.0.0_alpha.zip). For full reproducibility of the data in the study the model should be run on this version of the code due to some changes in the API and other modifications before release.

Each individual simulation is run with command line arguments to customise the simulation, as described in more detail at the top of the `VESICLE_CYCLE_MODEL_MPI.py` script. The script must be run in parallel with a minimum of 2 processes, but 256 is recommended for optimum performance. So, for example, to run a 10Hz simulation for 60 biological seconds the command may look like this:

```
mpirun -n 256 python VESICLE_CYCLE_MODEL_MPI.py $SLURM_JOBID /my/path/to/model/ 10 60 1 /my/path/to/data/
```

The example slurm script `run_model_example.slurm` demonstrates running the model 5 times with different seeds each with 256 processes, on a total of 1280 cores. 

Please note that even running on a cluster with 256 processes, this is an extremely computationally-intensive model and may take ~8 days to complete 60 biological seconds. 