'''
This is the cfg.py file for the expanded receptive field (RF) model
Code by L Medlock (Nov 15 2024)
'''

from netpyne import specs
from neuron import h
import numpy as np
from scipy.stats import multivariate_normal
import sys
sys.path.insert(0, 'cells')  # adding path to cells dir

cfg = specs.SimConfig()	# object of class SimConfig to store simulation configuration

###############################################################################
# SIMULATION PARAMETERS
###############################################################################
cfg.duration = 1000                       # Duration of the simulation, in ms
cfg.dt = 0.025                             # Internal integration timestep to use
cfg.printPopAvgRates = [0, cfg.duration]

cfg.hParams = {'celsius': 36, 'v_init': -60 }
cfg.vrest = cfg.hParams['v_init']
cfg.recordStep = 0.01

# RECORD TRACES
cfg.recordCells = {'all'}
#cfg.recordTraces['iStim'] = {'sec':'soma','loc':0.5,'stim':'Stim1','var':'i'}  
# cfg.recordTraces['gGABA'] = {'sec':'soma','loc':0.5,'synMech':'GABA','var':'g'}
#cfg.recordTraces['iGABA2'] = {'sec':'soma','loc':0.5,'synMech':'GABA','var':'i', 'index':2}
# cfg.recordTraces['gAMPA'] = {'sec':'soma','loc':0.5,'synMech':'AMPA','var':'g'}
#cfg.recordTraces['iAMPA1'] = {'sec':'soma','loc':0.5,'synMech':'AMPA','var':'i', 'index':1}
cfg.recordTraces['v_soma'] = {'sec':'soma','loc':0.5,'var':'v'}

# SAVING
cfg.simLabel = 'RF'
cfg.saveFolder = 'RFdata'
cfg.saveDataInclude = ['simData','netParams','netPops','netCells']  # (can't save dataFrame for SCS excel simulations)
#cfg.saveMat = True
#cfg.saveJson = True

# PLOTTING
#cfg.analysis['plotTraces'] = {'include': [79,80,81], 'timeRange':[0,cfg.duration],  'figSize':(10, 4), 'saveFig': True} # 'ylim':[-90,55],
#cfg.analysis['plotTraces'] = {'include': [60,125,130], 'timeRange':[450,500], 'figSize':(10, 8), 'saveFig': True, 'oneFigPer': 'trace'} # 'include': ['E_cell','I_layer'],
cfg.analysis['plotRaster'] = {'include':['PAN','I_layer','E_cell1','E_cell2','Proj'],'timeRange':[0,cfg.duration],'figSize':(8, 8), 'saveFig': True, 'showFig': True}
#cfg.analysis['plotSpikeHist'] = {'include':['PAN','I_tonic','E_delay'],'overlay':False,'timeRange':[0,cfg.duration], 'binSize': 100, 'graphType':'bar','saveFig': True}
#cfg.analysis['plotSpikeStats'] = {'include':['eachPop'], 'stats':['rate'],'graphType':'boxplot','xlim':[0,55], 'saveFig':True,'showFig': True}
#cfg.analysis['plot2Dnet'] = {'showConns': True,'saveFig': True}
#cfg.analysis['plotShape'] = {'includePre':['PAN'], 'includePost':[],'showSyns': False,'dist': 0.8,'showFig': True}
#cfg.analysis['plotConn'] = {'groupBy':'cell','feature':'weight','saveFig': True}






		



