/* Created by Language version: 7.7.0 */
/* VECTORIZED */
#define NRN_VECTORIZED 1
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "mech_api.h"
#undef PI
#define nil 0
#include "md1redef.h"
#include "section.h"
#include "nrniv_mf.h"
#include "md2redef.h"
 
#if METHOD3
extern int _method3;
#endif

#if !NRNGPU
#undef exp
#define exp hoc_Exp
extern double hoc_Exp(double);
#endif
 
#define nrn_init _nrn_init__IF_BG4
#define _nrn_initial _nrn_initial__IF_BG4
#define nrn_cur _nrn_cur__IF_BG4
#define _nrn_current _nrn_current__IF_BG4
#define nrn_jacob _nrn_jacob__IF_BG4
#define nrn_state _nrn_state__IF_BG4
#define _net_receive _net_receive__IF_BG4 
#define fire fire__IF_BG4 
#define states states__IF_BG4 
 
#define _threadargscomma_ _p, _ppvar, _thread, _nt,
#define _threadargsprotocomma_ double* _p, Datum* _ppvar, Datum* _thread, NrnThread* _nt,
#define _threadargs_ _p, _ppvar, _thread, _nt
#define _threadargsproto_ double* _p, Datum* _ppvar, Datum* _thread, NrnThread* _nt
 	/*SUPPRESS 761*/
	/*SUPPRESS 762*/
	/*SUPPRESS 763*/
	/*SUPPRESS 765*/
	 extern double *getarg();
 /* Thread safe. No static _p or _ppvar. */
 
#define t _nt->_t
#define dt _nt->_dt
#define a _p[0]
#define a_columnindex 0
#define b _p[1]
#define b_columnindex 1
#define tau_w _p[2]
#define tau_w_columnindex 2
#define EL _p[3]
#define EL_columnindex 3
#define GL _p[4]
#define GL_columnindex 4
#define delta _p[5]
#define delta_columnindex 5
#define surf _p[6]
#define surf_columnindex 6
#define Vtr _p[7]
#define Vtr_columnindex 7
#define Ref _p[8]
#define Ref_columnindex 8
#define Vtop _p[9]
#define Vtop_columnindex 9
#define Vbot _p[10]
#define Vbot_columnindex 10
#define gna _p[11]
#define gna_columnindex 11
#define gkd _p[12]
#define gkd_columnindex 12
#define i _p[13]
#define i_columnindex 13
#define reset _p[14]
#define reset_columnindex 14
#define spike _p[15]
#define spike_columnindex 15
#define spiketimes (_p + 16)
#define spiketimes_columnindex 16
#define nspike _p[10016]
#define nspike_columnindex 10016
#define w _p[10017]
#define w_columnindex 10017
#define Dw _p[10018]
#define Dw_columnindex 10018
#define v _p[10019]
#define v_columnindex 10019
#define _g _p[10020]
#define _g_columnindex 10020
 
#if MAC
#if !defined(v)
#define v _mlhv
#endif
#if !defined(h)
#define h _mlhh
#endif
#endif
 
#if defined(__cplusplus)
extern "C" {
#endif
 static int hoc_nrnpointerindex =  -1;
 static Datum* _extcall_thread;
 static Prop* _extcall_prop;
 /* external NEURON variables */
 /* declaration of user functions */
 static void _hoc_fire(void);
 static int _mechtype;
extern void _nrn_cacheloop_reg(int, int);
extern void hoc_register_prop_size(int, int, int);
extern void hoc_register_limits(int, HocParmLimits*);
extern void hoc_register_units(int, HocParmUnits*);
extern void nrn_promote(Prop*, int, int);
extern Memb_func* memb_func;
 
#define NMODL_TEXT 1
#if NMODL_TEXT
static const char* nmodl_file_text;
static const char* nmodl_filename;
extern void hoc_reg_nmodl_text(int, const char*);
extern void hoc_reg_nmodl_filename(int, const char*);
#endif

 extern void _nrn_setdata_reg(int, void(*)(Prop*));
 static void _setdata(Prop* _prop) {
 _extcall_prop = _prop;
 }
 static void _hoc_setdata() {
 Prop *_prop, *hoc_getdata_range(int);
 _prop = hoc_getdata_range(_mechtype);
   _setdata(_prop);
 hoc_retpushx(1.);
}
 /* connect user functions to hoc names */
 static VoidFunc hoc_intfunc[] = {
 "setdata_IF_BG4", _hoc_setdata,
 "fire_IF_BG4", _hoc_fire,
 0, 0
};
 /* declare global and static user variables */
 /* some parameters have upper and lower limits */
 static HocParmLimits _hoc_parm_limits[] = {
 0,0,0
};
 static HocParmUnits _hoc_parm_units[] = {
 "a_IF_BG4", "uS",
 "b_IF_BG4", "nA",
 "tau_w_IF_BG4", "ms",
 "EL_IF_BG4", "mV",
 "GL_IF_BG4", "mho/cm2",
 "delta_IF_BG4", "mV",
 "surf_IF_BG4", "um2",
 "Vtr_IF_BG4", "mV",
 "Ref_IF_BG4", "ms",
 "Vtop_IF_BG4", "mV",
 "Vbot_IF_BG4", "mV",
 "gna_IF_BG4", "mho/cm2",
 "gkd_IF_BG4", "mho/cm2",
 "w_IF_BG4", "nA",
 "i_IF_BG4", "mA/cm2",
 "reset_IF_BG4", "ms",
 "spiketimes_IF_BG4", "ms",
 0,0
};
 static double delta_t = 1;
 static double w0 = 0;
 /* connect global user variables to hoc */
 static DoubScal hoc_scdoub[] = {
 0,0
};
 static DoubVec hoc_vdoub[] = {
 0,0,0
};
 static double _sav_indep;
 static void nrn_alloc(Prop*);
static void  nrn_init(NrnThread*, _Memb_list*, int);
static void nrn_state(NrnThread*, _Memb_list*, int);
 static void nrn_cur(NrnThread*, _Memb_list*, int);
static void  nrn_jacob(NrnThread*, _Memb_list*, int);
 
static int _ode_count(int);
static void _ode_map(int, double**, double**, double*, Datum*, double*, int);
static void _ode_spec(NrnThread*, _Memb_list*, int);
static void _ode_matsol(NrnThread*, _Memb_list*, int);
 
#define _cvode_ieq _ppvar[0]._i
 static void _ode_matsol_instance1(_threadargsproto_);
 /* connect range variables in _p that hoc is supposed to know about */
 static const char *_mechanism[] = {
 "7.7.0",
"IF_BG4",
 "a_IF_BG4",
 "b_IF_BG4",
 "tau_w_IF_BG4",
 "EL_IF_BG4",
 "GL_IF_BG4",
 "delta_IF_BG4",
 "surf_IF_BG4",
 "Vtr_IF_BG4",
 "Ref_IF_BG4",
 "Vtop_IF_BG4",
 "Vbot_IF_BG4",
 "gna_IF_BG4",
 "gkd_IF_BG4",
 0,
 "i_IF_BG4",
 "reset_IF_BG4",
 "spike_IF_BG4",
 "spiketimes_IF_BG4[10000]",
 "nspike_IF_BG4",
 0,
 "w_IF_BG4",
 0,
 0};
 
extern Prop* need_memb(Symbol*);

static void nrn_alloc(Prop* _prop) {
	Prop *prop_ion;
	double *_p; Datum *_ppvar;
 	_p = nrn_prop_data_alloc(_mechtype, 10021, _prop);
 	/*initialize range parameters*/
 	a = 0;
 	b = 0;
 	tau_w = 120;
 	EL = -70;
 	GL = 0;
 	delta = 2;
 	surf = 10000;
 	Vtr = -45;
 	Ref = 5;
 	Vtop = 50;
 	Vbot = -85;
 	gna = 1;
 	gkd = 1;
 	_prop->param = _p;
 	_prop->param_size = 10021;
 	_ppvar = nrn_prop_datum_alloc(_mechtype, 1, _prop);
 	_prop->dparam = _ppvar;
 	/*connect ionic variables to this model*/
 
}
 static void _initlists();
  /* some states have an absolute tolerance */
 static Symbol** _atollist;
 static HocStateTolerance _hoc_state_tol[] = {
 0,0
};
 extern Symbol* hoc_lookup(const char*);
extern void _nrn_thread_reg(int, int, void(*)(Datum*));
extern void _nrn_thread_table_reg(int, void(*)(double*, Datum*, Datum*, NrnThread*, int));
extern void hoc_register_tolerance(int, HocStateTolerance*, Symbol***);
extern void _cvode_abstol( Symbol**, double*, int);

 void _IF_BG4_reg() {
	int _vectorized = 1;
  _initlists();
 	register_mech(_mechanism, nrn_alloc,nrn_cur, nrn_jacob, nrn_state, nrn_init, hoc_nrnpointerindex, 1);
 _mechtype = nrn_get_mechtype(_mechanism[1]);
     _nrn_setdata_reg(_mechtype, _setdata);
 #if NMODL_TEXT
  hoc_reg_nmodl_text(_mechtype, nmodl_file_text);
  hoc_reg_nmodl_filename(_mechtype, nmodl_filename);
#endif
  hoc_register_prop_size(_mechtype, 10021, 1);
  hoc_register_dparam_semantics(_mechtype, 0, "cvodeieq");
 	hoc_register_cvode(_mechtype, _ode_count, _ode_map, _ode_spec, _ode_matsol);
 	hoc_register_tolerance(_mechtype, _hoc_state_tol, &_atollist);
 	hoc_register_var(hoc_scdoub, hoc_vdoub, hoc_intfunc);
 	ivoc_help("help ?1 IF_BG4 /Users/lauramedlock/Downloads/RF-Model/mods/IF_BG4.mod\n");
 hoc_register_limits(_mechtype, _hoc_parm_limits);
 hoc_register_units(_mechtype, _hoc_parm_units);
 }
static int _reset;
static char *modelname = "Brette-Gerstner-Izhikevich IF model";

static int error;
static int _ninits = 0;
static int _match_recurse=1;
static void _modl_cleanup(){ _match_recurse=1;}
static int fire(_threadargsproto_);
 
static int _ode_spec1(_threadargsproto_);
/*static int _ode_matsol1(_threadargsproto_);*/
 static double *_temp1;
 static int _slist1[1], _dlist1[1];
 static int states(_threadargsproto_);
 
/*CVODE*/
 static int _ode_spec1 (double* _p, Datum* _ppvar, Datum* _thread, NrnThread* _nt) {int _reset = 0; {
   Dw = ( a * ( v - EL ) - w ) / tau_w ;
   }
 return _reset;
}
 static int _ode_matsol1 (double* _p, Datum* _ppvar, Datum* _thread, NrnThread* _nt) {
 Dw = Dw  / (1. - dt*( ( ( ( - 1.0 ) ) ) / tau_w )) ;
  return 0;
}
 /*END CVODE*/
 
static int states (double* _p, Datum* _ppvar, Datum* _thread, NrnThread* _nt) {int _reset=0; int error = 0;
 {
   Dw = ( a * ( v - EL ) - w ) / tau_w ;
   }
 return _reset;}
 
static int  fire ( _threadargsproto_ ) {
   double _lq ;
 reset = reset - dt ;
   if ( reset > 0.0 ) {
     i = gkd * ( v - Vbot ) ;
     }
   else if ( spike ) {
     i = gna * ( v - Vtop ) ;
     spike = 0.0 ;
     reset = Ref ;
     }
   else if ( v > Vtr ) {
     w = w + b ;
     i = gna * ( v - Vtop ) ;
     spike = 1.0 ;
     spiketimes [ ((int) nspike ) ] = t ;
     nspike = nspike + 1.0 ;
     }
    return 0; }
 
static void _hoc_fire(void) {
  double _r;
   double* _p; Datum* _ppvar; Datum* _thread; NrnThread* _nt;
   if (_extcall_prop) {_p = _extcall_prop->param; _ppvar = _extcall_prop->dparam;}else{ _p = (double*)0; _ppvar = (Datum*)0; }
  _thread = _extcall_thread;
  _nt = nrn_threads;
 _r = 1.;
 fire ( _p, _ppvar, _thread, _nt );
 hoc_retpushx(_r);
}
 
static int _ode_count(int _type){ return 1;}
 
static void _ode_spec(NrnThread* _nt, _Memb_list* _ml, int _type) {
   double* _p; Datum* _ppvar; Datum* _thread;
   Node* _nd; double _v; int _iml, _cntml;
  _cntml = _ml->_nodecount;
  _thread = _ml->_thread;
  for (_iml = 0; _iml < _cntml; ++_iml) {
    _p = _ml->_data[_iml]; _ppvar = _ml->_pdata[_iml];
    _nd = _ml->_nodelist[_iml];
    v = NODEV(_nd);
     _ode_spec1 (_p, _ppvar, _thread, _nt);
 }}
 
static void _ode_map(int _ieq, double** _pv, double** _pvdot, double* _pp, Datum* _ppd, double* _atol, int _type) { 
	double* _p; Datum* _ppvar;
 	int _i; _p = _pp; _ppvar = _ppd;
	_cvode_ieq = _ieq;
	for (_i=0; _i < 1; ++_i) {
		_pv[_i] = _pp + _slist1[_i];  _pvdot[_i] = _pp + _dlist1[_i];
		_cvode_abstol(_atollist, _atol, _i);
	}
 }
 
static void _ode_matsol_instance1(_threadargsproto_) {
 _ode_matsol1 (_p, _ppvar, _thread, _nt);
 }
 
static void _ode_matsol(NrnThread* _nt, _Memb_list* _ml, int _type) {
   double* _p; Datum* _ppvar; Datum* _thread;
   Node* _nd; double _v; int _iml, _cntml;
  _cntml = _ml->_nodecount;
  _thread = _ml->_thread;
  for (_iml = 0; _iml < _cntml; ++_iml) {
    _p = _ml->_data[_iml]; _ppvar = _ml->_pdata[_iml];
    _nd = _ml->_nodelist[_iml];
    v = NODEV(_nd);
 _ode_matsol_instance1(_threadargs_);
 }}

static void initmodel(double* _p, Datum* _ppvar, Datum* _thread, NrnThread* _nt) {
  int _i; double _save;{
  w = w0;
 {
   spike = 0.0 ;
   reset = - 1.0 ;
   w = 0.0 ;
   nspike = 0.0 ;
   }
 
}
}

static void nrn_init(NrnThread* _nt, _Memb_list* _ml, int _type){
double* _p; Datum* _ppvar; Datum* _thread;
Node *_nd; double _v; int* _ni; int _iml, _cntml;
#if CACHEVEC
    _ni = _ml->_nodeindices;
#endif
_cntml = _ml->_nodecount;
_thread = _ml->_thread;
for (_iml = 0; _iml < _cntml; ++_iml) {
 _p = _ml->_data[_iml]; _ppvar = _ml->_pdata[_iml];
#if CACHEVEC
  if (use_cachevec) {
    _v = VEC_V(_ni[_iml]);
  }else
#endif
  {
    _nd = _ml->_nodelist[_iml];
    _v = NODEV(_nd);
  }
 v = _v;
 initmodel(_p, _ppvar, _thread, _nt);
}
}

static double _nrn_current(double* _p, Datum* _ppvar, Datum* _thread, NrnThread* _nt, double _v){double _current=0.;v=_v;{ {
   i = - GL * delta * exp ( ( v - Vtr ) / delta ) + ( 100.0 ) * w / surf ;
   fire ( _threadargs_ ) ;
   }
 _current += i;

} return _current;
}

static void nrn_cur(NrnThread* _nt, _Memb_list* _ml, int _type) {
double* _p; Datum* _ppvar; Datum* _thread;
Node *_nd; int* _ni; double _rhs, _v; int _iml, _cntml;
#if CACHEVEC
    _ni = _ml->_nodeindices;
#endif
_cntml = _ml->_nodecount;
_thread = _ml->_thread;
for (_iml = 0; _iml < _cntml; ++_iml) {
 _p = _ml->_data[_iml]; _ppvar = _ml->_pdata[_iml];
#if CACHEVEC
  if (use_cachevec) {
    _v = VEC_V(_ni[_iml]);
  }else
#endif
  {
    _nd = _ml->_nodelist[_iml];
    _v = NODEV(_nd);
  }
 _g = _nrn_current(_p, _ppvar, _thread, _nt, _v + .001);
 	{ _rhs = _nrn_current(_p, _ppvar, _thread, _nt, _v);
 	}
 _g = (_g - _rhs)/.001;
#if CACHEVEC
  if (use_cachevec) {
	VEC_RHS(_ni[_iml]) -= _rhs;
  }else
#endif
  {
	NODERHS(_nd) -= _rhs;
  }
 
}
 
}

static void nrn_jacob(NrnThread* _nt, _Memb_list* _ml, int _type) {
double* _p; Datum* _ppvar; Datum* _thread;
Node *_nd; int* _ni; int _iml, _cntml;
#if CACHEVEC
    _ni = _ml->_nodeindices;
#endif
_cntml = _ml->_nodecount;
_thread = _ml->_thread;
for (_iml = 0; _iml < _cntml; ++_iml) {
 _p = _ml->_data[_iml];
#if CACHEVEC
  if (use_cachevec) {
	VEC_D(_ni[_iml]) += _g;
  }else
#endif
  {
     _nd = _ml->_nodelist[_iml];
	NODED(_nd) += _g;
  }
 
}
 
}

static void nrn_state(NrnThread* _nt, _Memb_list* _ml, int _type) {
double* _p; Datum* _ppvar; Datum* _thread;
Node *_nd; double _v = 0.0; int* _ni; int _iml, _cntml;
double _dtsav = dt;
if (secondorder) { dt *= 0.5; }
#if CACHEVEC
    _ni = _ml->_nodeindices;
#endif
_cntml = _ml->_nodecount;
_thread = _ml->_thread;
for (_iml = 0; _iml < _cntml; ++_iml) {
 _p = _ml->_data[_iml]; _ppvar = _ml->_pdata[_iml];
 _nd = _ml->_nodelist[_iml];
#if CACHEVEC
  if (use_cachevec) {
    _v = VEC_V(_ni[_iml]);
  }else
#endif
  {
    _nd = _ml->_nodelist[_iml];
    _v = NODEV(_nd);
  }
 v=_v;
{
 {   euler_thread(1, _slist1, _dlist1, _p, states, _ppvar, _thread, _nt);
     if (secondorder) {
    int _i;
    for (_i = 0; _i < 1; ++_i) {
      _p[_slist1[_i]] += dt*_p[_dlist1[_i]];
    }}
 }}}
 dt = _dtsav;
}

static void terminal(){}

static void _initlists(){
 double _x; double* _p = &_x;
 int _i; static int _first = 1;
  if (!_first) return;
 _slist1[0] = w_columnindex;  _dlist1[0] = Dw_columnindex;
_first = 0;
}

#if defined(__cplusplus)
} /* extern "C" */
#endif

#if NMODL_TEXT
static const char* nmodl_filename = "/Users/lauramedlock/Downloads/RF-Model/mods/IF_BG4.mod";
static const char* nmodl_file_text = 
  "TITLE Brette-Gerstner-Izhikevich IF model\n"
  "\n"
  "COMMENT\n"
  "-----------------------------------------------------------------------------\n"
  "Found: https://github.com/OpenSourceBrain/destexhe_jcns_2009/blob/master/demo_cx_up-down/IF_BG4.mod\n"
  "For: https://andrewdavison.info/notes/porting-NEURON-PyNN/ \n"
  "\n"
  "Integrate and fire model based on Brette-Gerstner-Izhikevich model. \n"
  "This model consists of the two-variable integrate-and-fire (IF) model\n"
  "proposed by Izhikevich (2004):\n"
  "\n"
  "  Izhikevich EM. Which model to use for cortical spiking neurons?\n"
  "  IEEE Trans. Neural Networks. 15: 1063-1070, 2004.\n"
  "\n"
  "This model was modified to include an exponential non-linearity\n"
  "around spike threshold, based on the exponential IF model of \n"
  "Fourcaud-Trocme et al. (2003):\n"
  "\n"
  "  Fourcaud-Trocme N, Hansel D, van Vreeswijk C and Brunel N.\n"
  "  How spike generation mechanisms determine the neuronal response to\n"
  "  fluctuating inputs.  J. Neurosci. 23: 11628-11640, 2003.  \n"
  "\n"
  "These two models were combined by Brette and Gerstner (2005):\n"
  "\n"
  "  Brette R and Gersnter W. Adaptive exponential integrate-and-fire\n"
  "  model as an effective description of neuronal activity. \n"
  "  J. Neurophysiol. 94: 3637-3642, 2005.\n"
  "\n"
  "(see this paper for details)\n"
  "\n"
  "The present implementation considers in addition a spike mechanism \n"
  "based on \"fake conductances\":\n"
  "- at the spike, activate a strong depolarizing (gna) conductance\n"
  "- then the reset is a strong hyperpolarizing (gkd) conductance\n"
  "  which clamps the membrane at reset value for some refractory time\n"
  "\n"
  "This spike mechanism is implemented as a regular NEURON membrane\n"
  "mechanism, and thus can be used in any compartment.  For faster\n"
  "versions of the IF model, see the IntFire mechanisms in NEURON.\n"
  "\n"
  "Parameters of the Brette-Gerstner-Izhikevich model:\n"
  "\n"
  "	a (uS)     : level of adaptation\n"
  "	b (nA)     : increment of adaptation at each spike\n"
  "	tau_w (ms) : time constant of adaptation\n"
  "	EL (mV)    : leak reversal (must be equal to the e_pas)\n"
  "	GL (S/cm2) : leak conductance (must be equal to g_pas)\n"
  "	delta (mV) : steepness of exponential approach to threshold\n"
  "	surf (um2) : cell area\n"
  "\n"
  "Additional parameters for spike generation:\n"
  "\n"
  "	Ref (ms)   : refractory period (Vm is clamped at reset value)\n"
  "	Vtop (mV)  : peak value of the spike\n"
  "	Vbot (mV)  : reset value\n"
  "	gna (S/cm2): gNa for spike\n"
  "	gkd (S/cm2): gKd for reset\n"
  "\n"
  "model 3: simpler IF mechanism, no spike duration\n"
  "model 4: store spike times in vector\n"
  "A Destexhe\n"
  "-----------------------------------------------------------------------------\n"
  "ENDCOMMENT\n"
  "\n"
  "INDEPENDENT {t FROM 0 TO 1 WITH 1 (ms)}\n"
  "\n"
  "NEURON {\n"
  "	SUFFIX IF_BG4\n"
  "	NONSPECIFIC_CURRENT i\n"
  "	RANGE w\n"
  "	RANGE a, b, tau_w, EL, GL, delta, surf\n"
  "	RANGE Vtr, Ref, Vbot, Vtop\n"
  "	RANGE spike, reset, gna, gkd, spiketimes, nspike\n"
  "}\n"
  "\n"
  "UNITS {\n"
  "	(mA) 	= (milliamp)\n"
  "	(nA) 	= (nanoamp)\n"
  "	(mV) 	= (millivolt)\n"
  "	(umho) 	= (micromho)\n"
  "	(um) 	= (micrometers)\n"
  "	(uS) 	= (microsiemens)\n"
  "}\n"
  "\n"
  "PARAMETER {\n"
  "	dt              (ms)\n"
  "\n"
  ": Brette-Gerstner-Izhikevich parameters : \n"
  "\n"
  "	a 	= 0	(uS)		: level of adaptation\n"
  "	b	= 0 (nA)		: increment of adaptation\n"
  "	tau_w	= 120 	(ms)    : time constant of adaptation\n"
  "	EL	= -70 	(mV)		: leak reversal (must be equal to e_pas)\n"
  "	GL	= 0 (mho/cm2)	    : leak conductance (must be equal to g_pas)\n"
  "	delta	= 2 	(mV)		: steepness of exponential approach to threshold\n"
  "	surf 	= 10000	(um2) 		: cell area\n"
  "\n"
  ": spike generation parameters :\n"
  "\n"
  "	Vtr 	= -45	(mV) 	: voltage threshold for spike\n"
  "	Ref	    = 5	    (ms) 	: refractory period (Vm is clamped at reset value)\n"
  "	Vtop	= 50	(mV)    : peak value of spike\n"
  "	Vbot	= -85	(mV)	: reset value\n"
  "	gna	= 1	(mho/cm2)	: very strong gNa for spike\n"
  "	gkd	= 1	(mho/cm2)	: very strong gKd for reset\n"
  "}\n"
  "\n"
  "\n"
  "ASSIGNED {\n"
  "	v		(mV)		: membrane potential\n"
  "	i		(mA/cm2)	: membrane current\n"
  "\n"
  "	reset	(ms)			: reset counter\n"
  "    spike				    : flag for spike\n"
  "	spiketimes[10000] (ms)  : vector for spike times\n"
  "	nspike				    : nb of spikes\n"
  "}\n"
  "\n"
  "STATE {\n"
  "	w   		(nA)\n"
  "}\n"
  "\n"
  "INITIAL {\n"
  "	spike = 0\n"
  "	reset = -1\n"
  "	w = 0\n"
  "	nspike = 0\n"
  "}\n"
  "\n"
  "BREAKPOINT {\n"
  "	SOLVE states METHOD euler\n"
  "	i = - GL * delta * exp((v-Vtr)/delta) + (100) * w/surf\n"
  "	fire()\n"
  "}\n"
  "\n"
  "\n"
  "DERIVATIVE states {		: solve eq for adaptation variable\n"
  "	\n"
  "	w'=(a*(v-EL)-w)/tau_w\n"
  "}\n"
  "PROCEDURE fire() { LOCAL q\n"
  "	reset = reset - dt\n"
  "	if(reset>0) {			: inside the reset ?\n"
  "		i = gkd * (v-Vbot)		: hyp current\n"
  "	} else if(spike) {		: inside spike ?\n"
  "		i = gna * (v-Vtop)		: dep current\n"
  "		spike = 0			: terminate spike\n"
  "		reset = Ref			: initiate reset\n"
  "	} else if(v>Vtr) {		: passing threshold ?\n"
  "		w = w + b			: increment adaptation var\n"
  "		i = gna * (v-Vtop)		: dep current\n"
  "		spike = 1			: initiate spike\n"
  "		spiketimes[nspike] = t		: store spike\n"
  "		nspike = nspike + 1\n"
  "  	}\n"
  "}\n"
  ;
#endif
