/* Created by Language version: 7.7.0 */
/* VECTORIZED */
#define NRN_VECTORIZED 1
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "mech_api.h"
#undef PI
#define nil 0
#include "md1redef.h"
#include "section.h"
#include "nrniv_mf.h"
#include "md2redef.h"
 
#if METHOD3
extern int _method3;
#endif

#if !NRNGPU
#undef exp
#define exp hoc_Exp
extern double hoc_Exp(double);
#endif
 
#define nrn_init _nrn_init__Single_AdEx
#define _nrn_initial _nrn_initial__Single_AdEx
#define nrn_cur _nrn_cur__Single_AdEx
#define _nrn_current _nrn_current__Single_AdEx
#define nrn_jacob _nrn_jacob__Single_AdEx
#define nrn_state _nrn_state__Single_AdEx
#define _net_receive _net_receive__Single_AdEx 
#define _f_rates _f_rates__Single_AdEx 
#define rates rates__Single_AdEx 
#define states states__Single_AdEx 
 
#define _threadargscomma_ _p, _ppvar, _thread, _nt,
#define _threadargsprotocomma_ double* _p, Datum* _ppvar, Datum* _thread, NrnThread* _nt,
#define _threadargs_ _p, _ppvar, _thread, _nt
#define _threadargsproto_ double* _p, Datum* _ppvar, Datum* _thread, NrnThread* _nt
 	/*SUPPRESS 761*/
	/*SUPPRESS 762*/
	/*SUPPRESS 763*/
	/*SUPPRESS 765*/
	 extern double *getarg();
 /* Thread safe. No static _p or _ppvar. */
 
#define t _nt->_t
#define dt _nt->_dt
#define gleak _p[0]
#define gleak_columnindex 0
#define el _p[1]
#define el_columnindex 1
#define gkltbar _p[2]
#define gkltbar_columnindex 2
#define eklt _p[3]
#define eklt_columnindex 3
#define phiz _p[4]
#define phiz_columnindex 4
#define betaz _p[5]
#define betaz_columnindex 5
#define gammaz _p[6]
#define gammaz_columnindex 6
#define gadaptslowbar _p[7]
#define gadaptslowbar_columnindex 7
#define eadaptslow _p[8]
#define eadaptslow_columnindex 8
#define betapslow _p[9]
#define betapslow_columnindex 9
#define gammapslow _p[10]
#define gammapslow_columnindex 10
#define taupslow _p[11]
#define taupslow_columnindex 11
#define gadaptbar _p[12]
#define gadaptbar_columnindex 12
#define eadapt _p[13]
#define eadapt_columnindex 13
#define betap _p[14]
#define betap_columnindex 14
#define gammap _p[15]
#define gammap_columnindex 15
#define taup _p[16]
#define taup_columnindex 16
#define gnabar _p[17]
#define gnabar_columnindex 17
#define betam _p[18]
#define betam_columnindex 18
#define gammam _p[19]
#define gammam_columnindex 19
#define gkbar _p[20]
#define gkbar_columnindex 20
#define phiw _p[21]
#define phiw_columnindex 21
#define betaw _p[22]
#define betaw_columnindex 22
#define gammaw _p[23]
#define gammaw_columnindex 23
#define gkabar _p[24]
#define gkabar_columnindex 24
#define eka _p[25]
#define eka_columnindex 25
#define phia _p[26]
#define phia_columnindex 26
#define phib _p[27]
#define phib_columnindex 27
#define gsubbar _p[28]
#define gsubbar_columnindex 28
#define esub _p[29]
#define esub_columnindex 29
#define betaq _p[30]
#define betaq_columnindex 30
#define gammaq _p[31]
#define gammaq_columnindex 31
#define tauq _p[32]
#define tauq_columnindex 32
#define ina _p[33]
#define ina_columnindex 33
#define ik _p[34]
#define ik_columnindex 34
#define il _p[35]
#define il_columnindex 35
#define iklt _p[36]
#define iklt_columnindex 36
#define ika _p[37]
#define ika_columnindex 37
#define iadapt _p[38]
#define iadapt_columnindex 38
#define isub _p[39]
#define isub_columnindex 39
#define iadapt2 _p[40]
#define iadapt2_columnindex 40
#define m _p[41]
#define m_columnindex 41
#define w _p[42]
#define w_columnindex 42
#define z _p[43]
#define z_columnindex 43
#define a _p[44]
#define a_columnindex 44
#define b _p[45]
#define b_columnindex 45
#define p _p[46]
#define p_columnindex 46
#define q _p[47]
#define q_columnindex 47
#define pslow _p[48]
#define pslow_columnindex 48
#define ena _p[49]
#define ena_columnindex 49
#define ek _p[50]
#define ek_columnindex 50
#define gk _p[51]
#define gk_columnindex 51
#define gna _p[52]
#define gna_columnindex 52
#define gklt _p[53]
#define gklt_columnindex 53
#define gka _p[54]
#define gka_columnindex 54
#define gadapt _p[55]
#define gadapt_columnindex 55
#define gsub _p[56]
#define gsub_columnindex 56
#define gadaptslow _p[57]
#define gadaptslow_columnindex 57
#define Dm _p[58]
#define Dm_columnindex 58
#define Dw _p[59]
#define Dw_columnindex 59
#define Dz _p[60]
#define Dz_columnindex 60
#define Da _p[61]
#define Da_columnindex 61
#define Db _p[62]
#define Db_columnindex 62
#define Dp _p[63]
#define Dp_columnindex 63
#define Dq _p[64]
#define Dq_columnindex 64
#define Dpslow _p[65]
#define Dpslow_columnindex 65
#define v _p[66]
#define v_columnindex 66
#define _g _p[67]
#define _g_columnindex 67
#define _ion_ek	*_ppvar[0]._pval
#define _ion_ik	*_ppvar[1]._pval
#define _ion_dikdv	*_ppvar[2]._pval
#define _ion_ena	*_ppvar[3]._pval
#define _ion_ina	*_ppvar[4]._pval
#define _ion_dinadv	*_ppvar[5]._pval
 
#if MAC
#if !defined(v)
#define v _mlhv
#endif
#if !defined(h)
#define h _mlhh
#endif
#endif
 
#if defined(__cplusplus)
extern "C" {
#endif
 static int hoc_nrnpointerindex =  -1;
 static Datum* _extcall_thread;
 static Prop* _extcall_prop;
 /* external NEURON variables */
 /* declaration of user functions */
 static void _hoc_rates(void);
 static int _mechtype;
extern void _nrn_cacheloop_reg(int, int);
extern void hoc_register_prop_size(int, int, int);
extern void hoc_register_limits(int, HocParmLimits*);
extern void hoc_register_units(int, HocParmUnits*);
extern void nrn_promote(Prop*, int, int);
extern Memb_func* memb_func;
 
#define NMODL_TEXT 1
#if NMODL_TEXT
static const char* nmodl_file_text;
static const char* nmodl_filename;
extern void hoc_reg_nmodl_text(int, const char*);
extern void hoc_reg_nmodl_filename(int, const char*);
#endif

 extern void _nrn_setdata_reg(int, void(*)(Prop*));
 static void _setdata(Prop* _prop) {
 _extcall_prop = _prop;
 }
 static void _hoc_setdata() {
 Prop *_prop, *hoc_getdata_range(int);
 _prop = hoc_getdata_range(_mechtype);
   _setdata(_prop);
 hoc_retpushx(1.);
}
 /* connect user functions to hoc names */
 static VoidFunc hoc_intfunc[] = {
 "setdata_Single_AdEx", _hoc_setdata,
 "rates_Single_AdEx", _hoc_rates,
 0, 0
};
 
static void _check_rates(double*, Datum*, Datum*, NrnThread*); 
static void _check_table_thread(double* _p, Datum* _ppvar, Datum* _thread, NrnThread* _nt, int _type) {
   _check_rates(_p, _ppvar, _thread, _nt);
 }
 /* declare global and static user variables */
 static int _thread1data_inuse = 0;
static double _thread1data[13];
#define _gth 0
#define ainf_Single_AdEx _thread1data[0]
#define ainf _thread[_gth]._pval[0]
#define binf_Single_AdEx _thread1data[1]
#define binf _thread[_gth]._pval[1]
#define minf_Single_AdEx _thread1data[2]
#define minf _thread[_gth]._pval[2]
#define pslowinf_Single_AdEx _thread1data[3]
#define pslowinf _thread[_gth]._pval[3]
#define pinf_Single_AdEx _thread1data[4]
#define pinf _thread[_gth]._pval[4]
#define qinf_Single_AdEx _thread1data[5]
#define qinf _thread[_gth]._pval[5]
#define taub_1_Single_AdEx _thread1data[6]
#define taub_1 _thread[_gth]._pval[6]
#define taub_Single_AdEx _thread1data[7]
#define taub _thread[_gth]._pval[7]
#define taua_Single_AdEx _thread1data[8]
#define taua _thread[_gth]._pval[8]
#define tauz_Single_AdEx _thread1data[9]
#define tauz _thread[_gth]._pval[9]
#define tauw_Single_AdEx _thread1data[10]
#define tauw _thread[_gth]._pval[10]
#define usetable usetable_Single_AdEx
 double usetable = 1;
#define winf_Single_AdEx _thread1data[11]
#define winf _thread[_gth]._pval[11]
#define zinf_Single_AdEx _thread1data[12]
#define zinf _thread[_gth]._pval[12]
 /* some parameters have upper and lower limits */
 static HocParmLimits _hoc_parm_limits[] = {
 "usetable_Single_AdEx", 0, 1,
 0,0,0
};
 static HocParmUnits _hoc_parm_units[] = {
 "tauw_Single_AdEx", "ms",
 "tauz_Single_AdEx", "ms",
 "taua_Single_AdEx", "ms",
 "taub_Single_AdEx", "ms",
 "taub_1_Single_AdEx", "ms",
 "gleak_Single_AdEx", "S/cm2",
 "el_Single_AdEx", "mV",
 "gkltbar_Single_AdEx", "S/cm2",
 "eklt_Single_AdEx", "mV",
 "betaz_Single_AdEx", "mV",
 "gammaz_Single_AdEx", "mV",
 "gadaptslowbar_Single_AdEx", "S/cm2",
 "eadaptslow_Single_AdEx", "mV",
 "betapslow_Single_AdEx", "mV",
 "gammapslow_Single_AdEx", "mV",
 "taupslow_Single_AdEx", "ms",
 "gadaptbar_Single_AdEx", "S/cm2",
 "eadapt_Single_AdEx", "mV",
 "betap_Single_AdEx", "mV",
 "gammap_Single_AdEx", "mV",
 "taup_Single_AdEx", "ms",
 "gnabar_Single_AdEx", "S/cm2",
 "betam_Single_AdEx", "mV",
 "gammam_Single_AdEx", "mV",
 "gkbar_Single_AdEx", "S/cm2",
 "betaw_Single_AdEx", "mV",
 "gammaw_Single_AdEx", "mV",
 "gkabar_Single_AdEx", "S/cm2",
 "eka_Single_AdEx", "mV",
 "gsubbar_Single_AdEx", "S/cm2",
 "esub_Single_AdEx", "mV",
 "betaq_Single_AdEx", "mV",
 "gammaq_Single_AdEx", "mV",
 "tauq_Single_AdEx", "ms",
 "ina_Single_AdEx", "mA/cm2",
 "ik_Single_AdEx", "mA/cm2",
 "il_Single_AdEx", "mA/cm2",
 "iklt_Single_AdEx", "mA/cm2",
 "ika_Single_AdEx", "mA/cm2",
 "iadapt_Single_AdEx", "mA/cm2",
 "isub_Single_AdEx", "mA/cm2",
 "iadapt2_Single_AdEx", "mA/cm2",
 0,0
};
 static double a0 = 0;
 static double b0 = 0;
 static double delta_t = 0.01;
 static double m0 = 0;
 static double pslow0 = 0;
 static double p0 = 0;
 static double q0 = 0;
 static double w0 = 0;
 static double z0 = 0;
 /* connect global user variables to hoc */
 static DoubScal hoc_scdoub[] = {
 "minf_Single_AdEx", &minf_Single_AdEx,
 "winf_Single_AdEx", &winf_Single_AdEx,
 "tauw_Single_AdEx", &tauw_Single_AdEx,
 "zinf_Single_AdEx", &zinf_Single_AdEx,
 "tauz_Single_AdEx", &tauz_Single_AdEx,
 "ainf_Single_AdEx", &ainf_Single_AdEx,
 "taua_Single_AdEx", &taua_Single_AdEx,
 "binf_Single_AdEx", &binf_Single_AdEx,
 "taub_Single_AdEx", &taub_Single_AdEx,
 "taub_1_Single_AdEx", &taub_1_Single_AdEx,
 "pinf_Single_AdEx", &pinf_Single_AdEx,
 "qinf_Single_AdEx", &qinf_Single_AdEx,
 "pslowinf_Single_AdEx", &pslowinf_Single_AdEx,
 "usetable_Single_AdEx", &usetable_Single_AdEx,
 0,0
};
 static DoubVec hoc_vdoub[] = {
 0,0,0
};
 static double _sav_indep;
 static void nrn_alloc(Prop*);
static void  nrn_init(NrnThread*, _Memb_list*, int);
static void nrn_state(NrnThread*, _Memb_list*, int);
 static void nrn_cur(NrnThread*, _Memb_list*, int);
static void  nrn_jacob(NrnThread*, _Memb_list*, int);
 
static int _ode_count(int);
static void _ode_map(int, double**, double**, double*, Datum*, double*, int);
static void _ode_spec(NrnThread*, _Memb_list*, int);
static void _ode_matsol(NrnThread*, _Memb_list*, int);
 
#define _cvode_ieq _ppvar[6]._i
 static void _ode_matsol_instance1(_threadargsproto_);
 /* connect range variables in _p that hoc is supposed to know about */
 static const char *_mechanism[] = {
 "7.7.0",
"Single_AdEx",
 "gleak_Single_AdEx",
 "el_Single_AdEx",
 "gkltbar_Single_AdEx",
 "eklt_Single_AdEx",
 "phiz_Single_AdEx",
 "betaz_Single_AdEx",
 "gammaz_Single_AdEx",
 "gadaptslowbar_Single_AdEx",
 "eadaptslow_Single_AdEx",
 "betapslow_Single_AdEx",
 "gammapslow_Single_AdEx",
 "taupslow_Single_AdEx",
 "gadaptbar_Single_AdEx",
 "eadapt_Single_AdEx",
 "betap_Single_AdEx",
 "gammap_Single_AdEx",
 "taup_Single_AdEx",
 "gnabar_Single_AdEx",
 "betam_Single_AdEx",
 "gammam_Single_AdEx",
 "gkbar_Single_AdEx",
 "phiw_Single_AdEx",
 "betaw_Single_AdEx",
 "gammaw_Single_AdEx",
 "gkabar_Single_AdEx",
 "eka_Single_AdEx",
 "phia_Single_AdEx",
 "phib_Single_AdEx",
 "gsubbar_Single_AdEx",
 "esub_Single_AdEx",
 "betaq_Single_AdEx",
 "gammaq_Single_AdEx",
 "tauq_Single_AdEx",
 0,
 "ina_Single_AdEx",
 "ik_Single_AdEx",
 "il_Single_AdEx",
 "iklt_Single_AdEx",
 "ika_Single_AdEx",
 "iadapt_Single_AdEx",
 "isub_Single_AdEx",
 "iadapt2_Single_AdEx",
 0,
 "m_Single_AdEx",
 "w_Single_AdEx",
 "z_Single_AdEx",
 "a_Single_AdEx",
 "b_Single_AdEx",
 "p_Single_AdEx",
 "q_Single_AdEx",
 "pslow_Single_AdEx",
 0,
 0};
 static Symbol* _k_sym;
 static Symbol* _na_sym;
 
extern Prop* need_memb(Symbol*);

static void nrn_alloc(Prop* _prop) {
	Prop *prop_ion;
	double *_p; Datum *_ppvar;
 	_p = nrn_prop_data_alloc(_mechtype, 68, _prop);
 	/*initialize range parameters*/
 	gleak = 5e-05;
 	el = -70;
 	gkltbar = 0.015;
 	eklt = -100;
 	phiz = 0.15;
 	betaz = -21;
 	gammaz = 15;
 	gadaptslowbar = 0.04;
 	eadaptslow = -100;
 	betapslow = 0;
 	gammapslow = 5;
 	taupslow = 40;
 	gadaptbar = 0.04;
 	eadapt = -100;
 	betap = 0;
 	gammap = 5;
 	taup = 5;
 	gnabar = 0;
 	betam = -1.2;
 	gammam = 18;
 	gkbar = 0;
 	phiw = 0.15;
 	betaw = -10;
 	gammaw = 10;
 	gkabar = 0;
 	eka = -100;
 	phia = 1;
 	phib = 1;
 	gsubbar = 0;
 	esub = 50;
 	betaq = -40;
 	gammaq = 10;
 	tauq = 2;
 	_prop->param = _p;
 	_prop->param_size = 68;
 	_ppvar = nrn_prop_datum_alloc(_mechtype, 7, _prop);
 	_prop->dparam = _ppvar;
 	/*connect ionic variables to this model*/
 prop_ion = need_memb(_k_sym);
 nrn_promote(prop_ion, 0, 1);
 	_ppvar[0]._pval = &prop_ion->param[0]; /* ek */
 	_ppvar[1]._pval = &prop_ion->param[3]; /* ik */
 	_ppvar[2]._pval = &prop_ion->param[4]; /* _ion_dikdv */
 prop_ion = need_memb(_na_sym);
 nrn_promote(prop_ion, 0, 1);
 	_ppvar[3]._pval = &prop_ion->param[0]; /* ena */
 	_ppvar[4]._pval = &prop_ion->param[3]; /* ina */
 	_ppvar[5]._pval = &prop_ion->param[4]; /* _ion_dinadv */
 
}
 static void _initlists();
  /* some states have an absolute tolerance */
 static Symbol** _atollist;
 static HocStateTolerance _hoc_state_tol[] = {
 0,0
};
 static void _thread_mem_init(Datum*);
 static void _thread_cleanup(Datum*);
 static void _update_ion_pointer(Datum*);
 extern Symbol* hoc_lookup(const char*);
extern void _nrn_thread_reg(int, int, void(*)(Datum*));
extern void _nrn_thread_table_reg(int, void(*)(double*, Datum*, Datum*, NrnThread*, int));
extern void hoc_register_tolerance(int, HocStateTolerance*, Symbol***);
extern void _cvode_abstol( Symbol**, double*, int);

 void _SDH_Single_AdEx_reg() {
	int _vectorized = 1;
  _initlists();
 	ion_reg("k", -10000.);
 	ion_reg("na", -10000.);
 	_k_sym = hoc_lookup("k_ion");
 	_na_sym = hoc_lookup("na_ion");
 	register_mech(_mechanism, nrn_alloc,nrn_cur, nrn_jacob, nrn_state, nrn_init, hoc_nrnpointerindex, 2);
  _extcall_thread = (Datum*)ecalloc(1, sizeof(Datum));
  _thread_mem_init(_extcall_thread);
  _thread1data_inuse = 0;
 _mechtype = nrn_get_mechtype(_mechanism[1]);
     _nrn_setdata_reg(_mechtype, _setdata);
     _nrn_thread_reg(_mechtype, 1, _thread_mem_init);
     _nrn_thread_reg(_mechtype, 0, _thread_cleanup);
     _nrn_thread_reg(_mechtype, 2, _update_ion_pointer);
     _nrn_thread_table_reg(_mechtype, _check_table_thread);
 #if NMODL_TEXT
  hoc_reg_nmodl_text(_mechtype, nmodl_file_text);
  hoc_reg_nmodl_filename(_mechtype, nmodl_filename);
#endif
  hoc_register_prop_size(_mechtype, 68, 7);
  hoc_register_dparam_semantics(_mechtype, 0, "k_ion");
  hoc_register_dparam_semantics(_mechtype, 1, "k_ion");
  hoc_register_dparam_semantics(_mechtype, 2, "k_ion");
  hoc_register_dparam_semantics(_mechtype, 3, "na_ion");
  hoc_register_dparam_semantics(_mechtype, 4, "na_ion");
  hoc_register_dparam_semantics(_mechtype, 5, "na_ion");
  hoc_register_dparam_semantics(_mechtype, 6, "cvodeieq");
 	hoc_register_cvode(_mechtype, _ode_count, _ode_map, _ode_spec, _ode_matsol);
 	hoc_register_tolerance(_mechtype, _hoc_state_tol, &_atollist);
 	hoc_register_var(hoc_scdoub, hoc_vdoub, hoc_intfunc);
 	ivoc_help("help ?1 Single_AdEx /Users/lauramedlock/Downloads/RF-Model/mods/SDH_Single_AdEx.mod\n");
 hoc_register_limits(_mechtype, _hoc_parm_limits);
 hoc_register_units(_mechtype, _hoc_parm_units);
 }
 static double *_t_minf;
 static double *_t_winf;
 static double *_t_tauw;
 static double *_t_zinf;
 static double *_t_tauz;
 static double *_t_ainf;
 static double *_t_taua;
 static double *_t_binf;
 static double *_t_taub_1;
 static double *_t_pinf;
 static double *_t_taub;
 static double *_t_pslowinf;
 static double *_t_qinf;
static int _reset;
static char *modelname = "SDH Neuron - Single Firing with AdEx ";

static int error;
static int _ninits = 0;
static int _match_recurse=1;
static void _modl_cleanup(){ _match_recurse=1;}
static int _f_rates(_threadargsprotocomma_ double);
static int rates(_threadargsprotocomma_ double);
 
static int _ode_spec1(_threadargsproto_);
/*static int _ode_matsol1(_threadargsproto_);*/
 static void _n_rates(_threadargsprotocomma_ double _lv);
 static int _slist1[7], _dlist1[7];
 static int states(_threadargsproto_);
 
/*CVODE*/
 static int _ode_spec1 (double* _p, Datum* _ppvar, Datum* _thread, NrnThread* _nt) {int _reset = 0; {
   rates ( _threadargscomma_ v ) ;
   m = minf ;
   Dw = phiw * ( winf - w ) / tauw ;
   Dz = phiz * ( zinf - z ) / tauz ;
   Da = phia * ( ainf - a ) / taua ;
   Db = phib * ( binf - b ) / taub ;
   Dp = ( pinf - p ) / taup ;
   Dpslow = ( pslowinf - pslow ) / taupslow ;
   Dq = ( qinf - q ) / tauq ;
   }
 return _reset;
}
 static int _ode_matsol1 (double* _p, Datum* _ppvar, Datum* _thread, NrnThread* _nt) {
 rates ( _threadargscomma_ v ) ;
 m = minf ;
 Dw = Dw  / (1. - dt*( ( ( phiw )*( ( ( - 1.0 ) ) ) ) / tauw )) ;
 Dz = Dz  / (1. - dt*( ( ( phiz )*( ( ( - 1.0 ) ) ) ) / tauz )) ;
 Da = Da  / (1. - dt*( ( ( phia )*( ( ( - 1.0 ) ) ) ) / taua )) ;
 Db = Db  / (1. - dt*( ( ( phib )*( ( ( - 1.0 ) ) ) ) / taub )) ;
 Dp = Dp  / (1. - dt*( ( ( ( - 1.0 ) ) ) / taup )) ;
 Dpslow = Dpslow  / (1. - dt*( ( ( ( - 1.0 ) ) ) / taupslow )) ;
 Dq = Dq  / (1. - dt*( ( ( ( - 1.0 ) ) ) / tauq )) ;
  return 0;
}
 /*END CVODE*/
 static int states (double* _p, Datum* _ppvar, Datum* _thread, NrnThread* _nt) { {
   rates ( _threadargscomma_ v ) ;
   m = minf ;
    w = w + (1. - exp(dt*(( ( phiw )*( ( ( - 1.0 ) ) ) ) / tauw)))*(- ( ( ( phiw )*( ( winf ) ) ) / tauw ) / ( ( ( phiw )*( ( ( - 1.0 ) ) ) ) / tauw ) - w) ;
    z = z + (1. - exp(dt*(( ( phiz )*( ( ( - 1.0 ) ) ) ) / tauz)))*(- ( ( ( phiz )*( ( zinf ) ) ) / tauz ) / ( ( ( phiz )*( ( ( - 1.0 ) ) ) ) / tauz ) - z) ;
    a = a + (1. - exp(dt*(( ( phia )*( ( ( - 1.0 ) ) ) ) / taua)))*(- ( ( ( phia )*( ( ainf ) ) ) / taua ) / ( ( ( phia )*( ( ( - 1.0 ) ) ) ) / taua ) - a) ;
    b = b + (1. - exp(dt*(( ( phib )*( ( ( - 1.0 ) ) ) ) / taub)))*(- ( ( ( phib )*( ( binf ) ) ) / taub ) / ( ( ( phib )*( ( ( - 1.0 ) ) ) ) / taub ) - b) ;
    p = p + (1. - exp(dt*(( ( ( - 1.0 ) ) ) / taup)))*(- ( ( ( pinf ) ) / taup ) / ( ( ( ( - 1.0 ) ) ) / taup ) - p) ;
    pslow = pslow + (1. - exp(dt*(( ( ( - 1.0 ) ) ) / taupslow)))*(- ( ( ( pslowinf ) ) / taupslow ) / ( ( ( ( - 1.0 ) ) ) / taupslow ) - pslow) ;
    q = q + (1. - exp(dt*(( ( ( - 1.0 ) ) ) / tauq)))*(- ( ( ( qinf ) ) / tauq ) / ( ( ( ( - 1.0 ) ) ) / tauq ) - q) ;
   }
  return 0;
}
 static double _mfac_rates, _tmin_rates;
  static void _check_rates(double* _p, Datum* _ppvar, Datum* _thread, NrnThread* _nt) {
  static int _maktable=1; int _i, _j, _ix = 0;
  double _xi, _tmax;
  if (!usetable) {return;}
  if (_maktable) { double _x, _dx; _maktable=0;
   _tmin_rates =  - 100.0 ;
   _tmax =  100.0 ;
   _dx = (_tmax - _tmin_rates)/200.; _mfac_rates = 1./_dx;
   for (_i=0, _x=_tmin_rates; _i < 201; _x += _dx, _i++) {
    _f_rates(_p, _ppvar, _thread, _nt, _x);
    _t_minf[_i] = minf;
    _t_winf[_i] = winf;
    _t_tauw[_i] = tauw;
    _t_zinf[_i] = zinf;
    _t_tauz[_i] = tauz;
    _t_ainf[_i] = ainf;
    _t_taua[_i] = taua;
    _t_binf[_i] = binf;
    _t_taub_1[_i] = taub_1;
    _t_pinf[_i] = pinf;
    _t_taub[_i] = taub;
    _t_pslowinf[_i] = pslowinf;
    _t_qinf[_i] = qinf;
   }
  }
 }

 static int rates(double* _p, Datum* _ppvar, Datum* _thread, NrnThread* _nt, double _lv) { 
#if 0
_check_rates(_p, _ppvar, _thread, _nt);
#endif
 _n_rates(_p, _ppvar, _thread, _nt, _lv);
 return 0;
 }

 static void _n_rates(double* _p, Datum* _ppvar, Datum* _thread, NrnThread* _nt, double _lv){ int _i, _j;
 double _xi, _theta;
 if (!usetable) {
 _f_rates(_p, _ppvar, _thread, _nt, _lv); return; 
}
 _xi = _mfac_rates * (_lv - _tmin_rates);
 if (isnan(_xi)) {
  minf = _xi;
  winf = _xi;
  tauw = _xi;
  zinf = _xi;
  tauz = _xi;
  ainf = _xi;
  taua = _xi;
  binf = _xi;
  taub_1 = _xi;
  pinf = _xi;
  taub = _xi;
  pslowinf = _xi;
  qinf = _xi;
  return;
 }
 if (_xi <= 0.) {
 minf = _t_minf[0];
 winf = _t_winf[0];
 tauw = _t_tauw[0];
 zinf = _t_zinf[0];
 tauz = _t_tauz[0];
 ainf = _t_ainf[0];
 taua = _t_taua[0];
 binf = _t_binf[0];
 taub_1 = _t_taub_1[0];
 pinf = _t_pinf[0];
 taub = _t_taub[0];
 pslowinf = _t_pslowinf[0];
 qinf = _t_qinf[0];
 return; }
 if (_xi >= 200.) {
 minf = _t_minf[200];
 winf = _t_winf[200];
 tauw = _t_tauw[200];
 zinf = _t_zinf[200];
 tauz = _t_tauz[200];
 ainf = _t_ainf[200];
 taua = _t_taua[200];
 binf = _t_binf[200];
 taub_1 = _t_taub_1[200];
 pinf = _t_pinf[200];
 taub = _t_taub[200];
 pslowinf = _t_pslowinf[200];
 qinf = _t_qinf[200];
 return; }
 _i = (int) _xi;
 _theta = _xi - (double)_i;
 minf = _t_minf[_i] + _theta*(_t_minf[_i+1] - _t_minf[_i]);
 winf = _t_winf[_i] + _theta*(_t_winf[_i+1] - _t_winf[_i]);
 tauw = _t_tauw[_i] + _theta*(_t_tauw[_i+1] - _t_tauw[_i]);
 zinf = _t_zinf[_i] + _theta*(_t_zinf[_i+1] - _t_zinf[_i]);
 tauz = _t_tauz[_i] + _theta*(_t_tauz[_i+1] - _t_tauz[_i]);
 ainf = _t_ainf[_i] + _theta*(_t_ainf[_i+1] - _t_ainf[_i]);
 taua = _t_taua[_i] + _theta*(_t_taua[_i+1] - _t_taua[_i]);
 binf = _t_binf[_i] + _theta*(_t_binf[_i+1] - _t_binf[_i]);
 taub_1 = _t_taub_1[_i] + _theta*(_t_taub_1[_i+1] - _t_taub_1[_i]);
 pinf = _t_pinf[_i] + _theta*(_t_pinf[_i+1] - _t_pinf[_i]);
 taub = _t_taub[_i] + _theta*(_t_taub[_i+1] - _t_taub[_i]);
 pslowinf = _t_pslowinf[_i] + _theta*(_t_pslowinf[_i+1] - _t_pslowinf[_i]);
 qinf = _t_qinf[_i] + _theta*(_t_qinf[_i+1] - _t_qinf[_i]);
 }

 
static int  _f_rates ( _threadargsprotocomma_ double _lv ) {
   minf = 0.5 * ( 1.0 + tanh ( ( _lv - betam ) / gammam ) ) ;
   winf = 0.5 * ( 1.0 + tanh ( ( _lv - betaw ) / gammaw ) ) ;
   tauw = 1.0 / ( cosh ( ( _lv - betaw ) / ( 2.0 * gammaw ) ) ) ;
   zinf = 0.5 * ( 1.0 + tanh ( ( _lv - betaz ) / gammaz ) ) ;
   tauz = 1.0 / ( cosh ( ( _lv - betaz ) / ( 2.0 * gammaz ) ) ) ;
   ainf = ( 1.0 / ( 1.0 + exp ( - ( ( _lv + 65.0 ) / 8.5 ) ) ) ) ;
   taua = 1.0 / ( exp ( ( _lv + 35.82 ) / 19.69 ) + exp ( - ( _lv + 79.69 ) / 12.7 ) ) + 0.37 ;
   binf = ( 1.0 / ( 1.0 + exp ( ( _lv + 78.0 ) / 6.0 ) ) ) ;
   taub_1 = 1.0 / ( ( exp ( ( _lv + 46.05 ) / 5.0 ) + exp ( - ( _lv + 238.4 ) / 37.45 ) ) ) ;
   if ( _lv < - 63.0 ) {
     taub = taub_1 ;
     }
   else {
     taub = 19.0 ;
     }
   pinf = ( 1.0 / ( 1.0 + exp ( ( betap - _lv ) / gammap ) ) ) ;
   pslowinf = ( 1.0 / ( 1.0 + exp ( ( betapslow - _lv ) / gammapslow ) ) ) ;
   qinf = ( 1.0 / ( 1.0 + exp ( ( betaq - _lv ) / gammaq ) ) ) ;
    return 0; }
 
static void _hoc_rates(void) {
  double _r;
   double* _p; Datum* _ppvar; Datum* _thread; NrnThread* _nt;
   if (_extcall_prop) {_p = _extcall_prop->param; _ppvar = _extcall_prop->dparam;}else{ _p = (double*)0; _ppvar = (Datum*)0; }
  _thread = _extcall_thread;
  _nt = nrn_threads;
 
#if 1
 _check_rates(_p, _ppvar, _thread, _nt);
#endif
 _r = 1.;
 rates ( _p, _ppvar, _thread, _nt, *getarg(1) );
 hoc_retpushx(_r);
}
 
static int _ode_count(int _type){ return 7;}
 
static void _ode_spec(NrnThread* _nt, _Memb_list* _ml, int _type) {
   double* _p; Datum* _ppvar; Datum* _thread;
   Node* _nd; double _v; int _iml, _cntml;
  _cntml = _ml->_nodecount;
  _thread = _ml->_thread;
  for (_iml = 0; _iml < _cntml; ++_iml) {
    _p = _ml->_data[_iml]; _ppvar = _ml->_pdata[_iml];
    _nd = _ml->_nodelist[_iml];
    v = NODEV(_nd);
  ek = _ion_ek;
  ena = _ion_ena;
     _ode_spec1 (_p, _ppvar, _thread, _nt);
   }}
 
static void _ode_map(int _ieq, double** _pv, double** _pvdot, double* _pp, Datum* _ppd, double* _atol, int _type) { 
	double* _p; Datum* _ppvar;
 	int _i; _p = _pp; _ppvar = _ppd;
	_cvode_ieq = _ieq;
	for (_i=0; _i < 7; ++_i) {
		_pv[_i] = _pp + _slist1[_i];  _pvdot[_i] = _pp + _dlist1[_i];
		_cvode_abstol(_atollist, _atol, _i);
	}
 }
 
static void _ode_matsol_instance1(_threadargsproto_) {
 _ode_matsol1 (_p, _ppvar, _thread, _nt);
 }
 
static void _ode_matsol(NrnThread* _nt, _Memb_list* _ml, int _type) {
   double* _p; Datum* _ppvar; Datum* _thread;
   Node* _nd; double _v; int _iml, _cntml;
  _cntml = _ml->_nodecount;
  _thread = _ml->_thread;
  for (_iml = 0; _iml < _cntml; ++_iml) {
    _p = _ml->_data[_iml]; _ppvar = _ml->_pdata[_iml];
    _nd = _ml->_nodelist[_iml];
    v = NODEV(_nd);
  ek = _ion_ek;
  ena = _ion_ena;
 _ode_matsol_instance1(_threadargs_);
 }}
 
static void _thread_mem_init(Datum* _thread) {
  if (_thread1data_inuse) {_thread[_gth]._pval = (double*)ecalloc(13, sizeof(double));
 }else{
 _thread[_gth]._pval = _thread1data; _thread1data_inuse = 1;
 }
 }
 
static void _thread_cleanup(Datum* _thread) {
  if (_thread[_gth]._pval == _thread1data) {
   _thread1data_inuse = 0;
  }else{
   free((void*)_thread[_gth]._pval);
  }
 }
 extern void nrn_update_ion_pointer(Symbol*, Datum*, int, int);
 static void _update_ion_pointer(Datum* _ppvar) {
   nrn_update_ion_pointer(_k_sym, _ppvar, 0, 0);
   nrn_update_ion_pointer(_k_sym, _ppvar, 1, 3);
   nrn_update_ion_pointer(_k_sym, _ppvar, 2, 4);
   nrn_update_ion_pointer(_na_sym, _ppvar, 3, 0);
   nrn_update_ion_pointer(_na_sym, _ppvar, 4, 3);
   nrn_update_ion_pointer(_na_sym, _ppvar, 5, 4);
 }

static void initmodel(double* _p, Datum* _ppvar, Datum* _thread, NrnThread* _nt) {
  int _i; double _save;{
  a = a0;
  b = b0;
  m = m0;
  pslow = pslow0;
  p = p0;
  q = q0;
  w = w0;
  z = z0;
 {
   rates ( _threadargscomma_ v ) ;
   m = minf ;
   w = winf ;
   z = zinf ;
   a = ainf ;
   b = binf ;
   p = pinf ;
   q = qinf ;
   pslow = pslowinf ;
   }
 
}
}

static void nrn_init(NrnThread* _nt, _Memb_list* _ml, int _type){
double* _p; Datum* _ppvar; Datum* _thread;
Node *_nd; double _v; int* _ni; int _iml, _cntml;
#if CACHEVEC
    _ni = _ml->_nodeindices;
#endif
_cntml = _ml->_nodecount;
_thread = _ml->_thread;
for (_iml = 0; _iml < _cntml; ++_iml) {
 _p = _ml->_data[_iml]; _ppvar = _ml->_pdata[_iml];

#if 0
 _check_rates(_p, _ppvar, _thread, _nt);
#endif
#if CACHEVEC
  if (use_cachevec) {
    _v = VEC_V(_ni[_iml]);
  }else
#endif
  {
    _nd = _ml->_nodelist[_iml];
    _v = NODEV(_nd);
  }
 v = _v;
  ek = _ion_ek;
  ena = _ion_ena;
 initmodel(_p, _ppvar, _thread, _nt);
  }
}

static double _nrn_current(double* _p, Datum* _ppvar, Datum* _thread, NrnThread* _nt, double _v){double _current=0.;v=_v;{ {
   gna = gnabar * m ;
   gk = gkbar * w ;
   gklt = gkltbar * z ;
   gka = gkabar * pow( a , 4.0 ) * b ;
   gadapt = gadaptbar * p ;
   gadaptslow = gadaptslowbar * pslow ;
   gsub = gsubbar * q ;
   ik = gk * ( v - ek ) ;
   ina = gna * ( v - ena ) ;
   il = gleak * ( v - el ) ;
   iklt = gklt * ( v - eklt ) ;
   ika = gka * ( v - eka ) ;
   iadapt = gadapt * ( v - eadapt ) ;
   iadapt2 = gadaptslow * ( v - eadaptslow ) ;
   isub = gsub * ( v - esub ) ;
   }
 _current += ik;
 _current += ina;
 _current += il;
 _current += iklt;
 _current += ika;
 _current += iadapt;
 _current += isub;
 _current += iadapt2;

} return _current;
}

static void nrn_cur(NrnThread* _nt, _Memb_list* _ml, int _type) {
double* _p; Datum* _ppvar; Datum* _thread;
Node *_nd; int* _ni; double _rhs, _v; int _iml, _cntml;
#if CACHEVEC
    _ni = _ml->_nodeindices;
#endif
_cntml = _ml->_nodecount;
_thread = _ml->_thread;
for (_iml = 0; _iml < _cntml; ++_iml) {
 _p = _ml->_data[_iml]; _ppvar = _ml->_pdata[_iml];
#if CACHEVEC
  if (use_cachevec) {
    _v = VEC_V(_ni[_iml]);
  }else
#endif
  {
    _nd = _ml->_nodelist[_iml];
    _v = NODEV(_nd);
  }
  ek = _ion_ek;
  ena = _ion_ena;
 _g = _nrn_current(_p, _ppvar, _thread, _nt, _v + .001);
 	{ double _dina;
 double _dik;
  _dik = ik;
  _dina = ina;
 _rhs = _nrn_current(_p, _ppvar, _thread, _nt, _v);
  _ion_dikdv += (_dik - ik)/.001 ;
  _ion_dinadv += (_dina - ina)/.001 ;
 	}
 _g = (_g - _rhs)/.001;
  _ion_ik += ik ;
  _ion_ina += ina ;
#if CACHEVEC
  if (use_cachevec) {
	VEC_RHS(_ni[_iml]) -= _rhs;
  }else
#endif
  {
	NODERHS(_nd) -= _rhs;
  }
 
}
 
}

static void nrn_jacob(NrnThread* _nt, _Memb_list* _ml, int _type) {
double* _p; Datum* _ppvar; Datum* _thread;
Node *_nd; int* _ni; int _iml, _cntml;
#if CACHEVEC
    _ni = _ml->_nodeindices;
#endif
_cntml = _ml->_nodecount;
_thread = _ml->_thread;
for (_iml = 0; _iml < _cntml; ++_iml) {
 _p = _ml->_data[_iml];
#if CACHEVEC
  if (use_cachevec) {
	VEC_D(_ni[_iml]) += _g;
  }else
#endif
  {
     _nd = _ml->_nodelist[_iml];
	NODED(_nd) += _g;
  }
 
}
 
}

static void nrn_state(NrnThread* _nt, _Memb_list* _ml, int _type) {
double* _p; Datum* _ppvar; Datum* _thread;
Node *_nd; double _v = 0.0; int* _ni; int _iml, _cntml;
#if CACHEVEC
    _ni = _ml->_nodeindices;
#endif
_cntml = _ml->_nodecount;
_thread = _ml->_thread;
for (_iml = 0; _iml < _cntml; ++_iml) {
 _p = _ml->_data[_iml]; _ppvar = _ml->_pdata[_iml];
 _nd = _ml->_nodelist[_iml];
#if CACHEVEC
  if (use_cachevec) {
    _v = VEC_V(_ni[_iml]);
  }else
#endif
  {
    _nd = _ml->_nodelist[_iml];
    _v = NODEV(_nd);
  }
 v=_v;
{
  ek = _ion_ek;
  ena = _ion_ena;
 {   states(_p, _ppvar, _thread, _nt);
  }  }}

}

static void terminal(){}

static void _initlists(){
 double _x; double* _p = &_x;
 int _i; static int _first = 1;
  if (!_first) return;
 _slist1[0] = w_columnindex;  _dlist1[0] = Dw_columnindex;
 _slist1[1] = z_columnindex;  _dlist1[1] = Dz_columnindex;
 _slist1[2] = a_columnindex;  _dlist1[2] = Da_columnindex;
 _slist1[3] = b_columnindex;  _dlist1[3] = Db_columnindex;
 _slist1[4] = p_columnindex;  _dlist1[4] = Dp_columnindex;
 _slist1[5] = pslow_columnindex;  _dlist1[5] = Dpslow_columnindex;
 _slist1[6] = q_columnindex;  _dlist1[6] = Dq_columnindex;
   _t_minf = makevector(201*sizeof(double));
   _t_winf = makevector(201*sizeof(double));
   _t_tauw = makevector(201*sizeof(double));
   _t_zinf = makevector(201*sizeof(double));
   _t_tauz = makevector(201*sizeof(double));
   _t_ainf = makevector(201*sizeof(double));
   _t_taua = makevector(201*sizeof(double));
   _t_binf = makevector(201*sizeof(double));
   _t_taub_1 = makevector(201*sizeof(double));
   _t_pinf = makevector(201*sizeof(double));
   _t_taub = makevector(201*sizeof(double));
   _t_pslowinf = makevector(201*sizeof(double));
   _t_qinf = makevector(201*sizeof(double));
_first = 0;
}

#if defined(__cplusplus)
} /* extern "C" */
#endif

#if NMODL_TEXT
static const char* nmodl_filename = "/Users/lauramedlock/Downloads/RF-Model/mods/SDH_Single_AdEx.mod";
static const char* nmodl_file_text = 
  "TITLE SDH Neuron - Single Firing with AdEx \n"
  "\n"
  "COMMENT\n"
  "AdEx + IL, Iadapt, Iadapt2, Isub, IK_A, IK_lt\n"
  "\n"
  "Implemented by L Medlock \n"
  "ENDCOMMENT\n"
  "\n"
  "\n"
  "NEURON {\n"
  "  SUFFIX Single_AdEx\n"
  "  USEION k READ ek WRITE ik\n"
  "  USEION na READ ena WRITE ina\n"
  "  NONSPECIFIC_CURRENT il, iklt, ika, iadapt, isub, iadapt2\n"
  "  RANGE gnabar, gkbar, gleak, gkltbar, gkabar, gadaptbar, gadaptslowbar, gsubbar, el, eklt, eadapt, eadaptslow, eka, esub, ina, ik, il, iklt, ika, iadapt, iadapt2, isub\n"
  "  RANGE betam, gammam, phiw, betaw, gammaw, phiz, betaz, gammaz, phia, phib, betap, gammap, taup, betaq, gammaq, tauq, betapslow, gammapslow, taupslow\n"
  "  GLOBAL minf, winf, tauw, zinf, tauz, ainf, taua, binf, taub, pinf, qinf, pslowinf, taub_1\n"
  "  THREADSAFE\n"
  "}\n"
  "\n"
  "UNITS {\n"
  "	(mV) = (millivolt)\n"
  "	(mA) = (milliamp)\n"
  "	(S)  = (siemens)\n"
  "}\n"
  "\n"
  "PARAMETER {\n"
  "  v (mV)\n"
  "  dt (ms)\n"
  "  \n"
  "  :Ileak\n"
  "  gleak  = 0.00005 (S/cm2)  : same as delay\n"
  "  el = -70 (mV)\n"
  "\n"
  "  : IK_lt  (low-threshold non-inactivating (Kv1-type) potassium)\n"
  "  gkltbar = 0.015 (S/cm2) : unique to neuron\n"
  "  eklt = -100 (mV)  \n"
  "  phiz = 0.15\n"
  "  betaz = -21 (mV)\n"
  "  gammaz = 15 (mV)\n"
  "\n"
  "  : Iadapt2 (slower AHP) from Ratte et al. (2015)\n"
  "  gadaptslowbar = 0.04 (S/cm2)  : same as tonic\n"
  "  eadaptslow = -100 (mV)       \n"
  "  betapslow = 0 (mV)\n"
  "  gammapslow = 5 (mV)\n"
  "  taupslow = 40 (ms)\n"
  "\n"
  "  : Iadapt (AHP-like current) from Ratte et al. (2015)\n"
  "  gadaptbar = 0.04 (S/cm2)        : same as tonic\n"
  "  eadapt = -100 (mV) \n"
  "  betap = 0 (mV)\n"
  "  gammap = 5 (mV)\n"
  "  taup = 5 (ms)\n"
  "\n"
  "  : INa\n"
  "  gnabar = 0 (S/cm2)   \n"
  "  ena = 50 (mV) \n"
  "  betam  = -1.2 (mV)\n"
  "  gammam = 18 (mV)\n"
  "\n"
  "  : IK_dr (delayed-rectifier K+ current)\n"
  "  gkbar  = 0 (S/cm2)\n"
  "  ek = -100 (mV)\n"
  "  phiw = 0.15\n"
  "  betaw = -10 (mV)\n"
  "  gammaw = 10 (mV)\n"
  "\n"
  "  : IK_A (inactivating (A-type) potassium)\n"
  "  gkabar = 0 (S/cm2)  : Changes per neuron type\n"
  "  eka = -100 (mV) \n"
  "  phia = 1.0\n"
  "  phib = 1.0\n"
  "\n"
  "  : Isub (subthreshold inward current) from Ratte et al. (2015)\n"
  "  gsubbar = 0 (S/cm2)       \n"
  "  esub = 50 (mV) \n"
  "  betaq = -40 (mV)\n"
  "  gammaq = 10 (mV)\n"
  "  tauq = 2 (ms)\n"
  "\n"
  "}\n"
  "\n"
  "ASSIGNED {\n"
  "  ina (mA/cm2)\n"
  "	ik (mA/cm2)\n"
  "  il (mA/cm2)\n"
  "  iklt (mA/cm2)\n"
  "  ika (mA/cm2)\n"
  "  iadapt (mA/cm2)\n"
  "  isub (mA/cm2)\n"
  "  iadapt2 (mA/cm2)\n"
  "  gk (S/cm2)  \n"
  "  gna (S/cm2) \n"
  "  gklt (S/cm2)\n"
  "  gka (S/cm2)\n"
  "  gadapt (S/cm2)\n"
  "  gsub (S/cm2)\n"
  "  gadaptslow (S/cm2)\n"
  "	minf\n"
  "	winf\n"
  "	tauw (ms)\n"
  "  zinf\n"
  "  tauz (ms)\n"
  "  ainf\n"
  "  taua (ms)\n"
  "  binf\n"
  "  taub (ms)\n"
  "  taub_1 (ms)\n"
  "  pinf\n"
  "  qinf\n"
  "  pslowinf\n"
  "}\n"
  "\n"
  "STATE {\n"
  "	m   FROM 0 TO 1\n"
  "  w   FROM 0 TO 1\n"
  "  z   FROM 0 TO 1\n"
  "  a   FROM 0 TO 1\n"
  "  b   FROM 0 TO 1\n"
  "  p   FROM 0 TO 1\n"
  "  q   FROM 0 TO 1\n"
  "  pslow FROM 0 TO 1\n"
  "}\n"
  "\n"
  "INITIAL {\n"
  "  rates(v)\n"
  "  m = minf\n"
  "  w = winf\n"
  "  z = zinf\n"
  "  a = ainf\n"
  "  b = binf\n"
  "  p = pinf\n"
  "  q = qinf\n"
  "  pslow = pslowinf\n"
  "}\n"
  "\n"
  "BREAKPOINT {\n"
  "	SOLVE states METHOD cnexp\n"
  "  gna = gnabar * m\n"
  "  gk  = gkbar * w  \n"
  "  gklt = gkltbar * z\n"
  "  gka = gkabar * a^4 * b\n"
  "  gadapt = gadaptbar * p\n"
  "  gadaptslow = gadaptslowbar * pslow\n"
  "  gsub = gsubbar * q\n"
  "\n"
  "	ik  = gk * (v - ek)\n"
  "  ina = gna * (v - ena)\n"
  "  il  = gleak * (v - el)\n"
  "  iklt = gklt * (v - eklt)\n"
  "  ika = gka * (v - eka)\n"
  "  iadapt = gadapt * (v - eadapt)\n"
  "  iadapt2 = gadaptslow * (v - eadaptslow)\n"
  "  isub = gsub * (v - esub)\n"
  "}\n"
  "\n"
  "DERIVATIVE states {\n"
  "	rates(v)\n"
  "  : Sodium Current (INa)\n"
  "  m = minf\n"
  "  : Delayed Rectifier K+ Current (IK_dr)\n"
  "  w' = phiw*(winf-w)/tauw\n"
  "  : Low-Threshold K+ Current (IK_lt)\n"
  "  z' = phiz*(zinf-z)/tauz\n"
  "  : A-type K+ Current (IK_A)\n"
  "  a' = phia*(ainf-a)/taua\n"
  "  b' = phib*(binf-b)/taub\n"
  "  : Adapting (AHP) Current (Iadapt)\n"
  "  p' = (pinf-p)/taup\n"
  "  : Slow AHP Current (Iadapt2)\n"
  "  pslow' = (pslowinf-pslow)/taupslow\n"
  "  : Inward Subthreshold Current (Isub)\n"
  "  q' = (qinf-q)/tauq\n"
  "}\n"
  "\n"
  "\n"
  "PROCEDURE rates( v (mV) ) {\n"
  "  TABLE minf, winf, tauw, zinf, tauz, ainf, taua, binf, taub_1, pinf, taub, pslowinf, qinf FROM -100 TO 100 WITH 200\n"
  "  : Fast Activating Inward Current (INa):\n"
  "  minf = 0.5*(1 + tanh((v-betam)/gammam))\n"
  "  : Delayed Rectifier K+ Current (IK_dr)\n"
  "  winf = 0.5*(1 + tanh((v-betaw)/gammaw))\n"
  "  tauw = 1/(cosh((v-betaw)/(2*gammaw)))\n"
  "  : Low-Threshold K+ Current (IK_lt)\n"
  "  zinf = 0.5*(1 + tanh((v-betaz)/gammaz))\n"
  "  tauz = 1/(cosh((v-betaz)/(2*gammaz)))\n"
  "  : A-type K+ Current (IK_A)\n"
  "  ainf = (1 / (1 + exp(-((v+65)/8.5))))\n"
  "  taua = 1/(exp((v+35.82)/19.69)+exp(-(v+79.69)/12.7)) + 0.37\n"
  "  binf = (1 / (1 + exp((v+78)/6)))\n"
  "  taub_1 = 1/((exp((v+46.05)/5)+exp(-(v+238.4)/37.45)))\n"
  "  if (v<-63) {\n"
  "		taub = taub_1\n"
  "		}\n"
  "	else {\n"
  "		taub = 19\n"
  "		}\n"
  "  : Fast AHP Current (Iadapt)\n"
  "  pinf = (1 / (1 + exp((betap-v)/gammap)))\n"
  "  : Slow AHP Current (Iadapt2)\n"
  "  pslowinf = (1 / (1 + exp((betapslow-v)/gammapslow)))\n"
  "  : Subthreshold Current (Isub)\n"
  "  qinf = (1 / (1 + exp((betaq-v)/gammaq)))\n"
  "}\n"
  ;
#endif
