### Here, we make active models with all the channels

import os

os.environ["OMP_NUM_THREADS"] = "1"  # export OMP_NUM_THREADS=4

import sys

sys.path.insert(1, "../helperScripts")

import numpy as np
import matplotlib.pyplot as plt
import features as fts
import MOOSEModel as mm
import expcells
import brute_curvefit as bcf
from copy import deepcopy
from tqdm import tqdm
import pandas as pd
from pprint import pprint
from goMultiprocessing import Multiprocessthis_appendsave
import pickle
import json
from scipy import signal
import warnings



# Load models from the JSON file
impmodels_list = []
file_path = "activemodels_imp.json"
with open(file_path, "r") as file:
    for line in file:
        impmodel = json.loads(line)
        impmodels_list.append(impmodel)

bnspasmodels_list = []
file_path = "activemodels_pas.json"
with open(file_path, "r") as file:
    for line in file:
        bnspasmodel = json.loads(line)
        bnspasmodels_list.append(bnspasmodel)

        # pprint(bnspasmodel["Parameters"])
        # t,i,v,ca = mm.runModel(bnspasmodel, 150e-12, refreshKin=False)
        # plt.plot(t,v, label='pas', c='C1')

onecomptmodels_list = []
file_path = "activemodels_1compt.json"
with open(file_path, "r") as file:
    for line in file:
        onecomptmodel = json.loads(line)
        onecomptmodels_list.append(onecomptmodel)

        # pprint(onecomptmodel["Parameters"])
        # t,i,v,ca = mm.runModel(onecomptmodel, 150e-12, refreshKin=False)
        # plt.plot(t,v, label='1compt', c='C2')

DBL150_list = [a["Features"]["DBL_1.5e-10"] for a in impmodels_list]
impmodels_list = np.array(impmodels_list)[np.argsort(DBL150_list)][::-1]
bnspasmodels_list = np.array(bnspasmodels_list)[np.argsort(DBL150_list)][::-1]
onecomptmodels_list = np.array(onecomptmodels_list)[np.argsort(DBL150_list)][::-1]

for i in range(len(onecomptmodels_list)):
    t,I,v,ca = mm.runModel(impmodels_list[i], 150e-12, refreshKin=False)
    plt.plot(t,v, label='imp', c='C0')
    t,I,v,ca = mm.runModel(bnspasmodels_list[i], 150e-12, refreshKin=False)
    plt.plot(t,v, label='pas', c='C1')
    t,I,v,ca = mm.runModel(onecomptmodels_list[i], 150e-12, refreshKin=False)
    plt.plot(t,v, label='1compt', c='C2')

    plt.legend()
    plt.xlabel('Time (s)')
    plt.ylabel('Membrane potential (V)')
    plt.show()

