import sys

sys.path.insert(1, "../helperScripts")
sys.path.insert(1, "../Kinetics")

import matplotlib.pyplot as plt
import numpy as np
import pandas as pd
import seaborn as sns
import matplotlib.gridspec as gridspec
from matplotlib.gridspec import GridSpec
import os
import subprocess
from scipy.signal import butter, filtfilt
import expcells
import features as fts
from tqdm import tqdm


fig, ax = plt.subplots(3,1)

cell2 = expcells.expcell('2023_01_04_cell_2', f'../expdata/Chirp/2023_01_04_cell_2')
T_150pA, Vm_150pA = expcells.expdata(cell2.preFIfile, Index=10)
stim_start = 0.3469
stim_end = stim_start+0.5
LJP = 15e-3

### gating variables ###
dt = T_150pA[1] - T_150pA[0]
def playexpv(LJP = 15e-3):
    m_list = [0]
    h_list = [1]
    for i,t in tqdm(enumerate(T_150pA[1:])):
        v_ = Vm_150pA[i+1] - LJP
        minf_, mtau_ = np.interp(v_, v, minf), np.interp(v_, v, mtau)
        m_list.append(min([1,(minf_ - m_list[-1])/mtau_*dt + m_list[-1]]))

        hinf_, htau_ = np.interp(v_, v, hinf), np.interp(v_, v, htau)
        h_list.append((hinf_ - h_list[-1])/htau_*dt + h_list[-1])

    return [m_list, h_list]
################################3

import moose
import Na_T_Chan_Royeck_wslow
moose.Neutral('library')
Na_T = Na_T_Chan_Royeck_wslow.Na_T_Chan("Na_T_Chan")
xgate = moose.element( Na_T.path + '/gateX' )
v = np.linspace(xgate.min, xgate.max, xgate.divs+1)
minf = xgate.tableA/xgate.tableB
mtau = 1/xgate.tableB
ygate = moose.element( Na_T.path + '/gateY' )
v = np.linspace(ygate.min, ygate.max, ygate.divs+1)
hinf = ygate.tableA/ygate.tableB
htau = 1/ygate.tableB

m_list, h_list = playexpv(15e-3)
ax[0].plot((T_150pA - stim_start)*1e3, np.array(m_list)**3, label='$m^3$', c='C1')
ax[0].plot((T_150pA - stim_start)*1e3, h_list, label='h', c='C5')
ax[0].set_xlim(60, 85)
# ax[0].set_xlabel('Time (ms)')
ax[0].set_ylabel('gating variable')
ax[0].set_title('Roy')
ax[0].tick_params(bottom=False, labelbottom=False)
axD1_Vm = ax[0].twinx()
axD1_Vm.plot((T_150pA-stim_start)*1e3, (Vm_150pA-LJP)*1e3, c='C0', alpha=0.5, linewidth=1)
axD1_Vm.set_ylim(-0.095*1e3, 0.05*1e3)
axD1_Vm.set_ylabel('Voltage (mV)', color='C0')
axD1_Vm.spines['right'].set_color('C0')
axD1_Vm.tick_params(axis='y', colors='C0')


moose.delete('library')

#####################################################################

import moose
import Na_T_Chan_allen
moose.Neutral('library')
Na_T = Na_T_Chan_allen.Na_T_Chan("Na_T_Chan")
xgate = moose.element( Na_T.path + '/gateX' )
v = np.linspace(xgate.min, xgate.max, xgate.divs+1)
minf = xgate.tableA/xgate.tableB
mtau = 1/xgate.tableB
ygate = moose.element( Na_T.path + '/gateY' )
v = np.linspace(ygate.min, ygate.max, ygate.divs+1)
hinf = ygate.tableA/ygate.tableB
htau = 1/ygate.tableB

m_list, h_list = playexpv(15e-3)
ax[1].plot((T_150pA - stim_start)*1e3, np.array(m_list)**3, label='$m^3$', c='C1')
ax[1].plot((T_150pA - stim_start)*1e3, h_list, label='h', c='C5')
ax[1].set_xlim(60, 85)
# ax[1].set_xlabel('Time (ms)')
ax[1].set_ylabel('gating variable')
ax[1].set_title('Gou')
ax[1].tick_params(bottom=False, labelbottom=False)
axD1_Vm = ax[1].twinx()
axD1_Vm.plot((T_150pA-stim_start)*1e3, (Vm_150pA-LJP)*1e3, label='LJP corrected', c='C0', alpha=0.5)
axD1_Vm.set_ylim(-0.095*1e3, 0.05*1e3)
axD1_Vm.set_ylabel('Voltage (mV)', color='C0')
axD1_Vm.spines['right'].set_color('C0')
axD1_Vm.tick_params(axis='y', colors='C0')

moose.delete('library')

#####################################################################

import moose
import Na_Chan_Migliore2018
moose.Neutral('library')
Na_T = Na_Chan_Migliore2018.Na_Chan("Na_T_Chan")
xgate = moose.element( Na_T.path + '/gateX' )
v = np.linspace(xgate.min, xgate.max, xgate.divs+1)
minf = xgate.tableA/xgate.tableB
mtau = 1/xgate.tableB
ygate = moose.element( Na_T.path + '/gateY' )
v = np.linspace(ygate.min, ygate.max, ygate.divs+1)
hinf = ygate.tableA/ygate.tableB
htau = 1/ygate.tableB

m_list, h_list = playexpv(15e-3)
ax[2].plot((T_150pA - stim_start)*1e3, np.array(m_list)**3, label='$m^3$', c='C1')
ax[2].plot((T_150pA - stim_start)*1e3, h_list, label='h', c='C5')
ax[2].set_xlim(60, 85)
ax[2].set_xlabel('Time (ms)')
ax[2].set_ylabel('gating variable')
ax[2].set_title('Mig')
# ax[2].tick_params(bottom=False, labelbottom=False)
axD1_Vm = ax[2].twinx()
axD1_Vm.plot((T_150pA-stim_start)*1e3, (Vm_150pA-LJP)*1e3, label='LJP corrected', c='C0', alpha=0.5)
axD1_Vm.set_ylim(-0.095*1e3, 0.05*1e3)
axD1_Vm.set_ylabel('Voltage (mV)', color='C0')
axD1_Vm.spines['right'].set_color('C0')
axD1_Vm.tick_params(axis='y', colors='C0')

leg = ax[2].legend(frameon=False, loc='best')

moose.delete('library')









plt.show()
