### Here we rerun the json files with better resolution of mm.elecPlotDt = 5e-6

import os

os.environ["OMP_NUM_THREADS"] = "1"  # export OMP_NUM_THREADS=4

import sys

sys.path.insert(1, "../helperScripts")

import numpy as np
import matplotlib.pyplot as plt
import features as fts
import MOOSEModel as mm
import expcells
import brute_curvefit as bcf
from copy import deepcopy
from tqdm import tqdm
import pandas as pd
from pprint import pprint
from goMultiprocessing import Multiprocessthis_appendsave
import pickle
import json
from scipy import signal
import warnings
from glob import glob
import moose

mm.elecPlotDt = 5e-6
fts.elecPlotDt = 5e-6
mm.elecDt = 5e-7
fts.elecDt = 5e-7

df_expsummaryactiveF = pd.read_pickle("../helperScripts/expsummaryactiveF.pkl")

files = glob("./*_.json")

def ourfunc(model):
    modelF = fts.modelfeatures(
        model, stim_start=0.5, stim_end=1, refreshKin=False
    )
    model["Features"] = modelF
    return [model]


##############################################################################
class NpEncoder(json.JSONEncoder):
    def default(self, obj):
        if isinstance(obj, np.integer):
            return int(obj)
        if isinstance(obj, np.floating):
            return float(obj)
        if isinstance(obj, np.ndarray):
            return obj.tolist()
        return super(NpEncoder, self).default(obj)

#######################################################################

# for old_file_path in files:
#     print(old_file_path)
#     models_list = []
#     with open(old_file_path, "r") as oldfile:
#         for line in oldfile:
#             model = json.loads(line)
#             models_list.append(model)

#     pprint(models_list[0]["Features"]['AP1_width_1.5e-10'])
#     a = ourfunc(models_list[0])[0]
#     pprint(a["Features"]['AP1_width_1.5e-10'])
#     t,I,V, Ca = mm.runModel(models_list[0])
    # plt.plot(t,V)
    # plt.show()

    # Multiprocessthis_appendsave(
    #    ourfunc, models_list, [], ["tempactivemodels.pkl"], seed=1234, npool=120
    # )
    # moose.delete('library')

    # with open("tempactivemodels.pkl", "rb") as f, open(os.path.basename(old_file_path).removesuffix("_.json")+".json", "a") as newfile:
    #     while True:
    #         try:
    #             model = pickle.load(f)
    #             if len(model) > 0:
    #                 json.dump(model, newfile, cls=NpEncoder)
    #                 newfile.write("\n")
    #         except Exception:
    #             break


