import moose
import matplotlib.pyplot as plt
moose.Neutral('library')

import numpy as np
from Na_T_Chan_Hay2011_exact_wslow import Na_T_Chan
Na_T_Chan('Na_T_Chan')


fig, axs = plt.subplots(2,1)

Vmin = -0.100
Vmax = 0.100
Vdivs = 3000
# dV = (Vmax-Vmin)/Vdivs
# v = np.arange(Vmin,Vmax, dV)
v = np.linspace(Vmin,Vmax, Vdivs)*1e3

axs[0].plot(v*1e-3, (moose.element('library/Na_T_Chan/gateX').tableA/moose.element('library/Na_T_Chan/gateX').tableB)**3, label='nInf')
axs[0].plot(v*1e-3, moose.element('library/Na_T_Chan/gateY').tableA/moose.element('library/Na_T_Chan/gateY').tableB, label='lInf')
# axs[0].plot(v*1e-3, moose.element('library/Na_T_Chan/gateZ').tableA/moose.element('library/Na_T_Chan/gateZ').tableB, label='sInf')
axs[0].set_ylabel('Inf')
axs[0].legend()
axs[0].grid()

axs[1].plot(v*1e-3, 1/moose.element('library/Na_T_Chan/gateX').tableB, label='nTau')
axs[1].plot(v*1e-3, 1/moose.element('library/Na_T_Chan/gateY').tableB, label='lTau')
# axs[1].plot(v*1e-3, 1/moose.element('library/Na_T_Chan/gateZ').tableB, label='sTau')
axs[1].set_ylabel('Tau')
axs[1].legend()
axs[1].grid()



from Na_T_Chan_Royeck_wslow import Na_T_Chan
Na_T_Chan('Na_T_Chan')

axs[0].plot(v*1e-3, (moose.element('library/Na_T_Chan/gateX').tableA/moose.element('library/Na_T_Chan/gateX').tableB)**3, label='nInf')
axs[0].plot(v*1e-3, moose.element('library/Na_T_Chan/gateY').tableA/moose.element('library/Na_T_Chan/gateY').tableB, label='lInf')
# axs[0].plot(v*1e-3, moose.element('library/Na_T_Chan/gateZ').tableA/moose.element('library/Na_T_Chan/gateZ').tableB, label='sInf')
axs[0].set_ylabel('Inf')
axs[0].legend()
axs[0].grid()

axs[1].plot(v*1e-3, 1/moose.element('library/Na_T_Chan/gateX').tableB, label='nTau')
axs[1].plot(v*1e-3, 1/moose.element('library/Na_T_Chan/gateY').tableB, label='lTau')
# axs[1].plot(v*1e-3, 1/moose.element('library/Na_T_Chan/gateZ').tableB, label='sTau')
axs[1].set_ylabel('Tau')
axs[1].legend()
axs[1].grid()


plt.show()