import sys

sys.path.insert(1, "../helperScripts")

import matplotlib.pyplot as plt
import numpy as np
from tqdm import tqdm
import pandas as pd
import seaborn as sns
from matplotlib.gridspec import GridSpec
from matplotlib.collections import LineCollection
import scikit_posthocs as sp
# import os
# import subprocess
from scipy import signal

import expcells
import features as fts
import json

# import pickle
import scipy
import MOOSEModel as mm

basemodel_1compt_list = []
file_path = "../helperScripts/activemodels_1compt.json"
with open(file_path, "r") as file:
    for line in tqdm(file):
        basemodel = json.loads(line)
        basemodel_1compt_list.append(basemodel)


basemodel_imp_list = []
file_path = "../helperScripts/activemodels_imp.json"
with open(file_path, "r") as file:
    for line in tqdm(file):
        basemodel = json.loads(line)
        basemodel_imp_list.append(basemodel)

basemodel_pas_list = []
file_path = "../helperScripts/activemodels_pas.json"
with open(file_path, "r") as file:
    for line in tqdm(file):
        basemodel = json.loads(line)
        basemodel_pas_list.append(basemodel)


DBLO_list = [a["Features"]["DBLO_1.5e-10"] for a in basemodel_1compt_list]
mm.plotModel(basemodel_1compt_list[np.argsort(DBLO_list)[-1]])

freqvalidmodels_1compt = [a for a in basemodel_1compt_list if (a["Features"]["freq_1.5e-10"]>=24) & (a["Features"]["freq_1.5e-10"]<=41.6) & (a["Features"]["ISImedian_1.5e-10"]>=0.0231) & (a["Features"]["ISImedian_1.5e-10"]<=0.03922) & (a["Features"]["AP1_amp_1.5e-10"]>=0.0774)]
# freqvalidmodels_1compt = [a for a in basemodel_1compt_list if (a["Features"]["freq_1.5e-10"]>=24) & (a["Features"]["freq_1.5e-10"]<=41.6) & (a["Features"]["ISImedian_1.5e-10"]>=0.0231) & (a["Features"]["ISImedian_1.5e-10"]<=0.03922)]
DBLO_list = [a["Features"]["DBLO_1.5e-10"] for a in freqvalidmodels_1compt]
mm.plotModel(freqvalidmodels_1compt[np.argsort(DBLO_list)[-1]])


################################################
DBLO_list = [a["Features"]["DBLO_1.5e-10"] for a in basemodel_imp_list]
mm.plotModel(basemodel_imp_list[np.argsort(DBLO_list)[-1]])

freqvalidmodels_imp = [a for a in basemodel_imp_list if (a["Features"]["freq_1.5e-10"]>=24) & (a["Features"]["freq_1.5e-10"]<=41.6) & (a["Features"]["ISImedian_1.5e-10"]>=0.0231) & (a["Features"]["ISImedian_1.5e-10"]<=0.03922) & (a["Features"]["AP1_amp_1.5e-10"]>=0.0774)]
DBLO_list = [a["Features"]["DBLO_1.5e-10"] for a in freqvalidmodels_imp]
mm.plotModel(freqvalidmodels_imp[np.argsort(DBLO_list)[-1]])