TITLE M-type potassium channel from Drion et al 2010

UNITS {
	(mA) = (milliamp)
	(mV) = (millivolt)
	(molar) = (1/liter)
	(mM) = (millimolar)
}

NEURON {
	SUFFIX km
	USEION k WRITE ik
	RANGE gkmbar,ik,vshift,gkm
}

PARAMETER {
	ek  = -90.0	(mV)
	gkmbar= 300e-6	(mho/cm2) :  must be explicitly def. in hoc
	vshift = 0 (mV)
}

STATE { 
	n 
}

ASSIGNED {
	v	(mV)
	ik	(mA/cm2)
	alpha (1/ms)
	beta (1/ms)
	gkm (S/cm2)
}

BREAKPOINT {
	SOLVE states METHOD cnexp
	gkm = gkmbar*n 
	ik = gkm*(v-ek)
}



DERIVATIVE states {     : exact when v held constant; integrates over dt step
	rates(v)
	n' = alpha*(1-n)-beta*n
}

INITIAL {
	rates(v)
	n = 0
	:n = alpha/(beta+alpha)
}


UNITSOFF

PROCEDURE rates(v) { LOCAL vm
  vm = v + vshift
  alpha = 3*0.02/(1.0+exp(-(vm+20.0)/5.0))
  beta = 3*0.01*exp(-(vm+43.0)/18.0)
}

UNITSON
