TITLE Low threshold calcium current
:
:   Ca++ current responsible for low threshold spikes (LTS)
:   THALAMOCORTICAL CELLS
:   Differential equations
:
:   Model based on the data of Huguenard & McCormick, J Neurophysiol
:   68: 1373-1383, 1992 and Huguenard & Prince, J Neurosci.
:   12: 3804-3817, 1992.
:
:   Features:
:
:	- kinetics described by Nernst equations using a m2h format
:	- activation considered at steady-state
:	- inactivation fit to Huguenard's data using a bi-exp function
:	- shift for screening charge, q10 of inactivation of 3
:
:
:   Written by Alain Destexhe, Salk Institute, 1993; modified 1995
:

INDEPENDENT {t FROM 0 TO 1 WITH 1 (ms)}



NEURON {
	SUFFIX catchan
	NONSPECIFIC_CURRENT incal
	USEION ca READ eca WRITE ica
	USEION cask WRITE icask VALENCE 2: this might not work and would require a compensating current
	USEION cacicr WRITE icacicr VALENCE 2
	RANGE gcatbar, m_inf, tau_m, h_inf, tau_h, shift, pf, tsk, tcicr, gca, phi_h, ica,mhalf,hhalf,icat, icask, icacicr, hfixed,h
	:GLOBAL minf, hinf, mtau, htau
}

UNITS {
	(molar) = (1/liter)
	(mV) =	(millivolt)
	(mA) =	(milliamp)
	(mM) =	(millimolar)

	FARADAY = (faraday) (coulomb)
	R = (k-mole) (joule/degC)
}

PARAMETER {
	v		(mV)
	celsius	= 36	(degC)
	gcatbar	= 0.002	(mho/cm2)
	q10	= 3			: Q10 of inactivation
	shift	= 2 	(mV)		: corresponds to 2mM ext Ca++
	cai	= 2.4e-4 (mM)		: adjusted for eca=120 mV
	cao	= 2	(mM)
	pf = 1 (1)
	hhalf = -80
	mhalf = -51
	hfixed=0
	tsk = 0
	tcicr = 0
	tau_m = 1.0 (ms)
	eca
	phi_h = 3.0
}

STATE {
	h FROM 0 TO 1
	m FROM 0 TO 1
}

ASSIGNED {
	ica	(mA/cm2)
	icask (mA/cm2)
	icacicr (mA/cm2)        
	icat (mA/cm2)
	incal (mA/cm2)
	gca (S/cm2)
	carev	(mV)
	m_inf
	:tau_m	(ms)			: dummy variable for compatibility
	h_inf
	tau_h	(ms)
}

BREAKPOINT {
	SOLVE castate METHOD cnexp
	:carev = (1e3) * (R*(celsius+273.15))/(2*FARADAY) * log (cao/cai)
	carev = eca
	if (hfixed > 0){
		gca = gcatbar*m*m*hfixed
	} else {
		gca = gcatbar*m*m*h 
	}
	
	icat = gca*(v-carev)
	
	icask = 0:icat : cicr goes through this
	icacicr = tsk*tcicr*icat
	ica =tsk*(1-tcicr)*icat
	incal=(1-tsk)*icat:(1-tsk-tcicr)*icat : no calcium to bulk pool
}

DERIVATIVE castate {
	evaluate_fct(v)
    m' = (m_inf - m)/ tau_m
	h' = (h_inf - h) / tau_h
}


UNITSOFF
INITIAL { LOCAL Vm
	evaluate_fct(v)
}

PROCEDURE evaluate_fct(v(mV)) { LOCAL Vm

	Vm = v + shift
	if(Vm > mhalf){
		m_inf = 1.0 / ( 1 + exp(-(Vm-mhalf)/6.2) ) :57 6.2
	} else {
		m_inf = 1.0 / ( 1 + exp(-(Vm-mhalf)/5.2) ) :57 6.2	
	}
	h_inf = 1.0 / ( 1 + exp((Vm-hhalf)/4.0) )

:	if(Vm < -80) {
:		tau_h = exp((Vm+467)/66.6) / phi_h
:	} else {
:		tau_h = ( 28 + exp(-(Vm+22)/10.5) ) / phi_h
:	}
    tau_m = 25.0 : 25 /100 for 'ideal' case
	tau_h = 75.8 + (211.4 + exp((Vm+113.2)/5)) / (1 + exp((Vm+84)/3.2))


}

FUNCTION boltz(x,y,z) {
                boltz = 1/(1 + exp(-(x - y)/z))
}
 

UNITSON
