TITLE dual exponential GABAb with inward rectification
COMMENT
ENDCOMMENT

NEURON {
	POINT_PROCESS Exp2GABAb
	NONSPECIFIC_CURRENT i
	RANGE tau1, tau2, e, i, delta, wf, g,ghalf, gslope
	THREADSAFE
}

UNITS {
	(nA) = (nanoamp)
	(mV) = (millivolt)
	(uS) = (microsiemens)
	(mM) = (milli/liter)
	(S)  = (siemens)
	(pS) = (picosiemens)
	(um) = (micron)
	(J)  = (joules)
}

PARAMETER {
	tau1 = 74.0		(ms)	<1e-9,1e9>	: Spruston95 CA1 dend [at Mg = 0 v=-80]	becarful: Mg can change these values
	tau2 = 188.0		(ms)

	e = -90.0		(mV)	
	ghalf = -70
	gslope = -8
}

CONSTANT {
	T = 273.16	(degC)
	F = 9.648e4	(coul)	: Faraday's constant (coulombs/mol)
	R = 8.315	(J/degC): universal gas constant (joules/mol/K)
	z = 2		(1)		: valency of Mg2+
}

ASSIGNED {
	v		(mV)
	dt		(ms)
	i		(nA)
	factor
	g
	wf
}

STATE {
	A
	B
}

INITIAL {
	LOCAL tp
	if (tau1/tau2 > .9999) {
		tau1 = .9999*tau2
	}
	A = 0
	B = 0
	tp = (tau1*tau2)/(tau2 - tau1) * log(tau2/tau1)
	factor = -exp(-tp/tau1) + exp(-tp/tau2)
	factor = 1/factor
	
	wf = 1
	boltz(v,ghalf,gslope)
  :AMPA = 1
}

BREAKPOINT {
	SOLVE state METHOD cnexp
	g = (B-A)
	i = g*boltz(v,ghalf,gslope)*(v - e)
}

DERIVATIVE state {
	A' = -A/tau1
	B' = -B/tau2
}

NET_RECEIVE(weight) {
	wf = weight*factor
	A = A + wf
	B = B + wf
}

FUNCTION boltz(x,y,z) {
                boltz = 1/(1 + exp(-(x - y)/z))
}
