TITLE Calcium dependent, voltage gated high conductance potassium channel
: assumes direct link to calcium channel such that nano-domain [Ca2+] is proportional to current
: original version prior to nano-domain
: TITLE BKCa current for bladder small DRG neuron soma model
: Author: Darshan Mandge (darshanmandge@iitb.ac.in)
: Computational Neurophysiology Lab
: Indian Institute of Technology Bombay, India 
: For details refer: 
: A biophysically detailed computational model of bladder small DRG neuron soma 
: Darshan Mandge and Rohit Manchanda, PLOS Computational Biology (2018)

UNITS {
        (molar) = (1/liter)
        (pA) =  (picoamp)
	(mV) =	(millivolt)
        (S)  =  (siemens)
	(mA) =	(milliamp)
	(mM) =	(millimolar)
}


:INDEPENDENT {v FROM -100 TO 50 WITH 50 (mV)}
INDEPENDENT {t FROM 0 TO 1 WITH 1 (ms)}

NEURON {
	SUFFIX bkc
	THREADSAFE
	POINTER icabk_p
	USEION k WRITE ik
	USEION ca READ cai
	RANGE  gkbar,gk, ik, bkscale, pCa, vshift, cabk

}


PARAMETER {
        dt  (ms)
        celsius = 35   (degC)
        gkbar = 200.00e-6 (S/cm2)
        ek = -90.0      (mV)
        bkscale = 1.0e9  (mM*cm2/mA) : converts icabk into mM
        vshift = 0
}

ASSIGNED { 
		   cai (mM)
		   v (mV)
           ik		(mA/cm2)
           gk (S/cm2)
           ninf
           ntau (ms)
           pCa
           vhalf (mV)
           sf1 (mV)
           cabk (mM)
           icabk_p (mA/cm2)        
}

STATE {
        n <1e-4>
}


BREAKPOINT {
        SOLVE states METHOD cnexp
        gk = n*gkbar
	    ik = gk*(v - ek)
}

DERIVATIVE states {
   rates(v,icabk_p)
   n' = (ninf-n)/ntau
}

FUNCTION boltz(x,y,z) {
               LOCAL arg
                arg= -(x-y)/z
                if (arg > 50) {boltz = 0}
                else {if (arg < -50) {boltz = 1}
                else {boltz = 1.0/(1.0 + exp(arg))}}
}

FUNCTION gaussian(v,a,b,c,d) {
        LOCAL arg
        arg= a*exp(-(c+v)*(v+c)/(b*b)) +d
        gaussian = arg
}

PROCEDURE rates(v(mV),icabk(mA/cm2)) { 
LOCAL vm
UNITSOFF 
		vm = v + vshift
		:"n" potassium activation system
		:Data Fit: Scholz et al., 1998
		cabk = -bkscale*icabk
		if(cabk < 1e-9){ : 
			cabk = 1e-9
		}
		pCa = log10(cabk)-3
		vhalf = (-43.4)*pCa + (-203)
		:sf1 =  33.88*exp(-((pCa+5.423)/1.852)^2)
		sf1 = gaussian(pCa,33.88,1.852,5.423,0)
        :ninf = 1/(1+exp((vhalf-vm)/sf1))
        ninf = boltz(vm,vhalf,sf1)
        
		ntau = 5.54522*exp(-vm/-42.90548)+0.74926-0.11573*vm	: Zhang et al., 2010
}
UNITSON
