TITLE GIRK channel

UNITS {
	(mA) = (milliamp)
	(mV) = (millivolt)
	(molar) = (1/liter)
	(mM) = (millimolar)
}

NEURON {
	SUFFIX girk
	USEION k WRITE ik
	RANGE girkbar, ghalf, gslope, vslope, girk
}

PARAMETER {
	ek  = -90.0	(mV)
	girkbar= 100e-6	(mho/cm2) :  must be explicitly def. in hoc
	vshift = 0 (mV)
	ghalf = -65 :-70-45
	gslope = -5  :-8 -20
}


ASSIGNED {
	v	(mV)
	ik	(mA/cm2)
	girk (S/cm2)
}

BREAKPOINT {
	LOCAL vm 
	vm = v-vshift
	girk = girkbar*boltz(vm,ghalf,gslope)
	ik = girk*(vm-ek)
}



UNITSOFF

FUNCTION boltz(x,y,z) {
                boltz = 1/(1 + exp(-(x - y)/z))
}

UNITSON
