//RodentPreBotCNeuron_main.c
//Jessica Parker, October 5, 2024
//
//This is the main function, which begins your program and guides the actions in your program.

#include "RodentPreBotCNeuron.h" 
#include "time.h" 

int main (void) {  

  int run1 = 3;  //These numbers gets written into the names of the data files. You can use any 
  int run2 = 0;   //combination of numbers according to whatever organizational system you prefer.
  int run3 = 0;
  int run4 = 5;   
  int run5 = 0;   
  int run6 = 0;   

  //parameters defined in header file
  
  double tf1 = 4000.0;  //The amount of time the code integrates before beginning to save the data
  double tf2 = 100.0;  //The amount of time integrated in each data file.
  double tf3 = 20.0;
  double tf4 = 5.0;
  double tf5 = 30.0;
  double tint = 0.0001;  //Time step between data points.
 
  clock_t start;
  clock_t end; 
  float seconds; 

  int nvar = 4;  //Number of variables or number of equations
  double yy[nvar]; 
  double yy0[nvar];  //initial condition variable
  int numIP=0;   //used to read initial condition file
  double Vclamp0 = -80.0;
  
  int a, b, c, d, g; //used for loops

  char ipFile[100];
  sprintf(ipFile,"../%i_%i_%i_0/data/ip%i_%i_%i_0_0_0.txt",run1,run2,run3,run1,run2,run3); 
  
  FILE * f = fopen(ipFile, "r");  //initial condition file
  double number = 0; 
  
  while( fscanf(f, "%lf,", &number) > 0 )  //reading initial conditions 
    { 
      yy0[numIP]= number; 
      numIP++; 
    }  
  fclose(f);

  for (a=0; a<nvar; a++)  //Setting time zero to initial conditions
    { 
      yy[a] = yy0[a]; 
    } 

  for (b=0; b<1; b++)  //Change maximum limit if you want to sweep a parameter
    {
      //kmK = -8.0-1.0*b;
      //run3 = b+1;    //Uncomment if you are doing a 3D parameter sweep, where you are sweeping 3 parameters independently. This makes sure each simulation has a unique file name.
      
      for (g=0; g<1; g++)
	{
	  //tf4 = 5.0 + 5.0*g;
	  //run4 = g+1;  //Uncomment if you are doing a 2D or 3D parameter sweep, where you are sweeping 2 or 3 parameters independently.
      
	  for (d=0; d<35; d++)  //Change maximum limit if you want to run a 2D sweep
	    {
	      tf3 = 0.5 + d*0.5;
	      run5 = d+1;    //Uncomment if you are sweeping a parameter. This also makes sure each simulation has a unique file name.

	      
	      printf("run3 = %i, run4 = %i, run5 = %i \n",run3,run4,run5);

	      for (a=0; a<nvar; a++)  //Uncomment if you want to use the same initial conditions for each integration   
		{ 
		  yy[a] = yy0[a]; 
		}
	      
	      start = clock();  

	      Vclamp = -70.0;
	      integrate(run1,run2,run3,run4,run5,1,nvar,tf4,tint,yy);
	      Vclamp = -87.5;	
	      integrate(run1,run2,run3,run4,run5,2,nvar,tf3,tint,yy);
	      Vclamp = -77.5;
	      integrate(run1,run2,run3,run4,run5,3,nvar,tf5,tint,yy);
	      	      
	      end = clock();
	      seconds = (float)(end-start)/CLOCKS_PER_SEC;
	      
	      printf("running time: %6.6g\n", seconds); //the code as it is should take about 15 min.
	    }
	}
    }
  return(0); 
} 
