% plotMultipleDecayFits.m
% Jessica Parker, October 18, 2024

% This Matlab script just plots the output from sweepFitDecayRate.m so that you don't have to rerun those sweep fits 
% everytime you want to look at and change the plot.

close all;
clear all;

run1 = 5;
run2 = 0;
run3 = 0;
run4 = 2;
run5s = [1, 2, 3];

fitVrsn = 'A';
msrRealVrsn = 'A';

dataDir = 'data/';
figDir = 'plots/';

boltzType = 'h'; % Set to m or h depending on whether it is an activation or inactivation

xmin = 0;
xmax = 15;
VariableYrange = 0; % Set to 1 to have y-range set automatically, set to 0 to use ymin and ymax below
ymin = 0.45;  % This only matters if you set VariableYrange to 0.
ymax = 1;  % This only matters if you set VariableYrange to 0.
CloseFigures = 0;
fntnm = 'Lucida Sans';
fntsz = 16;
fntwght = 'bold';
DisplayText = 1;
textYpostn = [0.35, 0.7, 0.95];
textXpostn = [0.25, 0.25, 0.25];
OrangishRed = [255, 60, 0]/255;
BrightPurple = [153 0 153]/255;
DarkTurquoise = [22, 150, 149]/255;
fitColors = [DarkTurquoise; BrightPurple; OrangishRed];
textColors = [DarkTurquoise; BrightPurple; OrangishRed];

dir2 = [num2str(run1) '_' num2str(run2) '_' num2str(run3)];
tmFit = xmin:0.01:xmax;

for aa = 1:length(run5s)
    run5 = run5s(aa);

    dir3 = [dir2 '_' num2str(run4)];
    dir4 = [dir3 '_' num2str(run5)];

    crrntFit = load([dataDir boltzType 'DecayRate' dir4 msrRealVrsn '_' fitVrsn '.txt']); % Loading fit parameters from sweepFitDecayRate.m
    current0 = load([dataDir 'tailNormalizedConductance' dir4 msrRealVrsn '.txt']); % Loading tail conductance from measureTailCurrent.m
    tm = current0(2,:); % Time points
    dcay = current0(1,:); % Normalized conductance values over time
    dcay = dcay/max(dcay);

    tauAs(aa) = crrntFit(1); % Decay rate constant of single exponential or first of a double exponential when rtio < 1
    tauBs(aa) = crrntFit(2); % Decay rate constant of second exponential in the case of double exponential when rtio < 1
    rtios(aa) = crrntFit(3); % Proportion of double exponential belonging to the first decay rate constant (tauA)
    dcayStrts(aa) = dcay(1); % Initial normalized conductance at t = 0 right at the peak gNaP, so ideally this will be 1.
    dcayEnds(aa) = dcay(end); % Final normalized conductance at the end of the trace.

    dcayFits{aa} = -1*((dcayStrts(aa)-dcayEnds(aa))*(rtios(aa)*exp(tmFit/tauAs(aa))+(1-rtios(aa))*exp(tmFit/tauBs(aa)))+dcayEnds(aa)); % Fit equation

    tmPlts{aa} = tm;
    dcayPlts{aa} = dcay;
end

if VariableYrange
    for aa = 1:length(run5s)
        ymin0s(aa) = min(dcayFits{aa});
        ymax0s(aa) = max(dcayFits{aa});
    end
    ymin0 = min(ymin0s);
    ymax0 = max(ymax0s);
    yl0 = ymax0 - ymin0;
    ymin = ymin0 - 0.1*yl0;
    ymax = ymax0 + 0.1*yl0;
end
yl = ymax - ymin;

f = figure();
f.PaperPositionMode = 'manual';
f.PaperUnits = 'inches';
f.Units = 'inches';
f.OuterPosition = [1 1 6 5];
f.InnerPosition = [0.25 0.25 5.5 4.5];
f.PaperPosition = [0.25 0.25 5 4];
f.RendererMode = 'manual';

axes('position',[0.22 0.19 0.74 0.78]);
hold on;

for aa = 1:length(run5s)
    plot(tmPlts{aa},dcayPlts{aa},'color',fitColors(aa,:),'linewidth',2.5);
    plot(tmFit,-1*dcayFits{aa},'--','color',[0 0 0],'linewidth',2);
    if DisplayText
        text(xmin+textXpostn(aa)*(xmax-xmin),ymin+textYpostn(aa)*yl,['\tau_{decay1} = ' num2str(round(abs(tauAs(aa)),2)) ' s, ' num2str(round(100*rtios(aa))) '%'],...
       	 'fontsize',fntsz,'fontname',fntnm,'fontweight',fntwght,'color',textColors(aa,:));
        text(xmin+textXpostn(aa)*(xmax-xmin),ymin+(textYpostn(aa)-0.09)*yl,['\tau_{decay2} = ' num2str(round(abs(tauBs(aa)),2)) ' s, ' num2str(round(100*(1-rtios(aa)))) '%'],...
       	 'fontsize',fntsz,'fontname',fntnm,'fontweight',fntwght,'color',textColors(aa,:));
    end
end
ylabel(['<g_{NaP}> (pA)']);
xlabel('Time (s)');
xlim([xmin xmax]);
ylim([ymin ymax]);
yticks([0 0.2 0.4 0.6 0.8 1]);
box off;
ax = gca;
ax.FontName = fntnm;
ax.FontSize = fntsz;
ax.FontWeight = fntwght;
ax.LineWidth = 3.0;

print(f,['plots/mltplDecayFits' dir3 msrRealVrsn '_' fitVrsn '.eps'],'-depsc','-r0');

if CloseFigures
    close(f);
end



