//RodentPreBotCNeuron_main.c
//Jessica Parker, October 5, 2024
//
//This is the main function, which begins your program and directs the actions in your program. This code takes about 40 sec to run

#include "RodentPreBotCNeuron.h" 
#include "time.h" 

int main (void) {  

  int run1 = 1;  //These numbers gets written into the names of the data files. You can use any 
  int run2 = 0;  //combination of numbers according to whatever organizational system you prefer.
  int run3 = 0;  
  int run4 = 0;  
  int run5 = 0;  
  int run6 = 1;  

  //parameters defined in header file
  
  double tf1 = 1000.0;  //The amount of time the code integrates before beginning to save the data
  double tf2 = 70.0;  //The amount of time integrated in each data file.
  double tint = 0.0001;  //Time step between data points.
 
  clock_t start;
  clock_t end; 
  float seconds; 
  
  int nvar = 5;  //Number of variables or number of equations
  double yy[nvar]; 
  double yy0[nvar];  //initial conditions loaded in here
  int numIP=0;   //used to read initial condition file
  
  int a, b, c, d, g; //used for loops

  FILE * f = fopen("ipFullCanonBursting.txt", "r");  //initial condition file
  double number = 0; 
  
  while( fscanf(f, "%lf,", &number) > 0 )  //reading initial conditions 
    { 
      yy0[numIP]= number; 
      numIP++; 
    }  
  fclose(f);

  for (a=0; a<nvar; a++)  //Setting time zero to initial conditions
    { 
      yy[a] = yy0[a]; 
    } 

  for (b=0; b<1; b++)  //Change maximum limit if you want to sweep a parameter
    {
      //kmK = -8.0-1.0*b;
      //run3 = b+1;    //Uncomment if you are doing a 3D parameter sweep, where you are sweeping 3 parameters independently.
      
      for (g=0; g<1; g++)
	{
	  //gNaP = 2.7 + 0.1*g;
	  //run4 = g+1;  //Uncomment if you are doing a 2D or 3D parameter sweep, where you are sweeping 2 or 3 parameters independently.
      
	  for (d=0; d<1; d++)  //Change maximum limit if you want to run a 2D sweep
	    {
	      //dielectric = 0.32 + 0.005*d;
	      //run5 = d+1;    //Uncomment if you are sweeping a parameter. 
	      
	      printf("run1 = %i, run2 = %i, run3 = %i, run4 = %i, run5 = %i \n",run1,run2,run3,run4,run5);

	      /*for (a=0; a<nvar; a++)  //Uncomment if you want to use the same initial conditions for each integration   
		{ 
		  yy[a] = yy0[a]; 
		}*/
	      
	      start = clock();  
	      integrateNW(run1,run2,run3,run4,run5,0,nvar,tf1,tint,yy);   //Call to function defined in EpisodicLocomotion_integrateNW.c
	                                                                  //Integrates for tf1 seconds without saving data. Saves last point as run6 = 0.
	      integrate(run1,run2,run3,run4,run5,1,nvar,tf2,tint,yy);  //Call to function defined in EpisodicLocomotion_integrate.c, which integrates and saves data
	      
	      end = clock();
	      seconds = (float)(end-start)/CLOCKS_PER_SEC;
	      
	      printf("running time: %6.6g\n", seconds); //the code as it is should take about 40 sec to run.
	    }
	}
    }
  return(0); 
} 
