//RodentPreBotCNeuron.h
//Jessica Parker, October 5, 2024
//
//This is the header file. It declares the global functions and parameters. Using 'static const' to initialize
//your global parameters that you don't intend to change is an appropriate way to use global variables. The use of global
//variables is controversial, but I feel that the way I am using them is appropriate for a simple program like this. Using
//nonstatic global variables that will be changed in the rest of your code is a less appropriate use of global variables,
//although it still works. This code limits the use of nonstatic global variables to the one or two parameters that
//you may be sweeping. The benefit of setting our parameters as static global variables is that it causes the code to
//run faster and it is much easier to make changes to the equations in RodentPreBotCNeuron_dy.c. However, if you prefer,
//you can make the parameters that you are sweeping arguments for each of the functions defined below.

#include <stdio.h>
#include <string.h>
#include <math.h>

#include <gsl/gsl_errno.h>
#include <gsl/gsl_matrix.h>
#include <gsl/gsl_odeiv.h>

int main (void);
int integrate(int run1, int run2, int run3, int run4, int run5,  int run6, int nvar, double tf, double tint, double y[]);   //integrates and saves data
int func(double t, const double y[], double f[], void *params);  //equations defined

//Parameters of Differential Equations
static const double capac = 0.018; 
static const double ENa = 65.0;
static const double EK = -80.0; 
static const double gNaP = 2.12; 
static const double gL = 1.1; 
static const double gK = 0.0; 
static const double gNaF = 0.0; 
static const double VmNaF = -45.5; 
static const double VhNaF = -67.4; 
static const double kmNaF = -7.0; 
static const double khNaF = 10.8; 
static const double tauhNaF = 0.04; 
static const double VmNaP = -48.0; 
static const double kmNaP = -4.5; 
static const double taumNaP = 0.006; 
static const double VmK = -45.5; 
static const double kmK = -11.0; 
static const double taumK = 0.005; 
static const double EL = -61.0; 
static const double frdy = 9.6485e13; 
static const double vlm = 2.6e-14; 
static const double Ipmpmx = 40.0; 
static const double Naih = 15.0; 
static const double Nae = 130.0; 
static const double nhillNa = 1.4; 
static const double rtf = 26.0;
static const double alpha = -0.46; 

static const double gModWE = 0.0; 
static const double gModWI = 0.0;
static const double Iinj = 0.0; 

double Vclamp;      //Use this format for parameters that you are sweeping, and comment out
                 //the above (static const) declaration of the variable you are sweeping
