"""
cfg.py 

Simulation configuration for cortical network model to study epilepsy (using NetPyNE)
This file has sim configs as well as specification for parameterized values in netParams.py 

Contributors: salvadordura@gmail.com
"""

from netpyne import specs
#import pickle
import dill as pickle
#import math

cfg = specs.SimConfig()

#------------------------------------------------------------------------------
#
# SIMULATION CONFIGURATION
#
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# Run parameters
#------------------------------------------------------------------------------
cfg.duration = [DURATION]			## Duration of the sim, in ms -- value from M1 cfg.py 
cfg.dt = [DT]              ## Internal Integration Time Step -- value from M1 cfg.py 0.03ms
cfg.verbose = True         	## Show detailed messages
cfg.hParams['celsius'] = 36.4

cfg.hParams['v_init'] = -65

#------------------------------------------------------------------------------
# Recording 
#------------------------------------------------------------------------------
allpops = []
Epops = ['E2', 'E5']
Ipops = ['I2']

cfg.recordTraces={'ki_soma': {'sec': 'soma', 'loc':0.5, 'var': 'ki'},'ko_soma': {'sec': 'soma', 'loc':0.5, 'var': 'ko'},'buf_i_soma':{'cells':Ipops, 'sec': 'soma', 'loc':0.5,'var': 'buf_i'},'buf_e_soma':{'cells':Epops, 'sec':'soma', 'loc':0.5,'var': 'buf_e'}}


cfg.recordStim = False			## Seen in M1 cfg.py
cfg.recordTime = False  		## SEen in M1 cfg.py 
cfg.recordStep = 100


#------------------------------------------------------------------------------
# Saving
#------------------------------------------------------------------------------
cfg.simLabel = 'data_net'
cfg.filename = cfg.simLabel
cfg.saveFolder = './output'  
cfg.savePickle = True        	## Save pkl file
cfg.saveJson = False   	## Save json file
cfg.saveCSV =False
cfg.saveDat =False
cfg.saveDataInclude = ['simData'] ## data structures to save

cfg.gatherOnlySimData = True # False	## True to save memory in large sims
cfg.saveCellSecs = False		    ## set to false to save memory in large sims
cfg.saveCellConns = False		## set to false to save memory in large sims

#------------------------------------------------------------------------------
# Analysis and plotting 
#----------------------------------------------------------------------------- 
cfg.analysis['plotTraces'] = {'include':['E2', 'E5','I2'],'timeRange':[0, [DURATION]],'oneFigPer': 'popTrace', 'saveFig': False, 'showFig': False, 'figSize':(12,8)} #[(pop,0) for pop in alltypes]


cfg.analysis['plotRaster'] = {'include': Epops+Ipops, 'saveFig': True, 'showFig': False, 'popRates': True, 'orderInverse': True, 'timeRange': [0,cfg.duration], 'figSize': (14,12), 'lw': 0.3, 'markerSize': 3, 'marker': '.', 'dpi': 600}      	## Plot a raster

cfg.analysis['plotRxDConcentration'] = {'speciesLabel': 'extP', 'regionLabel': 'ecs'}


cfg.analysis['plot2Dnet'] = {'include':['allCells'],'saveFig': True, 'figSize':(14,12), 'showFig': False}


#------------------------------------------------------------------------------
# Cells
#------------------------------------------------------------------------------
cfg.weightNormThreshold = 5.0  # maximum weight normalization factor with respect to the soma


#------------------------------------------------------------------------------
# Network 
#------------------------------------------------------------------------------
## These values taken from M1 cfg.py (https://github.com/Neurosim-lab/netpyne/blob/development/examples/M1detailed/cfg.py)
cfg.singleCellPops = False
cfg.scale = 1.0     # Is this what should be used? 
cfg.sizeY = 850.0 # 1350.0 in M1_detailed # should this be set to 2000 since that is the full height of the column? 
cfg.sizeX = 500.0 # This may change depending on electrode radius 
cfg.sizeZ = 500.0
cfg.scaleDensity = 0.5 # Should be 1.0 unless need lower cell density for test simulation or visualization


#------------------------------------------------------------------------------
# Connectivity
#------------------------------------------------------------------------------
# Cortical
cfg.addConn = 1
cfg.EEGain = [EESYN]
cfg.EIGain = [EISYN]
cfg.IEGain = [IESYN]
cfg.IIGain = [IISYN]
cfg.seeds['conn'] = [CONNSEED]


#------------------------------------------------------------------------------
# Background inputs
#------------------------------------------------------------------------------
cfg.addBkgConn = 0

cfg.rateBkg = {'E2': 2000, 'E5': 2000, 'I2':2000}


