#/bin/bash

# $1 = FS IKPUMPMAX
# $2 = FS SLOPE
# $3 = FS KOTH
# $4 = FS BINIT 
# $5 = FS KOINIT

# $6 = PY IKPUMPMAX
# $7 = PY SLOPE
# $8 = PY KOTH
# $9 = PY BINIT 
# $10 = PY KOINIT (NOT USED AT THIS MOMENT)

# $11= cfg DURATION
# $12 = cfg DT
# $13 = tau_s
# $14 = gau_gs




# creating a subdirectory to store all the codes and sim files and outputs
subdir="GAHP_"$2"_SLOPE_"$3"_IPUMPMAX_"$4"_KOTHETA_"$5"_KOEQ_"$6"_IEXT_"$7"_KOINIT_"$8"_BINIT_"$9"_IPUMPFRAC_"${12}"_DURATION_"${10}"_DT_"${11}"/GK_"$1"_IEXT_"$7"_TAUS_"${13}"_TAUGS_"${14}
#echo $subdir
basedir_root="/users/XXX/data/XXX/NetPyNE_outputs/"
basedir=${basedir_root}"XPP_RESULTS/"

# Don't do anything if sim is already there
if [ -d "${basedir}${subdir}" ]
then
echo "Directory exists\n"
exit 0
fi

echo ${basedir}${subdir}
mkdir -p ${basedir}${subdir}



sed  -e "s/\[GK\]/$1/g"  -e "s/\[GAHP\]/$2/g" -e "s/\[SLOPE\]/$3/g" -e "s/\[IPUMPMAX\]/$4/g"  -e "s/\[KOTHETA\]/$5/g" -e "s/\[KOEQ\]/$6/g" -e "s/\[IEXT\]/$7/g" -e "s/\[KOINIT\]/${8}/g" -e "s/\[BINIT\]/${9}/g" -e "s/\[DURATION\]/${10}/g" -e "s/\[DT\]/${11}/g" -e "s/\[IPUMPFRAC\]/${12}/g" -e "s/\[TAUS\]/${13}/g" -e "s/\[TAUGS\]/${14}/g" FS.ode.template > ${basedir}${subdir}/FS.ode


cd ${basedir}${subdir}

# slurmscriptname=slurm_${subdir}
slurmscriptname="slurm_script"

cat>${slurmscriptname}.slurm<<EOF
#!/bin/bash
# SLURM submission 
# Runtime request
#SBATCH --job-name SingleNeuron
#SBATCH --time=2:00:00

# Queue request
# SBATCH --ntasks=4
#SBATCH -n 1
#SBATCH --mem-per-cpu 6g
# SBATCH --nodes=1-1
#SBATCH --account=XXX-XXX-condo

# Specify an output file
#SBATCH -o ./SingleNeuron-O-%j.out
#SBATCH -e ./SingleNeuron-E-%j.out


/users/XXX/local/xpp/xppaut FS.ode -silent 

awk 'NR % 20 == 1' output.dat > output_d.dat

rm output.dat

wait

EOF
sbatch ${slurmscriptname}.slurm


