#!/bin/bash

compute_flag=1
numcorespersim=8 # number of cores per simulation



IKPUMPMAX_FS=7
SLOPE_FS=-1.15
KOTH_FS=15
BINIT_FS=490
KOINIT_FS=3.5
IKPUMPMAX_PY=7
SLOPE_PY=-1.15
KOTH_PY=15
BINIT_PY=495
KOINIT_PY=3.5

DURATION=2500000
DT=0.015

MCRATE=0.6  # diffusion const
MCSLOPE=0.01 # NOT USED

BCKRATEE=300 # (Hz)
BCKNOISEE=1
BCKRATEI=300 # (Hz)
BCKNOISEI=1

BCKWTEE=0.000404 
BCKWTEI=0.00061 
BCKWTIE=0.000953 
BCKWTII=0.00117 
IEXT=-0.00011  #mA/cm2 (fixed) [Here for Fig. 8 black sim, IEXT only applies to PY population; IN pop has IEXT=0]
GKI=10.0 
GKE=0.3 
SET=7 # set number for different noise and connectivity configs

CONNSEED=1
EXSEED=1
INSEED=1
# random seeds
if [ ${SET} = 1 ] 
	then
	CONNSEED=1
	EXSEED=12
	INSEED=24
elif [ ${SET} = 2 ] 
	then
	CONNSEED=2
  EXSEED=75
  INSEED=57
elif [ ${SET} = 3 ]
	then
	CONNSEED=3
  EXSEED=15
  INSEED=2
elif [ ${SET} = 4 ] 
 then
  CONNSEED=4
  EXSEED=80
  INSEED=102
elif [ ${SET} = 5 ] 
then
  CONNSEED=5
  EXSEED=63
  INSEED=25
elif [ ${SET} = 6 ] 
then
  CONNSEED=6
  EXSEED=125
  INSEED=98
elif [ ${SET} = 7 ] 
then
  CONNSEED=7
  EXSEED=236
  INSEED=750
elif [ ${SET} = 8 ] 
then
  CONNSEED=8
  EXSEED=89
  INSEED=92
else 
	CONNSEED=1
	EXSEED=12
	INSEED=24
fi

EESYNMag=(0.000212 0.000225 0.000238 0.000250)

for EESYN in ${EESYNMag[@]};
do
		for EISYN in `seq -f %.5f 0.00015 0.00001 0.00015`
		do
		EISYN=0.00015 #0.00015 (orig)
for IESYN in `seq -f %.5f 0.0005 0.0001 0.0005`
			do 
			for IISYN in `seq -f %.5f 0.00030 0.0001 0.00030`
				do
				./PrepScript.sh ${IKPUMPMAX_FS} ${SLOPE_FS} ${KOTH_FS} ${BINIT_FS} ${KOINIT_FS} ${IKPUMPMAX_PY} ${SLOPE_PY} ${KOTH_PY} ${BINIT_PY} ${KOINIT_PY} ${DURATION} ${DT} ${EESYN} ${EISYN} ${IESYN} ${IISYN} ${MCRATE} ${MCSLOPE} ${BCKRATEE} ${BCKNOISEE} ${BCKRATEI} ${BCKNOISEI} ${BCKWTEE} ${BCKWTEI} ${BCKWTIE} ${BCKWTII} ${IEXT} ${GKI} ${GKE} ${SET} ${CONNSEED} ${EXSEED} ${INSEED} ${numcorespersim} ${compute_flag}
				done
			done
		done
	done

			

