#/bin/bash

# $1 = FS IKPUMPMAX
# $2 = FS SLOPE
# $3 = FS KOTH
# $4 = FS BINIT 
# $5 = FS KOINIT

# $6 = PY IKPUMPMAX
# $7 = PY SLOPE
# $8 = PY KOTH
# $9 = PY BINIT 
# $10 = PY KOINIT (NOT USED AT THIS MOMENT)

# $11= cfg DURATION
# $12 = cfg DT
# $13 = cfg EESYN
# $14 = cfg EISYN
# $15 = cfg IESYN
# $16 = cfg IISYN


# $17 = netParams MCRATE
# $18 = netParams MCSLOPE
# $19 = netParams BCKRATEE
# $20 = netParams BCKNOISEE
# $21 = netParams BCKRATEI
# $22 = netParams  BCKNOISEI
# $23 = netParams BCKWTEE
# $24 = netParams BCKWTEI
# $25 = netParams BCKWTIE
# $26 = netParams BCKWTII
# $27 = FS/PY IEXT
# $28 = gKi FS
# $29 = gKe PY

# $30 = Set
# $31 = connseed
# $32 = inseed
# $33 = exseed

# $34 = CPUs per job
# $35 = compute flag


subdir=$1"_"$2"_"$3"_"$4"_"$5"_"$6"_"$7"_"$8"_"$9"_"${10}"_"${11}"_"${12}"_"${13}"_"${14}"_"${15}"_"${16}"_"${17}"_"${18}"_"${19}"_"${20}"_"${21}"_"${22}"_"${23}"_"${24}"_"${25}"_"${26}"_"${27}
#echo $subdir

basedir="/users/XXX/data/XXX/NetPyNE_outputs/SET"${30}"_tapering_gKi_"${28}"_gKe_"${29}"/"

if [ -d "${basedir}${subdir}" ]
then
echo "Directory exists\n"
exit 0
fi

echo $subdir
mkdir -p ${basedir}${subdir}

cp ./iext.mod ${basedir}${subdir}/iext.mod
cp ./ileak.mod ${basedir}${subdir}/ileak.mod
cp ./ikleak.mod ${basedir}${subdir}/ikleak.mod
cp ./ipotassium.mod ${basedir}${subdir}/ipotassium.mod
cp ./ipotassiumFS.mod ${basedir}${subdir}/ipotassiumFS.mod
cp ./ipotassiumM.mod ${basedir}${subdir}/ipotassiumM.mod
cp ./isodium.mod ${basedir}${subdir}/isodium.mod
cp ./isodiumP.mod ${basedir}${subdir}/isodiumP.mod
cp ./ikCa.mod ${basedir}${subdir}/ikCa.mod
cp ./kbalance.mod ${basedir}${subdir}/kbalance.mod
cp ./ikpump.mod ${basedir}${subdir}/ikpump.mod

cp ./init_net.py ${basedir}${subdir}/init_net.py

# sed  -e "s/\[IKPUMPMAX\]/$1/g" -e "s/\[SLOPE\]/$2/g" -e "s/\[KOTH\]/$3/g" -e "s/\[BINIT\]/$4/g" -e "s/\[KOINIT\]/$5/g"  FS.hoc.template > ${basedir}${subdir}/FS.hoc
sed  -e "s/\[IKPUMPMAX\]/$1/g" -e "s/\[IEXT\]/${27}/g" -e "s/\[GKI\]/${28}/g" FS.hoc.template > ${basedir}${subdir}/FS.hoc

# sed  -e "s/\[IKPUMPMAX\]/$6/g" -e "s/\[SLOPE\]/$7/g" -e "s/\[KOTH\]/$8/g" -e "s/\[BINIT\]/$9/g" -e "s/\[KOINIT\]/${10}/g"  PY.hoc.template > ${basedir}${subdir}/PY.hoc
sed  -e "s/\[IKPUMPMAX\]/$6/g" -e "s/\[IEXT\]/${27}/g"  -e "s/\[GKE\]/${29}/g" PY.hoc.template > ${basedir}${subdir}/PY.hoc

sed -e "s/\[DURATION\]/${11}/g" -e "s/\[DT\]/${12}/g" -e "s/\[EESYN\]/${13}/g" -e "s/\[EISYN\]/${14}/g" -e "s/\[IESYN\]/${15}/g" -e "s/\[IISYN\]/${16}/g"  -e "s/\[CONNSEED\]/${31}/g" cfg_net.py.template.py > ${basedir}${subdir}/cfg_net.py

sed  -e "s/\[SLOPEI\]/$2/g"  -e "s/\[KOTHI\]/$3/g" -e "s/\[BINITI\]/$4/g" -e "s/\[KOINIT\]/$5/g"  -e "s/\[SLOPEE\]/$7/g" -e "s/\[KOTHE\]/$8/g" -e "s/\[BINITE\]/$9/g" -e "s/\[KOINIT\]/${10}/g" -e "s/\[DT\]/${12}/g" -e "s/\[MCRATE\]/${17}/g" -e "s/\[MCSLOPE\]/${18}/g" -e "s/\[BCKRATEE\]/${19}/g" -e "s/\[BCKNOISEE\]/${20}/g" -e "s/\[BCKRATEI\]/${21}/g" -e "s/\[BCKNOISEI\]/${22}/g" -e "s/\[BCKWTEE\]/${23}/g" -e "s/\[BCKWTEI\]/${24}/g" -e "s/\[BCKWTIE\]/${25}/g" -e "s/\[BCKWTII\]/${26}/g" -e "s/\[EXSEED\]/${32}/g" -e "s/\[INSEED\]/${33}/g" netParams_net.py.template.py > ${basedir}${subdir}/netParams_net.py

cd ${basedir}${subdir}

slurmscriptname=slurm_${subdir}


cat>${slurmscriptname}.slurm<<EOF
#!/bin/bash
# SLURM submission
# Runtime request
#SBATCH --job-name NetPyNE
# SBATCH --time=00:02:00
#SBATCH --time=36:00:00

# Queue request
# SBATCH --ntasks=4
#SBATCH -n ${34}
#SBATCH --mem-per-cpu 6g
# SBATCH --nodes=1-1


# Specify an output file
#SBATCH -o ./NETPYNE-O-%j.out
#SBATCH -e ./NETPYNE-E-%j.out
#SBATCH --account=xxx-xxx-condo
# SBATCH --partition=bigmem
# SBATCH --max_nodes=3


export LD_LIBRARY_PATH=/oscar/home/xxx/local/python3.7/lib/

module load openmpi

source /oscar/home/xxx/local/nrn-env4/bin/activate

/oscar/home/xxx/local/nrn-env4/bin/nrnivmodl

mpiexec -n ${34} /oscar/home/xxx/local/nrn-env4/bin/nrniv -python -mpi init_net.py


wait
EOF

sbatch ${slurmscriptname}.slurm


