#!/bin/bash

compute_flag=1
numcorespersim=8 

IKPUMPMAX_FS=7
SLOPE_FS=-1.15
KOTH_FS=15
BINIT_FS=490
KOINIT_FS=3.5 #2.3


IKPUMPMAX_PY=7
SLOPE_PY=-1.15
KOTH_PY=15
BINIT_PY=495
KOINIT_PY=3.5 #2.3

DURATION=2500000
DT=0.015

MCRATE=0.6 #1.0 # diffusion const
MCSLOPE=0.01 # NOT USED

BCKRATEE=300 #
BCKNOISEE=1
BCKRATEI=300 #
BCKNOISEI=1

BCKWTEE=0.000404 
BCKWTEI=0.00061 
BCKWTIE=0.000953
BCKWTII=0.00117

IEXT=0.00011 # (mA/cm2) applied to pyramdial population only
GKI=10.0 
AHP=30.0 # GKCA
SET=7 # set number for different noise and connectivity configs

CONNSEED=1
EXSEED=1
INSEED=1
# random seeds
if [ ${SET} = 1 ] 
	then
	CONNSEED=1
	EXSEED=12
	INSEED=24
elif [ ${SET} = 2 ] 
	then
	CONNSEED=2
  	EXSEED=75
  	INSEED=57
elif [ ${SET} = 3 ]
	then
	CONNSEED=3
  	EXSEED=15
  	INSEED=2
elif [ ${SET} = 4 ] 
 	then
  	CONNSEED=4
  	EXSEED=80
  	INSEED=102
elif [ ${SET} = 5 ] 
	then
  	CONNSEED=5
  	EXSEED=63
  	INSEED=25
elif [ ${SET} = 6 ] 
	then
  	CONNSEED=6
  	EXSEED=125
  	INSEED=98
elif [ ${SET} = 7 ] 
	then
  	CONNSEED=7
  	EXSEED=236
  	INSEED=750
elif [ ${SET} = 8 ] 
	then
  	CONNSEED=8
  	EXSEED=89
  	INSEED=92
else 
	CONNSEED=1
	EXSEED=12
	INSEED=24
fi

EESYNMag=(0.000200 0.000212 0.000225 0.000238 0.000250 0.000262 0.000275 0.000288 0.000300 0.000312 0.000325 0.000338 0.000350 0.000362)

for EESYN in ${EESYNMag[@]};
do
		for EISYN in `seq -f %.5f 0.00015 0.00001 0.00015`
		do
		EISYN=0.00015 
			for IESYN in `seq -f %.5f 0.0005 0.0001 0.0005`
			do 
				for IISYN in `seq -f %.5f 0.00030 0.0001 0.00030`
				do
				./PrepScript.sh ${IKPUMPMAX_FS} ${SLOPE_FS} ${KOTH_FS} ${BINIT_FS} ${KOINIT_FS} ${IKPUMPMAX_PY} ${SLOPE_PY} ${KOTH_PY} ${BINIT_PY} ${KOINIT_PY} ${DURATION} ${DT} ${EESYN} ${EISYN} ${IESYN} ${IISYN} ${MCRATE} ${MCSLOPE} ${BCKRATEE} ${BCKNOISEE} ${BCKRATEI} ${BCKNOISEI} ${BCKWTEE} ${BCKWTEI} ${BCKWTIE} ${BCKWTII} ${IEXT} ${GKI} ${AHP} ${SET} ${CONNSEED} ${EXSEED} ${INSEED} ${numcorespersim} ${compute_flag}
				done
			done
		done
	done

			

