"""
init.py

Starting script to run NetPyNE-based cortical network model to study epilepsy.


Usage:
    python init.py # Run simulation, optionally plot a raster


MPI usage:
    mpiexec -n 4 nrniv -python -mpi init.py


Contributors: salvadordura@gmail.com
"""

#import matplotlib; matplotlib.use('Agg')  # to avoid graphics error in servers

from netpyne import sim
#import math

# read parameter files
cfg, netParams = sim.readCmdLineArgs(simConfigDefault='cfg_single.py', netParamsDefault='netParams_single.py')

# create network, run simulation and analyze output
#sim.createSimulateAnalyze(netParams, cfg)

sim.initialize(netParams, cfg)  # create network object and set cfg and net params
sim.net.createPops()                  # instantiate network populations
sim.net.createCells()                 # instantiate network cells based on defined populations
sim.net.defineCellShapes()
sim.net.connectCells()                # create connections between cells based on params
sim.net.addStims()                    # add external stimulation to cells (IClamps etc)
sim.net.addRxD()                      # add reaction-diffusion (RxD)
sim.setupRecording()             # setup variables to record for each cell (spikes, V traces, etc)
sim.simulate()
sim.analyze()      
