#!/bin/bash
# Head Script to create a subdirectory for each simulation for code and output storage, then submit a slurm script to run the sim
# Author: Ernest Ho


# Parameters and initial conditions for FS cells

GK=5.0 # PY 15.0, 5.0,  0.3
GAHP=9.0 # PY
TAUS=3.0
TAUGS=2.4


SLOPE=-1.15
IPUMPMAX=7.0
KOTHETA=15.0
KOEQ=3.0
IEXT=2.0
IPUMPFRAC=0.5

KOINIT=2.3
BINIT=495

#Simulation duration (ms) and dt (ms) for integration
DURATION=300000
DT=0.015

IARRAY=(0.000000 0.050000 0.062500 0.075000 0.087500 0.100000 0.112500 0.125000 0.137500 0.150000 0.162500 0.175000 0.187500 0.200000 0.225000 0.250000 0.300000) # injected current (uA/cm2)

for IEXT in ${IARRAY[@]}
	do
	./PrepScript_PY.sh ${GK} ${GAHP} ${SLOPE} ${IPUMPMAX} ${KOTHETA} ${KOEQ} ${IEXT} ${KOINIT} ${BINIT} ${DURATION} ${DT} ${IPUMPFRAC} ${TAUS} ${TAUGS}				
	done
						

