nrnivmodl mechanisms

par=p0

#Draw the morphology to be included in the master figure
echo "python3 drawmorph.py"
python3 drawmorph.py

bathConc=100.0
for mycoeff in 1.0 0.5 0.2 0.1 0.05
do
    echo "python3 sim_baclofenwashout_combe_lowmem.py 33e-3 30000 1000 $bathConc 10000 IC_RGSx${mycoeff} p0 > out_sim_baclofen_combe_washout_p0_IC_RGSx${mycoeff}_maxConc${bathConc}.txt"
    python3 sim_baclofenwashout_combe_lowmem.py 33e-3 30000 1000 $bathConc 10000 IC_RGSx${mycoeff} p0 > out_sim_baclofen_combe_washout_p0_IC_RGSx${mycoeff}_maxConc${bathConc}.txt
done


#Resting membrane potentials:
agonistConcs=(2e-6 4e-6 6e-6 1e-5 2e-5 4e-5 6e-5 1e-4 2e-4)
agonistConcs2=(1e-5 2e-5 3e-5 5e-5 1e-4 2e-4 3e-4 5e-4 1e-3)

for iconc in `seq 0 8`
do
    
  q=${agonistConcs[iconc]}
  qalt=${agonistConcs2[iconc]}

  for mycoeff in 1.0 0.1; do
    echo "python3 sim_baclofen_combe_restmemb.py 33e-3 3000 0 $q IC_RGSx${mycoeff} p0 > out_sim_baclofen_combe_restmemb_p0_IC_RGSx${mycoeff}_maxConc${q}.txt"
    python3 sim_baclofen_combe_restmemb.py 33e-3 3000 0 $q IC_RGSx${mycoeff} p0 > out_sim_baclofen_combe_restmemb_p0_IC_RGSx${mycoeff}_maxConc${q}.txt

    echo "python3 sim_baclofen_combe_restmemb.py 33e-3 3000 0 $qalt IC_RGSx${mycoeff} p0 > out_sim_baclofen_combe_restmemb_p0_IC_RGSx${mycoeff}_maxConc${qalt}.txt"
    python3 sim_baclofen_combe_restmemb.py 33e-3 3000 0 $qalt IC_RGSx${mycoeff} p0 > out_sim_baclofen_combe_restmemb_p0_IC_RGSx${mycoeff}_maxConc${qalt}.txt
  done
done

agonistConcs=(2e-6 4e-6 6e-6 1e-5 2e-5 4e-5 6e-5 1e-4 2e-4 3e-5 5e-5 3e-4 5e-4 1e-3)

#Threshold currents:
for mycoeff in 1.0 0.1; do
  for iconc in `seq 0 13`; do
    q=${agonistConcs[iconc]}
    #  for Dur in 10.0 20.0 50.0 10000.0 5.0; do
    for Dur in 5; do
      echo "python3 sim_baclofen_combe_findthr.py 33e-3 8000 3000 $q $Dur IC_RGSx${mycoeff} $par"
      python3 sim_baclofen_combe_findthr.py 33e-3 8000 3000 $q $Dur IC_RGSx${mycoeff} $par
    done
  done
done


#Rhythmic stimulus (LTP/LTD-inducing protocols) - first one seed with all concentrations
agonistConcs=(2e-6 4e-6 6e-6 1e-5 2e-5 4e-5 6e-5 1e-4 2e-4)
agonistConcs2=(1e-5 2e-5 3e-5 5e-5 1e-4 2e-4 3e-4 5e-4 1e-3)
myseed=1
Nsyn=50
for iconc in `seq 0 8`
do
    
  for mycoeff in 1.0 0.1
  do
    q=${agonistConcs[0]}
    qalt=${agonistConcs2[0]}

    #HFS
    echo "python3 sim_baclofen_combe_rhythmic_syn_inputs_inmdarec_carec.py 0.033 17000 10000 10 600 $Nsyn $q IC_RGSx${mycoeff} p0 1.0 $myseed 1" 
    python3 sim_baclofen_combe_rhythmic_syn_inputs_inmdarec_carec.py 0.033 17000 10000 10 600 $Nsyn $q IC_RGSx${mycoeff} p0 1.0 $myseed 1

    #LFS
    echo "python3 sim_baclofen_combe_rhythmic_syn_inputs_inmdarec_carec.py 0.033 17000 10000 500 12 $Nsyn $q IC_RGSx${mycoeff} p0 1.0 $myseed 1"
    python3 sim_baclofen_combe_rhythmic_syn_inputs_inmdarec_carec.py 0.033 17000 10000 500 12 $Nsyn $q IC_RGSx${mycoeff} p0 1.0 $myseed 1

    #Different conc
    #HFS
    echo "python3 sim_baclofen_combe_rhythmic_syn_inputs_inmdarec_carec.py 0.033 17000 10000 10 600 $Nsyn $qalt IC_RGSx${mycoeff} p0 1.0 $myseed 1" 
    python3 sim_baclofen_combe_rhythmic_syn_inputs_inmdarec_carec.py 0.033 17000 10000 10 600 $Nsyn $qalt IC_RGSx${mycoeff} p0 1.0 $myseed 1

    #LFS
    echo "python3 sim_baclofen_combe_rhythmic_syn_inputs_inmdarec_carec.py 0.033 17000 10000 500 12 $Nsyn $qalt IC_RGSx${mycoeff} p0 1.0 $myseed 1"
    python3 sim_baclofen_combe_rhythmic_syn_inputs_inmdarec_carec.py 0.033 17000 10000 500 12 $Nsyn $qalt IC_RGSx${mycoeff} p0 1.0 $myseed 1
  done
done

#Rhythmic stimulus (LTP/LTD-inducing protocols) - then five seeds with the chosen concentrations
agonistConcs=(1e-5)
agonistConcs2=(5e-5)

q=${agonistConcs[0]}
qalt=${agonistConcs2[0]}

for myseed in `seq 1 5`
do
  for mycoeff in 1.0 0.1
  do
    #HFS
    echo "python3 sim_baclofen_combe_rhythmic_syn_inputs_inmdarec_carec.py 0.033 17000 10000 10 600 $Nsyn $q IC_RGSx${mycoeff} p0 1.0 $myseed 1" 
    python3 sim_baclofen_combe_rhythmic_syn_inputs_inmdarec_carec.py 0.033 17000 10000 10 600 $Nsyn $q IC_RGSx${mycoeff} p0 1.0 $myseed 1

    #LFS
    echo "python3 sim_baclofen_combe_rhythmic_syn_inputs_inmdarec_carec.py 0.033 17000 10000 500 12 $Nsyn $q IC_RGSx${mycoeff} p0 1.0 $myseed 1"
    python3 sim_baclofen_combe_rhythmic_syn_inputs_inmdarec_carec.py 0.033 17000 10000 500 12 $Nsyn $q IC_RGSx${mycoeff} p0 1.0 $myseed 1


    #Different conc
    #HFS
    echo "python3 sim_baclofen_combe_rhythmic_syn_inputs_inmdarec_carec.py 0.033 17000 10000 10 600 $Nsyn $qalt IC_RGSx${mycoeff} p0 1.0 $myseed 1" 
    python3 sim_baclofen_combe_rhythmic_syn_inputs_inmdarec_carec.py 0.033 17000 10000 10 600 $Nsyn $qalt IC_RGSx${mycoeff} p0 1.0 $myseed 1

    #LFS
    echo "python3 sim_baclofen_combe_rhythmic_syn_inputs_inmdarec_carec.py 0.033 17000 10000 500 12 $Nsyn $qalt IC_RGSx${mycoeff} p0 1.0 $myseed 1"
    python3 sim_baclofen_combe_rhythmic_syn_inputs_inmdarec_carec.py 0.033 17000 10000 500 12 $Nsyn $qalt IC_RGSx${mycoeff} p0 1.0 $myseed 1
  
  done
done
