#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <gsl/gsl_errno.h>
#include <gsl/gsl_odeiv2.h>
#include <gsl/gsl_math.h>

/* Enums will be used for indexing purposes.   */
enum stateVariable { _gaba, _gabaGABABR, _gabaGABABRGi, _gabaGABABRGibg, _GABABR, _GABABRGi, _Gi, _GiaGDP, _GiaGTP, _GiaGTPRGS, _Gibg, _GIRK, _GIRKGibg, _GIRKGibg2, _GIRKGibg3, _GIRKGibg4, _RGS, _VGCC, _VGCCGibg, numStateVar };
enum param { _kf_R0, _kf_R1, _kr_R1, _kf_R2, _kr_R2, _kf_R3, _kf_R4, _kf_R5, _kr_R5, _kf_R6, _kr_R6, _kf_R7, _kr_R7, _kf_R8, _kf_R9, _kf_R10, _kr_R10, _kf_R11, _kr_R11, _kf_R12, _kr_R12, _kf_R13, _kr_R13, _kf_R14, _kr_R14, _k_gaba, numParam };
enum func { _oGIRKGibg4, _oVGCCGibg, _ogaba, numFunc };
enum eventLabel { on, off, numEvents };

/* The error codes indicate how many values a function returns.                             */
/* Each function expects the output buffer to be allocated with at least that many values   */

/* ODE vector field: y' = f(t,y;p)   */
int GABAB_signaling_vf(double t, const double y_[], double *f_, void *par){
	double *p_=par;
	if (!y_ || !f_) return 19;
/* 	constants   */
/* 	parameter values   */
	double kf_R0 = p_[_kf_R0];                                          /* [  0] */
	double kf_R1 = p_[_kf_R1];                                          /* [  1] */
	double kr_R1 = p_[_kr_R1];                                          /* [  2] */
	double kf_R2 = p_[_kf_R2];                                          /* [  3] */
	double kr_R2 = p_[_kr_R2];                                          /* [  4] */
	double kf_R3 = p_[_kf_R3];                                          /* [  5] */
	double kf_R4 = p_[_kf_R4];                                          /* [  6] */
	double kf_R5 = p_[_kf_R5];                                          /* [  7] */
	double kr_R5 = p_[_kr_R5];                                          /* [  8] */
	double kf_R6 = p_[_kf_R6];                                          /* [  9] */
	double kr_R6 = p_[_kr_R6];                                          /* [ 10] */
	double kf_R7 = p_[_kf_R7];                                          /* [ 11] */
	double kr_R7 = p_[_kr_R7];                                          /* [ 12] */
	double kf_R8 = p_[_kf_R8];                                          /* [ 13] */
	double kf_R9 = p_[_kf_R9];                                          /* [ 14] */
	double kf_R10 = p_[_kf_R10];                                        /* [ 15] */
	double kr_R10 = p_[_kr_R10];                                        /* [ 16] */
	double kf_R11 = p_[_kf_R11];                                        /* [ 17] */
	double kr_R11 = p_[_kr_R11];                                        /* [ 18] */
	double kf_R12 = p_[_kf_R12];                                        /* [ 19] */
	double kr_R12 = p_[_kr_R12];                                        /* [ 20] */
	double kf_R13 = p_[_kf_R13];                                        /* [ 21] */
	double kr_R13 = p_[_kr_R13];                                        /* [ 22] */
	double kf_R14 = p_[_kf_R14];                                        /* [ 23] */
	double kr_R14 = p_[_kr_R14];                                        /* [ 24] */
	double k_gaba = p_[_k_gaba];                                        /* [ 25] */
/* 	state variables   */
	double gaba = y_[_gaba];                                            /* [  0] */
	double gabaGABABR = y_[_gabaGABABR];                                /* [  1] */
	double gabaGABABRGi = y_[_gabaGABABRGi];                            /* [  2] */
	double gabaGABABRGibg = y_[_gabaGABABRGibg];                        /* [  3] */
	double GABABR = y_[_GABABR];                                        /* [  4] */
	double GABABRGi = y_[_GABABRGi];                                    /* [  5] */
	double Gi = y_[_Gi];                                                /* [  6] */
	double GiaGDP = y_[_GiaGDP];                                        /* [  7] */
	double GiaGTP = y_[_GiaGTP];                                        /* [  8] */
	double GiaGTPRGS = y_[_GiaGTPRGS];                                  /* [  9] */
	double Gibg = y_[_Gibg];                                            /* [ 10] */
	double GIRK = y_[_GIRK];                                            /* [ 11] */
	double GIRKGibg = y_[_GIRKGibg];                                    /* [ 12] */
	double GIRKGibg2 = y_[_GIRKGibg2];                                  /* [ 13] */
	double GIRKGibg3 = y_[_GIRKGibg3];                                  /* [ 14] */
	double GIRKGibg4 = y_[_GIRKGibg4];                                  /* [ 15] */
	double RGS = y_[_RGS];                                              /* [ 16] */
	double VGCC = y_[_VGCC];                                            /* [ 17] */
	double VGCCGibg = y_[_VGCCGibg];                                    /* [ 18] */
/* 	expressions   */
	double R0 = k_gaba - kf_R0*gaba;
	double R1 = kf_R1*gaba*GABABR-kr_R1*gabaGABABR;
	double R2 = kf_R2*gabaGABABR*Gi-kr_R2*gabaGABABRGi;
	double R3 = kf_R3*gabaGABABRGi;
	double R4 = kf_R4*gabaGABABRGibg;
	double R5 = kf_R5*GABABR*Gi-kr_R5*GABABRGi;
	double R6 = kf_R6*gaba*GABABRGi-kr_R6*gabaGABABRGi;
	double R7 = kf_R7*GiaGTP*RGS-kr_R7*GiaGTPRGS;
	double R8 = kf_R8*GiaGTPRGS;
	double R9 = kf_R9*GiaGDP*Gibg;
	double R10 = kf_R10*GIRK*Gibg-kr_R10*GIRKGibg;
	double R11 = kf_R11*GIRKGibg*Gibg-kr_R11*GIRKGibg2;
	double R12 = kf_R12*GIRKGibg2*Gibg-kr_R12*GIRKGibg3;
	double R13 = kf_R13*GIRKGibg3*Gibg-kr_R13*GIRKGibg4;
	double R14 = kf_R14*VGCC*Gibg-kr_R14*VGCCGibg;
	memset(f_,0,sizeof(double)*19); /* initialize with 0.0 */
	f_[0] = +R0-R1-R6;
	f_[1] = +R1-R2+R4;
	f_[2] = +R2-R3+R6;
	f_[3] = +R3-R4;
	f_[4] = -R1-R5;
	f_[5] = +R5-R6;
	f_[6] = -R2-R5+R9;
	f_[7] = +R8-R9;
	f_[8] = +R3-R7;
	f_[9] = +R7-R8;
	f_[10] = +R4-R9-R10-R11-R12-R13-R14;
	f_[11] = -R10;
	f_[12] = +R10-R11;
	f_[13] = +R11-R12;
	f_[14] = +R12-R13;
	f_[15] = +R13;
	f_[16] = -R7+R8;
	f_[17] = -R14;
	f_[18] = +R14;
	return GSL_SUCCESS;
}

/* ODE Jacobian: df(t,y;p)/dy   */
int GABAB_signaling_jac(double t, const double y_[], double *jac_, double *dfdt_, void *par){
	double *p_=par;
	if (!y_ || !jac_) return 361;
/* 	constants   */
/* 	parameter values   */
	double kf_R0 = p_[_kf_R0];                                          /* [  0] */
	double kf_R1 = p_[_kf_R1];                                          /* [  1] */
	double kr_R1 = p_[_kr_R1];                                          /* [  2] */
	double kf_R2 = p_[_kf_R2];                                          /* [  3] */
	double kr_R2 = p_[_kr_R2];                                          /* [  4] */
	double kf_R3 = p_[_kf_R3];                                          /* [  5] */
	double kf_R4 = p_[_kf_R4];                                          /* [  6] */
	double kf_R5 = p_[_kf_R5];                                          /* [  7] */
	double kr_R5 = p_[_kr_R5];                                          /* [  8] */
	double kf_R6 = p_[_kf_R6];                                          /* [  9] */
	double kr_R6 = p_[_kr_R6];                                          /* [ 10] */
	double kf_R7 = p_[_kf_R7];                                          /* [ 11] */
	double kr_R7 = p_[_kr_R7];                                          /* [ 12] */
	double kf_R8 = p_[_kf_R8];                                          /* [ 13] */
	double kf_R9 = p_[_kf_R9];                                          /* [ 14] */
	double kf_R10 = p_[_kf_R10];                                        /* [ 15] */
	double kr_R10 = p_[_kr_R10];                                        /* [ 16] */
	double kf_R11 = p_[_kf_R11];                                        /* [ 17] */
	double kr_R11 = p_[_kr_R11];                                        /* [ 18] */
	double kf_R12 = p_[_kf_R12];                                        /* [ 19] */
	double kr_R12 = p_[_kr_R12];                                        /* [ 20] */
	double kf_R13 = p_[_kf_R13];                                        /* [ 21] */
	double kr_R13 = p_[_kr_R13];                                        /* [ 22] */
	double kf_R14 = p_[_kf_R14];                                        /* [ 23] */
	double kr_R14 = p_[_kr_R14];                                        /* [ 24] */
	double k_gaba = p_[_k_gaba];                                        /* [ 25] */
/* 	state variables   */
	double gaba = y_[_gaba];                                            /* [  0] */
	double gabaGABABR = y_[_gabaGABABR];                                /* [  1] */
	double gabaGABABRGi = y_[_gabaGABABRGi];                            /* [  2] */
	double gabaGABABRGibg = y_[_gabaGABABRGibg];                        /* [  3] */
	double GABABR = y_[_GABABR];                                        /* [  4] */
	double GABABRGi = y_[_GABABRGi];                                    /* [  5] */
	double Gi = y_[_Gi];                                                /* [  6] */
	double GiaGDP = y_[_GiaGDP];                                        /* [  7] */
	double GiaGTP = y_[_GiaGTP];                                        /* [  8] */
	double GiaGTPRGS = y_[_GiaGTPRGS];                                  /* [  9] */
	double Gibg = y_[_Gibg];                                            /* [ 10] */
	double GIRK = y_[_GIRK];                                            /* [ 11] */
	double GIRKGibg = y_[_GIRKGibg];                                    /* [ 12] */
	double GIRKGibg2 = y_[_GIRKGibg2];                                  /* [ 13] */
	double GIRKGibg3 = y_[_GIRKGibg3];                                  /* [ 14] */
	double GIRKGibg4 = y_[_GIRKGibg4];                                  /* [ 15] */
	double RGS = y_[_RGS];                                              /* [ 16] */
	double VGCC = y_[_VGCC];                                            /* [ 17] */
	double VGCCGibg = y_[_VGCCGibg];                                    /* [ 18] */
/* 	expressions   */
	double R0 = k_gaba - kf_R0*gaba;
	double R1 = kf_R1*gaba*GABABR-kr_R1*gabaGABABR;
	double R2 = kf_R2*gabaGABABR*Gi-kr_R2*gabaGABABRGi;
	double R3 = kf_R3*gabaGABABRGi;
	double R4 = kf_R4*gabaGABABRGibg;
	double R5 = kf_R5*GABABR*Gi-kr_R5*GABABRGi;
	double R6 = kf_R6*gaba*GABABRGi-kr_R6*gabaGABABRGi;
	double R7 = kf_R7*GiaGTP*RGS-kr_R7*GiaGTPRGS;
	double R8 = kf_R8*GiaGTPRGS;
	double R9 = kf_R9*GiaGDP*Gibg;
	double R10 = kf_R10*GIRK*Gibg-kr_R10*GIRKGibg;
	double R11 = kf_R11*GIRKGibg*Gibg-kr_R11*GIRKGibg2;
	double R12 = kf_R12*GIRKGibg2*Gibg-kr_R12*GIRKGibg3;
	double R13 = kf_R13*GIRKGibg3*Gibg-kr_R13*GIRKGibg4;
	double R14 = kf_R14*VGCC*Gibg-kr_R14*VGCCGibg;
	memset(jac_,0,sizeof(double)*361); /* initialize with 0.0 */
	/*[ 0, 0]*/  jac_[0] = -(kf_R0+kf_R1*GABABR+kf_R6*GABABRGi);
	/*[ 0, 1]*/  jac_[1] = kr_R1;
	/*[ 0, 2]*/  jac_[2] = kr_R6;
	/*[ 0, 4]*/  jac_[4] = -kf_R1*gaba;
	/*[ 0, 5]*/  jac_[5] = -kf_R6*gaba;
	/*[ 1, 0]*/  jac_[19] = kf_R1*GABABR;
	/*[ 1, 1]*/  jac_[20] = -(kr_R1+kf_R2*Gi);
	/*[ 1, 2]*/  jac_[21] = kr_R2;
	/*[ 1, 3]*/  jac_[22] = kf_R4;
	/*[ 1, 4]*/  jac_[23] = kf_R1*gaba;
	/*[ 1, 6]*/  jac_[25] = -kf_R2*gabaGABABR;
	/*[ 2, 0]*/  jac_[38] = kf_R6*GABABRGi;
	/*[ 2, 1]*/  jac_[39] = kf_R2*Gi;
	/*[ 2, 2]*/  jac_[40] = -(kr_R6+kr_R2+kf_R3);
	/*[ 2, 5]*/  jac_[43] = kf_R6*gaba;
	/*[ 2, 6]*/  jac_[44] = kf_R2*gabaGABABR;
	/*[ 3, 2]*/  jac_[59] = kf_R3;
	/*[ 3, 3]*/  jac_[60] = -kf_R4;
	/*[ 4, 0]*/  jac_[76] = -kf_R1*GABABR;
	/*[ 4, 1]*/  jac_[77] = kr_R1;
	/*[ 4, 4]*/  jac_[80] = -(kf_R1*gaba+kf_R5*Gi);
	/*[ 4, 5]*/  jac_[81] = kr_R5;
	/*[ 4, 6]*/  jac_[82] = -kf_R5*GABABR;
	/*[ 5, 0]*/  jac_[95] = -kf_R6*GABABRGi;
	/*[ 5, 2]*/  jac_[97] = kr_R6;
	/*[ 5, 4]*/  jac_[99] = kf_R5*Gi;
	/*[ 5, 5]*/  jac_[100] = -(kr_R5+kf_R6*gaba);
	/*[ 5, 6]*/  jac_[101] = kf_R5*GABABR;
	/*[ 6, 1]*/  jac_[115] = -kf_R2*Gi;
	/*[ 6, 2]*/  jac_[116] = kr_R2;
	/*[ 6, 4]*/  jac_[118] = -kf_R5*Gi;
	/*[ 6, 5]*/  jac_[119] = kr_R5;
	/*[ 6, 6]*/  jac_[120] = -(kf_R2*gabaGABABR+kf_R5*GABABR);
	/*[ 6, 7]*/  jac_[121] = kf_R9*Gibg;
	/*[ 6,10]*/  jac_[124] = kf_R9*GiaGDP;
	/*[ 7, 7]*/  jac_[140] = -kf_R9*Gibg;
	/*[ 7, 9]*/  jac_[142] = kf_R8;
	/*[ 7,10]*/  jac_[143] = -kf_R9*GiaGDP;
	/*[ 8, 2]*/  jac_[154] = kf_R3;
	/*[ 8, 8]*/  jac_[160] = -kf_R7*RGS;
	/*[ 8, 9]*/  jac_[161] = kr_R7;
	/*[ 8,16]*/  jac_[168] = -kf_R7*GiaGTP;
	/*[ 9, 8]*/  jac_[179] = kf_R7*RGS;
	/*[ 9, 9]*/  jac_[180] = -(kr_R7+kf_R8);
	/*[ 9,16]*/  jac_[187] = kf_R7*GiaGTP;
	/*[10, 3]*/  jac_[193] = kf_R4;
	/*[10, 7]*/  jac_[197] = -kf_R9*Gibg;
	/*[10,10]*/  jac_[200] = -(kf_R9*GiaGDP+kf_R10*GIRK+kf_R11*GIRKGibg+kf_R12*GIRKGibg2+kf_R13*GIRKGibg3+kf_R14*VGCC);
	/*[10,11]*/  jac_[201] = -kf_R10*Gibg;
	/*[10,12]*/  jac_[202] = kr_R10-kf_R11*Gibg;
	/*[10,13]*/  jac_[203] = kr_R11-kf_R12*Gibg;
	/*[10,14]*/  jac_[204] = kr_R12-kf_R13*Gibg;
	/*[10,15]*/  jac_[205] = kr_R13;
	/*[10,17]*/  jac_[207] = -kf_R14*Gibg;
	/*[10,18]*/  jac_[208] = kr_R14;
	/*[11,10]*/  jac_[219] = -kf_R10*GIRK;
	/*[11,11]*/  jac_[220] = -kf_R10*Gibg;
	/*[11,12]*/  jac_[221] = kr_R10;
	/*[12,10]*/  jac_[238] = kf_R10*GIRK-kf_R11*GIRKGibg;
	/*[12,11]*/  jac_[239] = kf_R10*Gibg;
	/*[12,12]*/  jac_[240] = -(kr_R10+kf_R11*Gibg);
	/*[12,13]*/  jac_[241] = kr_R11;
	/*[13,10]*/  jac_[257] = kf_R11*GIRKGibg-kf_R12*GIRKGibg2;
	/*[13,12]*/  jac_[259] = kf_R11*Gibg;
	/*[13,13]*/  jac_[260] = -(kr_R11+kf_R12*Gibg);
	/*[13,14]*/  jac_[261] = kr_R12;
	/*[14,10]*/  jac_[276] = kf_R12*GIRKGibg2-kf_R13*GIRKGibg3;
	/*[14,13]*/  jac_[279] = kf_R12*Gibg;
	/*[14,14]*/  jac_[280] = -(kr_R12+kf_R13*Gibg);
	/*[14,15]*/  jac_[281] = kr_R13;
	/*[15,10]*/  jac_[295] = kf_R13*GIRKGibg3;
	/*[15,14]*/  jac_[299] = kf_R13*Gibg;
	/*[15,15]*/  jac_[300] = -kr_R13;
	/*[16, 8]*/  jac_[312] = -kf_R7*RGS;
	/*[16, 9]*/  jac_[313] = kr_R7+kf_R8;
	/*[16,16]*/  jac_[320] = -kf_R7*GiaGTP;
	/*[17,10]*/  jac_[333] = -kf_R14*VGCC;
	/*[17,17]*/  jac_[340] = -kf_R14*Gibg;
	/*[17,18]*/  jac_[341] = kr_R14;
	/*[18,10]*/  jac_[352] = kf_R14*VGCC;
	/*[18,17]*/  jac_[359] = kf_R14*Gibg;
	/*[18,18]*/  jac_[360] = -kr_R14;
	return GSL_SUCCESS;
}

/* ODE parameter Jacobian: df(t,y;p)/dp   */
int GABAB_signaling_jacp(double t, const double y_[], double *jacp_, double *dfdt_, void *par){
	double *p_=par;
	if (!y_ || !jacp_) return 494;
/* 	constants   */
/* 	parameter values   */
	double kf_R0 = p_[_kf_R0];                                          /* [  0] */
	double kf_R1 = p_[_kf_R1];                                          /* [  1] */
	double kr_R1 = p_[_kr_R1];                                          /* [  2] */
	double kf_R2 = p_[_kf_R2];                                          /* [  3] */
	double kr_R2 = p_[_kr_R2];                                          /* [  4] */
	double kf_R3 = p_[_kf_R3];                                          /* [  5] */
	double kf_R4 = p_[_kf_R4];                                          /* [  6] */
	double kf_R5 = p_[_kf_R5];                                          /* [  7] */
	double kr_R5 = p_[_kr_R5];                                          /* [  8] */
	double kf_R6 = p_[_kf_R6];                                          /* [  9] */
	double kr_R6 = p_[_kr_R6];                                          /* [ 10] */
	double kf_R7 = p_[_kf_R7];                                          /* [ 11] */
	double kr_R7 = p_[_kr_R7];                                          /* [ 12] */
	double kf_R8 = p_[_kf_R8];                                          /* [ 13] */
	double kf_R9 = p_[_kf_R9];                                          /* [ 14] */
	double kf_R10 = p_[_kf_R10];                                        /* [ 15] */
	double kr_R10 = p_[_kr_R10];                                        /* [ 16] */
	double kf_R11 = p_[_kf_R11];                                        /* [ 17] */
	double kr_R11 = p_[_kr_R11];                                        /* [ 18] */
	double kf_R12 = p_[_kf_R12];                                        /* [ 19] */
	double kr_R12 = p_[_kr_R12];                                        /* [ 20] */
	double kf_R13 = p_[_kf_R13];                                        /* [ 21] */
	double kr_R13 = p_[_kr_R13];                                        /* [ 22] */
	double kf_R14 = p_[_kf_R14];                                        /* [ 23] */
	double kr_R14 = p_[_kr_R14];                                        /* [ 24] */
	double k_gaba = p_[_k_gaba];                                        /* [ 25] */
/* 	state variables   */
	double gaba = y_[_gaba];                                            /* [  0] */
	double gabaGABABR = y_[_gabaGABABR];                                /* [  1] */
	double gabaGABABRGi = y_[_gabaGABABRGi];                            /* [  2] */
	double gabaGABABRGibg = y_[_gabaGABABRGibg];                        /* [  3] */
	double GABABR = y_[_GABABR];                                        /* [  4] */
	double GABABRGi = y_[_GABABRGi];                                    /* [  5] */
	double Gi = y_[_Gi];                                                /* [  6] */
	double GiaGDP = y_[_GiaGDP];                                        /* [  7] */
	double GiaGTP = y_[_GiaGTP];                                        /* [  8] */
	double GiaGTPRGS = y_[_GiaGTPRGS];                                  /* [  9] */
	double Gibg = y_[_Gibg];                                            /* [ 10] */
	double GIRK = y_[_GIRK];                                            /* [ 11] */
	double GIRKGibg = y_[_GIRKGibg];                                    /* [ 12] */
	double GIRKGibg2 = y_[_GIRKGibg2];                                  /* [ 13] */
	double GIRKGibg3 = y_[_GIRKGibg3];                                  /* [ 14] */
	double GIRKGibg4 = y_[_GIRKGibg4];                                  /* [ 15] */
	double RGS = y_[_RGS];                                              /* [ 16] */
	double VGCC = y_[_VGCC];                                            /* [ 17] */
	double VGCCGibg = y_[_VGCCGibg];                                    /* [ 18] */
/* 	expressions   */
	double R0 = k_gaba - kf_R0*gaba;
	double R1 = kf_R1*gaba*GABABR-kr_R1*gabaGABABR;
	double R2 = kf_R2*gabaGABABR*Gi-kr_R2*gabaGABABRGi;
	double R3 = kf_R3*gabaGABABRGi;
	double R4 = kf_R4*gabaGABABRGibg;
	double R5 = kf_R5*GABABR*Gi-kr_R5*GABABRGi;
	double R6 = kf_R6*gaba*GABABRGi-kr_R6*gabaGABABRGi;
	double R7 = kf_R7*GiaGTP*RGS-kr_R7*GiaGTPRGS;
	double R8 = kf_R8*GiaGTPRGS;
	double R9 = kf_R9*GiaGDP*Gibg;
	double R10 = kf_R10*GIRK*Gibg-kr_R10*GIRKGibg;
	double R11 = kf_R11*GIRKGibg*Gibg-kr_R11*GIRKGibg2;
	double R12 = kf_R12*GIRKGibg2*Gibg-kr_R12*GIRKGibg3;
	double R13 = kf_R13*GIRKGibg3*Gibg-kr_R13*GIRKGibg4;
	double R14 = kf_R14*VGCC*Gibg-kr_R14*VGCCGibg;
	memset(jacp_,0,sizeof(double)*494); /* initialize with 0.0 */
	/*[ 0, 0]*/  jacp_[0] = -gaba;
	/*[ 0, 1]*/  jacp_[1] = -gaba*GABABR;
	/*[ 0, 2]*/  jacp_[2] = gabaGABABR;
	/*[ 0, 9]*/  jacp_[9] = -gaba*GABABRGi;
	/*[ 0,10]*/  jacp_[10] = gabaGABABRGi;
	/*[ 0,25]*/  jacp_[25] = 1;
	/*[ 1, 1]*/  jacp_[27] = gaba*GABABR;
	/*[ 1, 2]*/  jacp_[28] = -gabaGABABR;
	/*[ 1, 3]*/  jacp_[29] = -gabaGABABR*Gi;
	/*[ 1, 4]*/  jacp_[30] = gabaGABABRGi;
	/*[ 1, 6]*/  jacp_[32] = gabaGABABRGibg;
	/*[ 2, 3]*/  jacp_[55] = gabaGABABR*Gi;
	/*[ 2, 4]*/  jacp_[56] = -gabaGABABRGi;
	/*[ 2, 5]*/  jacp_[57] = -gabaGABABRGi;
	/*[ 2, 9]*/  jacp_[61] = gaba*GABABRGi;
	/*[ 2,10]*/  jacp_[62] = -gabaGABABRGi;
	/*[ 3, 5]*/  jacp_[83] = gabaGABABRGi;
	/*[ 3, 6]*/  jacp_[84] = -gabaGABABRGibg;
	/*[ 4, 1]*/  jacp_[105] = -gaba*GABABR;
	/*[ 4, 2]*/  jacp_[106] = gabaGABABR;
	/*[ 4, 7]*/  jacp_[111] = -GABABR*Gi;
	/*[ 4, 8]*/  jacp_[112] = GABABRGi;
	/*[ 5, 7]*/  jacp_[137] = GABABR*Gi;
	/*[ 5, 8]*/  jacp_[138] = -GABABRGi;
	/*[ 5, 9]*/  jacp_[139] = -gaba*GABABRGi;
	/*[ 5,10]*/  jacp_[140] = gabaGABABRGi;
	/*[ 6, 3]*/  jacp_[159] = -gabaGABABR*Gi;
	/*[ 6, 4]*/  jacp_[160] = gabaGABABRGi;
	/*[ 6, 7]*/  jacp_[163] = -GABABR*Gi;
	/*[ 6, 8]*/  jacp_[164] = GABABRGi;
	/*[ 6,14]*/  jacp_[170] = GiaGDP*Gibg;
	/*[ 7,13]*/  jacp_[195] = GiaGTPRGS;
	/*[ 7,14]*/  jacp_[196] = -GiaGDP*Gibg;
	/*[ 8, 5]*/  jacp_[213] = gabaGABABRGi;
	/*[ 8,11]*/  jacp_[219] = -GiaGTP*RGS;
	/*[ 8,12]*/  jacp_[220] = GiaGTPRGS;
	/*[ 9,11]*/  jacp_[245] = GiaGTP*RGS;
	/*[ 9,12]*/  jacp_[246] = -GiaGTPRGS;
	/*[ 9,13]*/  jacp_[247] = -GiaGTPRGS;
	/*[10, 6]*/  jacp_[266] = gabaGABABRGibg;
	/*[10,14]*/  jacp_[274] = -GiaGDP*Gibg;
	/*[10,15]*/  jacp_[275] = -GIRK*Gibg;
	/*[10,16]*/  jacp_[276] = GIRKGibg;
	/*[10,17]*/  jacp_[277] = -GIRKGibg*Gibg;
	/*[10,18]*/  jacp_[278] = GIRKGibg2;
	/*[10,19]*/  jacp_[279] = -GIRKGibg2*Gibg;
	/*[10,20]*/  jacp_[280] = GIRKGibg3;
	/*[10,21]*/  jacp_[281] = -GIRKGibg3*Gibg;
	/*[10,22]*/  jacp_[282] = GIRKGibg4;
	/*[10,23]*/  jacp_[283] = -VGCC*Gibg;
	/*[10,24]*/  jacp_[284] = VGCCGibg;
	/*[11,15]*/  jacp_[301] = -GIRK*Gibg;
	/*[11,16]*/  jacp_[302] = GIRKGibg;
	/*[12,15]*/  jacp_[327] = GIRK*Gibg;
	/*[12,16]*/  jacp_[328] = -GIRKGibg;
	/*[12,17]*/  jacp_[329] = -GIRKGibg*Gibg;
	/*[12,18]*/  jacp_[330] = GIRKGibg2;
	/*[13,17]*/  jacp_[355] = GIRKGibg*Gibg;
	/*[13,18]*/  jacp_[356] = -GIRKGibg2;
	/*[13,19]*/  jacp_[357] = -GIRKGibg2*Gibg;
	/*[13,20]*/  jacp_[358] = GIRKGibg3;
	/*[14,19]*/  jacp_[383] = GIRKGibg2*Gibg;
	/*[14,20]*/  jacp_[384] = -GIRKGibg3;
	/*[14,21]*/  jacp_[385] = -GIRKGibg3*Gibg;
	/*[14,22]*/  jacp_[386] = GIRKGibg4;
	/*[15,21]*/  jacp_[411] = GIRKGibg3*Gibg;
	/*[15,22]*/  jacp_[412] = -GIRKGibg4;
	/*[16,11]*/  jacp_[427] = -GiaGTP*RGS;
	/*[16,12]*/  jacp_[428] = GiaGTPRGS;
	/*[16,13]*/  jacp_[429] = GiaGTPRGS;
	/*[17,23]*/  jacp_[465] = -VGCC*Gibg;
	/*[17,24]*/  jacp_[466] = VGCCGibg;
	/*[18,23]*/  jacp_[491] = VGCC*Gibg;
	/*[18,24]*/  jacp_[492] = -VGCCGibg;
	return GSL_SUCCESS;
}

/* Output Function (Observables)   */
int GABAB_signaling_func(double t, const double y_[], double *func_, void *par){
	double *p_=par;
	if (!y_ || !func_) return 3;
/* 	constants   */
/* 	parameter values   */
	double kf_R0 = p_[_kf_R0];                                          /* [  0] */
	double kf_R1 = p_[_kf_R1];                                          /* [  1] */
	double kr_R1 = p_[_kr_R1];                                          /* [  2] */
	double kf_R2 = p_[_kf_R2];                                          /* [  3] */
	double kr_R2 = p_[_kr_R2];                                          /* [  4] */
	double kf_R3 = p_[_kf_R3];                                          /* [  5] */
	double kf_R4 = p_[_kf_R4];                                          /* [  6] */
	double kf_R5 = p_[_kf_R5];                                          /* [  7] */
	double kr_R5 = p_[_kr_R5];                                          /* [  8] */
	double kf_R6 = p_[_kf_R6];                                          /* [  9] */
	double kr_R6 = p_[_kr_R6];                                          /* [ 10] */
	double kf_R7 = p_[_kf_R7];                                          /* [ 11] */
	double kr_R7 = p_[_kr_R7];                                          /* [ 12] */
	double kf_R8 = p_[_kf_R8];                                          /* [ 13] */
	double kf_R9 = p_[_kf_R9];                                          /* [ 14] */
	double kf_R10 = p_[_kf_R10];                                        /* [ 15] */
	double kr_R10 = p_[_kr_R10];                                        /* [ 16] */
	double kf_R11 = p_[_kf_R11];                                        /* [ 17] */
	double kr_R11 = p_[_kr_R11];                                        /* [ 18] */
	double kf_R12 = p_[_kf_R12];                                        /* [ 19] */
	double kr_R12 = p_[_kr_R12];                                        /* [ 20] */
	double kf_R13 = p_[_kf_R13];                                        /* [ 21] */
	double kr_R13 = p_[_kr_R13];                                        /* [ 22] */
	double kf_R14 = p_[_kf_R14];                                        /* [ 23] */
	double kr_R14 = p_[_kr_R14];                                        /* [ 24] */
	double k_gaba = p_[_k_gaba];                                        /* [ 25] */
/* 	state variables   */
	double gaba = y_[_gaba];                                            /* [  0] */
	double gabaGABABR = y_[_gabaGABABR];                                /* [  1] */
	double gabaGABABRGi = y_[_gabaGABABRGi];                            /* [  2] */
	double gabaGABABRGibg = y_[_gabaGABABRGibg];                        /* [  3] */
	double GABABR = y_[_GABABR];                                        /* [  4] */
	double GABABRGi = y_[_GABABRGi];                                    /* [  5] */
	double Gi = y_[_Gi];                                                /* [  6] */
	double GiaGDP = y_[_GiaGDP];                                        /* [  7] */
	double GiaGTP = y_[_GiaGTP];                                        /* [  8] */
	double GiaGTPRGS = y_[_GiaGTPRGS];                                  /* [  9] */
	double Gibg = y_[_Gibg];                                            /* [ 10] */
	double GIRK = y_[_GIRK];                                            /* [ 11] */
	double GIRKGibg = y_[_GIRKGibg];                                    /* [ 12] */
	double GIRKGibg2 = y_[_GIRKGibg2];                                  /* [ 13] */
	double GIRKGibg3 = y_[_GIRKGibg3];                                  /* [ 14] */
	double GIRKGibg4 = y_[_GIRKGibg4];                                  /* [ 15] */
	double RGS = y_[_RGS];                                              /* [ 16] */
	double VGCC = y_[_VGCC];                                            /* [ 17] */
	double VGCCGibg = y_[_VGCCGibg];                                    /* [ 18] */
/* 	expressions   */
	double R0 = k_gaba - kf_R0*gaba;
	double R1 = kf_R1*gaba*GABABR-kr_R1*gabaGABABR;
	double R2 = kf_R2*gabaGABABR*Gi-kr_R2*gabaGABABRGi;
	double R3 = kf_R3*gabaGABABRGi;
	double R4 = kf_R4*gabaGABABRGibg;
	double R5 = kf_R5*GABABR*Gi-kr_R5*GABABRGi;
	double R6 = kf_R6*gaba*GABABRGi-kr_R6*gabaGABABRGi;
	double R7 = kf_R7*GiaGTP*RGS-kr_R7*GiaGTPRGS;
	double R8 = kf_R8*GiaGTPRGS;
	double R9 = kf_R9*GiaGDP*Gibg;
	double R10 = kf_R10*GIRK*Gibg-kr_R10*GIRKGibg;
	double R11 = kf_R11*GIRKGibg*Gibg-kr_R11*GIRKGibg2;
	double R12 = kf_R12*GIRKGibg2*Gibg-kr_R12*GIRKGibg3;
	double R13 = kf_R13*GIRKGibg3*Gibg-kr_R13*GIRKGibg4;
	double R14 = kf_R14*VGCC*Gibg-kr_R14*VGCCGibg;
	func_[_oGIRKGibg4] = GIRKGibg4;
	func_[_oVGCCGibg] = VGCCGibg;
	func_[_ogaba] = gaba;
	return GSL_SUCCESS;
}

int GABAB_signaling_default(double t, double *p_){
	if (!p_) return numParam;
/* 	constants   */
	memset(p_,0,sizeof(double)*26); /* initialize with 0.0 */
	p_[_kf_R0] = 0.0535168989262411;
	p_[_kf_R1] = 0.00285888595867763;
	p_[_kr_R1] = 0.314477455454539;
	p_[_kf_R2] = 0.0251449235770638;
	p_[_kr_R2] = 0.0419082059617731;
	p_[_kf_R3] = 0.0209541029808865;
	p_[_kf_R4] = 0.167632823847092;
	p_[_kf_R5] = 0.0125724617885319;
	p_[_kr_R5] = 0.0209541029808865;
	p_[_kf_R6] = 0.00285888595867763;
	p_[_kr_R6] = 0.314477455454539;
	p_[_kf_R7] = 2e-06;
	p_[_kr_R7] = 0.002;
	p_[_kf_R8] = 0.03;
	p_[_kf_R9] = 0.00125;
	p_[_kf_R10] = 0.000154358980053402;
	p_[_kr_R10] = 0.0669308830676273;
	p_[_kf_R11] = 0.000154358980053402;
	p_[_kr_R11] = 0.0669308830676273;
	p_[_kf_R12] = 0.000154358980053402;
	p_[_kr_R12] = 0.0669308830676273;
	p_[_kf_R13] = 0.000154358980053402;
	p_[_kr_R13] = 0.0669308830676273;
	p_[_kf_R14] = 0.000154358980053402;
	p_[_kr_R14] = 0.0669308830676273;
	return GSL_SUCCESS;
}

int GABAB_signaling_init(double t, double *y_, void *par){
	double *p_=par;
	if (!y_ || !y_) return 19;
/* 	constants   */
/* 	parameter values   */
	double kf_R0 = p_[_kf_R0];                                          /* [  0] */
	double kf_R1 = p_[_kf_R1];                                          /* [  1] */
	double kr_R1 = p_[_kr_R1];                                          /* [  2] */
	double kf_R2 = p_[_kf_R2];                                          /* [  3] */
	double kr_R2 = p_[_kr_R2];                                          /* [  4] */
	double kf_R3 = p_[_kf_R3];                                          /* [  5] */
	double kf_R4 = p_[_kf_R4];                                          /* [  6] */
	double kf_R5 = p_[_kf_R5];                                          /* [  7] */
	double kr_R5 = p_[_kr_R5];                                          /* [  8] */
	double kf_R6 = p_[_kf_R6];                                          /* [  9] */
	double kr_R6 = p_[_kr_R6];                                          /* [ 10] */
	double kf_R7 = p_[_kf_R7];                                          /* [ 11] */
	double kr_R7 = p_[_kr_R7];                                          /* [ 12] */
	double kf_R8 = p_[_kf_R8];                                          /* [ 13] */
	double kf_R9 = p_[_kf_R9];                                          /* [ 14] */
	double kf_R10 = p_[_kf_R10];                                        /* [ 15] */
	double kr_R10 = p_[_kr_R10];                                        /* [ 16] */
	double kf_R11 = p_[_kf_R11];                                        /* [ 17] */
	double kr_R11 = p_[_kr_R11];                                        /* [ 18] */
	double kf_R12 = p_[_kf_R12];                                        /* [ 19] */
	double kr_R12 = p_[_kr_R12];                                        /* [ 20] */
	double kf_R13 = p_[_kf_R13];                                        /* [ 21] */
	double kr_R13 = p_[_kr_R13];                                        /* [ 22] */
	double kf_R14 = p_[_kf_R14];                                        /* [ 23] */
	double kr_R14 = p_[_kr_R14];                                        /* [ 24] */
	double k_gaba = p_[_k_gaba];                                        /* [ 25] */
	memset(y_,0,sizeof(double)*19); /* initialize with 0.0 */
	y_[_GABABR] = 400;
	y_[_Gi] = 2600;
	y_[_RGS] = 1000;
	return GSL_SUCCESS;
}

int GABAB_signaling_event(double t, double *y_, double *p_, int EventLabel, double dose){
	if (!y_ || EventLabel<0) return numEvents;
/* 	constants   */
/* 	parameter values   */
	double kf_R0 = p_[_kf_R0];                                          /* [  0] */
	double kf_R1 = p_[_kf_R1];                                          /* [  1] */
	double kr_R1 = p_[_kr_R1];                                          /* [  2] */
	double kf_R2 = p_[_kf_R2];                                          /* [  3] */
	double kr_R2 = p_[_kr_R2];                                          /* [  4] */
	double kf_R3 = p_[_kf_R3];                                          /* [  5] */
	double kf_R4 = p_[_kf_R4];                                          /* [  6] */
	double kf_R5 = p_[_kf_R5];                                          /* [  7] */
	double kr_R5 = p_[_kr_R5];                                          /* [  8] */
	double kf_R6 = p_[_kf_R6];                                          /* [  9] */
	double kr_R6 = p_[_kr_R6];                                          /* [ 10] */
	double kf_R7 = p_[_kf_R7];                                          /* [ 11] */
	double kr_R7 = p_[_kr_R7];                                          /* [ 12] */
	double kf_R8 = p_[_kf_R8];                                          /* [ 13] */
	double kf_R9 = p_[_kf_R9];                                          /* [ 14] */
	double kf_R10 = p_[_kf_R10];                                        /* [ 15] */
	double kr_R10 = p_[_kr_R10];                                        /* [ 16] */
	double kf_R11 = p_[_kf_R11];                                        /* [ 17] */
	double kr_R11 = p_[_kr_R11];                                        /* [ 18] */
	double kf_R12 = p_[_kf_R12];                                        /* [ 19] */
	double kr_R12 = p_[_kr_R12];                                        /* [ 20] */
	double kf_R13 = p_[_kf_R13];                                        /* [ 21] */
	double kr_R13 = p_[_kr_R13];                                        /* [ 22] */
	double kf_R14 = p_[_kf_R14];                                        /* [ 23] */
	double kr_R14 = p_[_kr_R14];                                        /* [ 24] */
	double k_gaba = p_[_k_gaba];                                        /* [ 25] */
/* 	state variables   */
	double gaba = y_[_gaba];                                            /* [  0] */
	double gabaGABABR = y_[_gabaGABABR];                                /* [  1] */
	double gabaGABABRGi = y_[_gabaGABABRGi];                            /* [  2] */
	double gabaGABABRGibg = y_[_gabaGABABRGibg];                        /* [  3] */
	double GABABR = y_[_GABABR];                                        /* [  4] */
	double GABABRGi = y_[_GABABRGi];                                    /* [  5] */
	double Gi = y_[_Gi];                                                /* [  6] */
	double GiaGDP = y_[_GiaGDP];                                        /* [  7] */
	double GiaGTP = y_[_GiaGTP];                                        /* [  8] */
	double GiaGTPRGS = y_[_GiaGTPRGS];                                  /* [  9] */
	double Gibg = y_[_Gibg];                                            /* [ 10] */
	double GIRK = y_[_GIRK];                                            /* [ 11] */
	double GIRKGibg = y_[_GIRKGibg];                                    /* [ 12] */
	double GIRKGibg2 = y_[_GIRKGibg2];                                  /* [ 13] */
	double GIRKGibg3 = y_[_GIRKGibg3];                                  /* [ 14] */
	double GIRKGibg4 = y_[_GIRKGibg4];                                  /* [ 15] */
	double RGS = y_[_RGS];                                              /* [ 16] */
	double VGCC = y_[_VGCC];                                            /* [ 17] */
	double VGCCGibg = y_[_VGCCGibg];                                    /* [ 18] */
/* 	expressions   */
	double R0 = k_gaba - kf_R0*gaba;
	double R1 = kf_R1*gaba*GABABR-kr_R1*gabaGABABR;
	double R2 = kf_R2*gabaGABABR*Gi-kr_R2*gabaGABABRGi;
	double R3 = kf_R3*gabaGABABRGi;
	double R4 = kf_R4*gabaGABABRGibg;
	double R5 = kf_R5*GABABR*Gi-kr_R5*GABABRGi;
	double R6 = kf_R6*gaba*GABABRGi-kr_R6*gabaGABABRGi;
	double R7 = kf_R7*GiaGTP*RGS-kr_R7*GiaGTPRGS;
	double R8 = kf_R8*GiaGTPRGS;
	double R9 = kf_R9*GiaGDP*Gibg;
	double R10 = kf_R10*GIRK*Gibg-kr_R10*GIRKGibg;
	double R11 = kf_R11*GIRKGibg*Gibg-kr_R11*GIRKGibg2;
	double R12 = kf_R12*GIRKGibg2*Gibg-kr_R12*GIRKGibg3;
	double R13 = kf_R13*GIRKGibg3*Gibg-kr_R13*GIRKGibg4;
	double R14 = kf_R14*VGCC*Gibg-kr_R14*VGCCGibg;
	switch(EventLabel){
	case on:
		p_[_k_gaba] = 100;
	break;
	case off:
		p_[_k_gaba] = 0;
	break;
	}
	return GSL_SUCCESS;
}
