TITLE GABAB_signaling
COMMENT
	automatically generated from an SBtab file
	date: Thu Jan 23 13:41:29 2025
ENDCOMMENT
NEURON {
	SUFFIX GABAB_signaling : OR perhaps POINT_PROCESS ?
	RANGE k_gaba : input
	RANGE oGIRKGibg4, oVGCCGibg, ogaba : output
	RANGE gaba : compound
	RANGE gabaGABABR : compound
	RANGE gabaGABABRGi : compound
	RANGE gabaGABABRGibg : compound
	RANGE GABABR : compound
	RANGE GABABRGi : compound
	RANGE Gi : compound
	RANGE GiaGDP : compound
	RANGE GiaGTP : compound
	RANGE GiaGTPRGS : compound
	RANGE Gibg : compound
	RANGE GIRK : compound
	RANGE GIRKGibg : compound
	RANGE GIRKGibg2 : compound
	RANGE GIRKGibg3 : compound
	RANGE GIRKGibg4 : compound
	RANGE RGS : compound
	RANGE VGCC : compound
	RANGE VGCCGibg : compound
: USEION ca READ cai VALENCE 2 : sth. like this may be needed for ions you have in your model
}
CONSTANT {
}
PARAMETER {
	kf_R0 = 0.0535169 (/ms): a kinetic parameter
	kf_R1 = 0.00285889 (/nM-ms): a kinetic parameter
	kr_R1 = 0.314477 (/ms): a kinetic parameter
	kf_R2 = 0.0251449 (/nM-ms): a kinetic parameter
	kr_R2 = 0.0419082 (/ms): a kinetic parameter
	kf_R3 = 0.0209541 (/ms): a kinetic parameter
	kf_R4 = 0.167633 (/ms): a kinetic parameter
	kf_R5 = 0.0125725 (/nM-ms): a kinetic parameter
	kr_R5 = 0.0209541 (/ms): a kinetic parameter
	kf_R6 = 0.00285889 (/nM-ms): a kinetic parameter
	kr_R6 = 0.314477 (/ms): a kinetic parameter
	kf_R7 = 2e-06 (/nM-ms): a kinetic parameter
	kr_R7 = 0.002 (/ms): a kinetic parameter
	kf_R8 = 0.03 (/ms): a kinetic parameter
	kf_R9 = 0.00125 (/nM-ms): a kinetic parameter
	kf_R10 = 0.000154359 (/nM-ms): a kinetic parameter
	kr_R10 = 0.0669309 (/ms): a kinetic parameter
	kf_R11 = 0.000154359 (/nM-ms): a kinetic parameter
	kr_R11 = 0.0669309 (/ms): a kinetic parameter
	kf_R12 = 0.000154359 (/nM-ms): a kinetic parameter
	kr_R12 = 0.0669309 (/ms): a kinetic parameter
	kf_R13 = 0.000154359 (/nM-ms): a kinetic parameter
	kr_R13 = 0.0669309 (/ms): a kinetic parameter
	kf_R14 = 0.000154359 (/nM-ms): a kinetic parameter
	kr_R14 = 0.0669309 (/ms): a kinetic parameter
	k_gaba  = 0 (nM/ms) : an input
}
ASSIGNED {
	time (millisecond) : alias for t
	R0 : a flux, for use in DERIVATIVE mechanism
	R1 : a flux, for use in DERIVATIVE mechanism
	R2 : a flux, for use in DERIVATIVE mechanism
	R3 : a flux, for use in DERIVATIVE mechanism
	R4 : a flux, for use in DERIVATIVE mechanism
	R5 : a flux, for use in DERIVATIVE mechanism
	R6 : a flux, for use in DERIVATIVE mechanism
	R7 : a flux, for use in DERIVATIVE mechanism
	R8 : a flux, for use in DERIVATIVE mechanism
	R9 : a flux, for use in DERIVATIVE mechanism
	R10 : a flux, for use in DERIVATIVE mechanism
	R11 : a flux, for use in DERIVATIVE mechanism
	R12 : a flux, for use in DERIVATIVE mechanism
	R13 : a flux, for use in DERIVATIVE mechanism
	R14 : a flux, for use in DERIVATIVE mechanism
	oGIRKGibg4 : an observable
	oVGCCGibg : an observable
	ogaba : an observable
}
PROCEDURE assign_calculated_values() {
	time = t : an alias for the time variable, if needed.
	R0 = k_gaba - kf_R0*gaba : flux expression R0
	R1 = kf_R1*gaba*GABABR-kr_R1*gabaGABABR : flux expression R1
	R2 = kf_R2*gabaGABABR*Gi-kr_R2*gabaGABABRGi : flux expression R2
	R3 = kf_R3*gabaGABABRGi : flux expression R3
	R4 = kf_R4*gabaGABABRGibg : flux expression R4
	R5 = kf_R5*GABABR*Gi-kr_R5*GABABRGi : flux expression R5
	R6 = kf_R6*gaba*GABABRGi-kr_R6*gabaGABABRGi : flux expression R6
	R7 = kf_R7*GiaGTP*RGS-kr_R7*GiaGTPRGS : flux expression R7
	R8 = kf_R8*GiaGTPRGS : flux expression R8
	R9 = kf_R9*GiaGDP*Gibg : flux expression R9
	R10 = kf_R10*GIRK*Gibg-kr_R10*GIRKGibg : flux expression R10
	R11 = kf_R11*GIRKGibg*Gibg-kr_R11*GIRKGibg2 : flux expression R11
	R12 = kf_R12*GIRKGibg2*Gibg-kr_R12*GIRKGibg3 : flux expression R12
	R13 = kf_R13*GIRKGibg3*Gibg-kr_R13*GIRKGibg4 : flux expression R13
	R14 = kf_R14*VGCC*Gibg-kr_R14*VGCCGibg : flux expression R14
}
STATE {
	gaba (nM) : a state variable
	gabaGABABR (nM) : a state variable
	gabaGABABRGi (nM) : a state variable
	gabaGABABRGibg (nM) : a state variable
	GABABR (nM) : a state variable
	GABABRGi (nM) : a state variable
	Gi (nM) : a state variable
	GiaGDP (nM) : a state variable
	GiaGTP (nM) : a state variable
	GiaGTPRGS (nM) : a state variable
	Gibg (nM) : a state variable
	GIRK (nM) : a state variable
	GIRKGibg (nM) : a state variable
	GIRKGibg2 (nM) : a state variable
	GIRKGibg3 (nM) : a state variable
	GIRKGibg4 (nM) : a state variable
	RGS (nM) : a state variable
	VGCC (nM) : a state variable
	VGCCGibg (nM) : a state variable
}
INITIAL {
	 gaba = 0 : initial condition
	 gabaGABABR = 0 : initial condition
	 gabaGABABRGi = 0 : initial condition
	 gabaGABABRGibg = 0 : initial condition
	 GABABR = 400 : initial condition
	 GABABRGi = 0 : initial condition
	 Gi = 2600 : initial condition
	 GiaGDP = 0 : initial condition
	 GiaGTP = 0 : initial condition
	 GiaGTPRGS = 0 : initial condition
	 Gibg = 0 : initial condition
	 GIRK = 0 : initial condition
	 GIRKGibg = 0 : initial condition
	 GIRKGibg2 = 0 : initial condition
	 GIRKGibg3 = 0 : initial condition
	 GIRKGibg4 = 0 : initial condition
	 RGS = 1000 : initial condition
	 VGCC = 0 : initial condition
	 VGCCGibg = 0 : initial condition
}
BREAKPOINT {
	SOLVE ode METHOD cnexp
	assign_calculated_values() : procedure
}
DERIVATIVE ode {
	gaba' = R0-R1-R6 : affects compound gaba
	gabaGABABR' = R1-R2+R4 : affects compound gabaGABABR
	gabaGABABRGi' = R2-R3+R6 : affects compound gabaGABABRGi
	gabaGABABRGibg' = R3-R4 : affects compound gabaGABABRGibg
	GABABR' = -R1-R5 : affects compound GABABR
	GABABRGi' = R5-R6 : affects compound GABABRGi
	Gi' = -R2-R5+R9 : affects compound Gi
	GiaGDP' = R8-R9 : affects compound GiaGDP
	GiaGTP' = R3-R7 : affects compound GiaGTP
	GiaGTPRGS' = R7-R8 : affects compound GiaGTPRGS
	Gibg' = R4-R9-R10-R11-R12-R13-R14 : affects compound Gibg
	GIRK' = -R10 : affects compound GIRK
	GIRKGibg' = R10-R11 : affects compound GIRKGibg
	GIRKGibg2' = R11-R12 : affects compound GIRKGibg2
	GIRKGibg3' = R12-R13 : affects compound GIRKGibg3
	GIRKGibg4' = R13 : affects compound GIRKGibg4
	RGS' = -R7+R8 : affects compound RGS
	VGCC' = -R14 : affects compound VGCC
	VGCCGibg' = R14 : affects compound VGCCGibg
}
PROCEDURE observables_func() {
	oGIRKGibg4 = GIRKGibg4 : Output ID oGIRKGibg4
	oVGCCGibg = VGCCGibg : Output ID oVGCCGibg
	ogaba = gaba : Output ID ogaba
}
