# GABAB signaling

This directory contains the model 'GABAB signaling' in the SBtab format, as
an Excel Spreadsheet. It is intended for use in R, using the [uqsa
package](github.com/icpm-kth/uqsa).

The R script [makeModel.R](./makeModel.R) loads this SBtab file and creates ordinary differential equation code in two languages:
- C, for use with [GSL solvers](https://www.gnu.org/software/gsl/doc/html/ode-initval.html)
- R, for use with the [deSolve](https://cran.r-project.org/package=deSolve) package

Afterwards, `makeModel` will simulate the model once as a test and
show the results in a plot.

```R
source("makeModel.R")
```

The [documentation](https://icpm-kth.github.io/uqsa/index.html) of uqsa includes a short summary of how to install it. There is a system dependency: GSL and R package dependencies.


## Prerequisites

The solvers we use require the [GNU Scientific Library](https://www.gnu.org/software/gsl/doc/html/index.html) to be installed in your system.

The R packages are installed directly from Github, using the `remotes` package.

### System Libraries: GSL

On macOS:

```sh
brew install pkg-config gcc gsl
```

On Ubuntu:

```sh
sudo apt install pkg-config gcc libgsl-dev
```

On Alpine:

```sh
sudo apk add gcc gsl pkgconf
```

And similar for other GNU/Linux distributions.


### R Packages

You will need R, with the required packages and their dependencies:

- uqsa - generates code, uses rgsl to simulate biological experiments, which includes these as dependencies:
    + rgsl - an interface between R and the GSL `odeiv2` solvers
    + SBtabVFGEN - reads and interprets SBtab files


https://icpm-kth.github.io/uqsa/articles/installation.html

And also has a page about the code generators:

https://icpm-kth.github.io/uqsa/articles/generateCodeInR.html

from the uqsa webpage:

```R
install.packages("remotes")
remotes::install_github("icpm-kth/SBtabVFGEN",dependencies=TRUE)
remotes::install_github("icpm-kth/rgsl",dependencies=TRUE)
remotes::install_github("icpm-kth/uqsa",dependencies=TRUE)
```

The installation may prompt the user with questions, these questions
will eat the subsequent lines if you paste multiple lines into the
prompt. So, to be safe, perhaps do this line by line.


#### Possibly Confusing Questions that R asks

If you use R rarely, or for the first time, then package installation can start with some questins/decisions:

1. Where to install the package
   - `.libPaths()` tells you where packages are currently stored
   - `.Renviron` is a file, where you can set your preferred location, e.g. `R_LIBS=~/R/library` in that file, will make R store packages in `~/R/library`
2. Whether or not to update packages that you already have (with a numerical choice, e.g. 1 for _update All packages_, etc.)
   - make your choice and press one of the numbers
3. Which server to use
   - R may print a long list of mirrored servers and ask you which one to use
   - pick the one closest to you (but it doesn't matter)

#### RStudio

Sometimes, RStudio sessions produce errors that don't happen in a terminal session.
Try running the script in a terminal (by typing `R` in the terminal, and then sourcing the script):

```
~/Documents/GABAB$ R

R version 4.3.3 (2024-02-29) -- "Angel Food Cake"
Copyright (C) 2024 The R Foundation for Statistical Computing
Platform: x86_64-pc-linux-gnu (64-bit)
[...]

> source("makeModel.R")
```
