#after _old: add steady square pulse
#cp calcSpiking_extNTsyns_lowmem_manytrials_partialrandompresynGABA_GABABdel_givenpreflux.py calcSpiking_extNTsyns_rh_lowmem_manytrials_partialrandompresynGABA_GABABdel_givenpreflux.py: rhythmic instead of poisson input. Spines renamed as terminals. GABAB postsynaptically present only where inputs are present
#after _old.py: remove stim_flux_GABAB_presyn from being a command line argument, use the flux from fit for the presynaptic terminal
#cp calcFIplanes_withbaclofen_blocked_givenst2_givenT_scalesomaticI_varconc_constsurfGABAGIRK.py calcSpiking_extNTsyns.py
#cp calcFIplanes_withbaclofen_blocked_givenst2_givenT_scalesomaticI_varconc.py calcFIplanes_withbaclofen_blocked_givenst2_givenT_scalesomaticI_varconc_constsurf.py :Keep the surface expression the same, change the concentration when diameter other than 0.4um (as in the spine) used
#cp calcifcurves_hay_withGABAinputs.py calcifcurves_hay_withGABAinputs_inline.py # don't use the functions of the template, try to make them inline instead
#cp ../modulhcn_hay/calcifcurves.py calcifcurves_hay.py
#cp ../haymod3e/runcontrol_check.py runcontrol.py
# runcontrols
# A script for determining the control neuron F-I curve and limit cycle.
#
# The input code for the hoc-interface is based on BAC_firing.hoc by Etay Hay (2011)
#
# Tuomo Maki-Marttunen, Oct 2014
# (CC BY)

from neuron import h
from neuron import rxd
import mytools
import pickle
import numpy as np
import sys
import time
from pylab import *
import scipy.io

Ntrials = 10 
stim_del = 10000             #Stimulation starts after stim_del*i_stim (ms)
stim_dur = 500               #Duration of stimulation (ms)
stim_Nsyn_exc = 500          #Number of synapses along the dendrites
Nterminals = 10                 #Number of axons. Each synapse is assigned one out of Nterminals axons whose outputs are received at the post-synaptic side
NterminalsWithGABAB = 0         #Number of axons with GABAB-activation
stim_f = 20                  #Frequency of APs (rhythmic) during the stimulation
stim_prob = 0.5              #Probability of presynaptic AP at each independent axon at each rhythmic (stim_f) cycle
stim_del_GABAB = 0           #Does the GABAB activating stimulus come at the same time as the start of the exc stimulus (0 ms), before (< 0ms) or after (> 0 ms)
stim_flux_GABAB = 0.001      #Flux of GABA at time stim_dur, lasting for dur_stim_GABA ms
stim_flux_GABAB_presyn = 0.001 #Flux of GABA at time stim_dur, lasting for dur_stim_GABA ms, in presynaptic terminals
dur_stim_GABA = 500.0

gsyn_exc = 0.003            #Exc. syn conductance max. amplitude
gCaNtypebar_single = 2.7e-6 #uS (https://www.nature.com/articles/nn.2657) #13e-6 #uS (https://www.ncbi.nlm.nih.gov/books/NBK6181/)
minCa = 5e-6
Fmax = 0.001
Vesmax = 0.001    #Concentration of vesicles (mM)
stimAmp = 0.3
kcoeff_f = 5e-06 
kcoeff_b = 1.0
kcoeff_2f = 100.0
kcoeff_2b = 1.0
kcoeff_3 = 1.0
kcoeff_4 = 1.0
decay = 1.0

gnabar = 3.9  #L5PCbiophysics4.hoc
gkbar = 0.077 #L5PCbiophysics4.hoc
gl = 0.00003  #L5PCbiophysics4.hoc
el = -90      #L5PCbiophysics4.hoc
NMDAfactor = 0.7 #This was used in BBP models
MgCon = 1.0
steadyCurrent = 0.0
steadyCurrentDev = 0.1

NTcoeff = 0.013             #from drawfitNTcoeff.py
loc = 'both0-1300'
myseed = 1
mytol = 1e-7
dodraw = 1
blockedStr = 'None'
iI2 = 0
#params_all = ['107.034,514.651,167.633,11.026,66.931,3.009,1.904,2.241,1507.740','91.805,846.811,67.856,9.858,71.217,5.000,1.817,2.170,3000.000','133.092,528.522,185.581,8.574,25.868,3.186,2.125,2.729,2815.426','108.557,729.183,292.710,2.473,16.923,4.406,2.127,2.973,696.729','111.531,708.687,165.616,10.797,93.218,2.903,1.728,2.235,2797.567','109.869,469.365,114.137,59.053,73.263,3.573,2.385,3.028,2852.993','84.387,57.393,126.013,4.253,57.544,5.000,1.722,2.122,929.204','126.993,135.047,348.945,3.733,18.257,3.800,2.647,3.237,2804.842','105.438,642.913,142.107,19.602,40.482,3.599,2.391,2.974,1386.488','91.403,459.570,97.658,3.443,65.833,5.000,1.540,1.942,2447.114','71.410,380.140,143.521,2.991,45.796,10.000,2.044,2.836,2126.204','146.055,702.846,310.725,3.041,13.076,3.334,2.351,3.166,2112.405','90.417,993.718,98.403,6.879,95.287,3.944,1.572,2.204,1413.654','119.681,591.014,91.960,89.687,88.948,3.453,2.300,2.755,2950.763','123.170,616.560,117.913,74.842,46.625,3.952,2.609,3.283,3000.000']
params_all = ['107.034,514.651,167.633,11.026,66.931,3.009,1.904,2.241,1507.740','91.805,846.811,67.856,9.858,71.217,5.000,1.817,2.170,3000.000','133.092,528.522,185.581,8.574,25.868,3.186,2.125,2.729,2815.426','108.557,729.183,292.710,2.473,16.923,4.406,2.127,2.973,696.729','111.531,708.687,165.616,10.797,93.218,2.903,1.728,2.235,2797.567','109.869,469.365,114.137,59.053,73.263,3.573,2.385,3.028,2852.993','84.387,57.393,126.013,4.253,57.544,5.000,1.722,2.122,929.204','126.993,135.047,348.945,3.733,18.257,3.800,2.647,3.237,2804.842','105.438,642.913,142.107,19.602,40.482,3.599,2.391,2.974,1386.488','91.403,459.570,97.658,3.443,65.833,5.000,1.540,1.942,2447.114','71.410,380.140,143.521,2.991,45.796,10.000,2.044,2.836,2126.204','146.055,702.846,310.725,3.041,13.076,3.334,2.351,3.166,2112.405','90.417,993.718,98.403,6.879,95.287,3.944,1.572,2.204,1413.654','119.681,591.014,91.960,89.687,88.948,3.453,2.300,2.755,2950.763','123.170,616.560,117.913,74.842,46.625,3.952,2.609,3.283,3000.000']

params_str = 'p0'
GIRKcond_single = 33e-3 #nS #https://www.jneurosci.org/content/jneuro/25/15/3787.full.pdf
surfDensityGABA = 8.3e-05  #8.302889405513118e-05 * 10**-18mol/um2, i.e. 50/um2
surfDensityGIRK = 0.00022 #0.00022085685818664896 * 10**-18mol/um2, i.e. 133/um2

if len(sys.argv) > 1:
  Ntrials = int(float(sys.argv[1]))
if len(sys.argv) > 2:
  steadyCurrent = float(sys.argv[2])  
if len(sys.argv) > 3:
  steadyCurrentDev = float(sys.argv[3])  
if len(sys.argv) > 4:
  stim_del = int(float(sys.argv[4]))
if len(sys.argv) > 5:
  stim_dur = int(float(sys.argv[5]))
if len(sys.argv) > 6:
  stim_Nsyn_exc = int(float(sys.argv[6]))
if len(sys.argv) > 7:
  gsyn_exc = float(sys.argv[7])
if len(sys.argv) > 8:
  Nterminals = int(float(sys.argv[8]))
if len(sys.argv) > 9:
  NterminalsWithGABAB = int(float(sys.argv[9]))
if len(sys.argv) > 10:
  stim_f = float(sys.argv[10])
if len(sys.argv) > 11:
  stim_prob = float(sys.argv[11])
if len(sys.argv) > 12:
  dur_stim_GABA = float(sys.argv[12])
if len(sys.argv) > 13:
  stim_del_GABAB = int(float(sys.argv[13]))
if len(sys.argv) > 14:
  stim_flux_GABAB = float(sys.argv[14])
if len(sys.argv) > 15:
  stim_flux_GABAB_presyn = float(sys.argv[15])
if len(sys.argv) > 16:
  blockedStr = sys.argv[16]
if len(sys.argv) > 17:
 params_str = sys.argv[17]
if len(sys.argv) > 18:
  loc = sys.argv[18]
if len(sys.argv) > 19:
  myseed = int(float(sys.argv[19]))
if len(sys.argv) > 20:
  mytol = float(sys.argv[20])
if len(sys.argv) > 21:
  dodraw = int(float(sys.argv[21])) 

if blockedStr == 'None':
  blockedStr = ''
if params_str[0] == 'p':
  iparam = int(params_str[1:])
  params = {'k[0]': float(params_all[iparam].split(',')[0]), 'k[1,9]': float(params_all[iparam].split(',')[1]), 'k[3,4,5,6,7,8]': float(params_all[iparam].split(',')[2]), 'k[15,17,19,21,23]': float(params_all[iparam].split(',')[3]), 'k[16,18,20,22,24]': float(params_all[iparam].split(',')[4]), 'OnlyExp0_RGS': float(params_all[iparam].split(',')[5]), 'OnlyExp1_RGS': float(params_all[iparam].split(',')[6]), 'OnlyExp2_RGS': float(params_all[iparam].split(',')[7]), 'gaba_flux': float(params_all[iparam].split(',')[8])}
else:
  params = {'k[0]': float(params_str.split(',')[0]), 'k[1,9]': float(params_str.split(',')[1]), 'k[3,4,5,6,7,8]': float(params_str.split(',')[2]), 'k[15,17,19,21,23]': float(params_str.split(',')[3]), 'k[16,18,20,22,24]': float(params_str.split(',')[4]), 'OnlyExp0_RGS': float(params_str.split(',')[5]), 'OnlyExp1_RGS': float(params_str.split(',')[6]), 'OnlyExp2_RGS': float(params_str.split(',')[7]), 'gaba_flux': float(params_str.split(',')[8])}


  
loc_tree = loc[0:4] #'apic' or 'dend' or 'both'
loc_start = int(loc[4:].split('-')[0]) #default 0
loc_end = int(loc[4:].split('-')[1]) #default 1300

seed(myseed)
icell = 0

tstop = stim_del*Ntrials+stim_del+stim_dur

for icell in range(0,1):
  morphology_file = "hay/cell"+str(icell+1)+".asc"
  biophys_file = "hay/L5PCbiophys3.hoc"
  template_file = "hay/L5PCtemplate_withsyns.hoc"
  v0 = -80
  ca0 = 0.0001

  distalpoints = [200,400,600,800]
  BACdt = 5.0

  h("""
load_file("stdlib.hoc")
load_file("stdrun.hoc")
objref cvode
cvode = new CVode()
cvode.active(1)
cvode.atol("""+str(mytol)+""")
load_file("import3d.hoc")
objref L5PC
load_file(\""""+biophys_file+"""\")
load_file(\""""+template_file+"""\")
L5PC = new L5PCtemplate(\""""+morphology_file+"""\")
access L5PC.soma
objref st1, st2

objref vsoma, vdends, recSite, isoma, cadends, casoma
vsoma = new Vector()
casoma = new Vector()
vdends = new List()
cadends = new List()
objref sl,ns,tvec, vrec, carec, icarec, caterminalrec
vrec = new Vector()
carec = new Vector()
icarec = new Vector()
caterminalrec = new Vector()
tvec = new Vector()
objref sl,ns,tvec
tvec = new Vector()
sl = new List()
double siteVec[2]
""")

  for idist in range(0,len(distalpoints)):
    h("""  
vdends.append(new Vector())
cadends.append(new Vector())
sl = L5PC.locateSites("apic","""+str(distalpoints[idist])+""")
maxdiam = 0
for(i=0;i<sl.count();i+=1){
  dd1 = sl.o[i].x[1]
  dd = L5PC.apic[sl.o[i].x[0]].diam(dd1)
  if (dd > maxdiam) {
    j = i
    maxdiam = dd
  }
}
siteVec[0] = sl.o[j].x[0]
siteVec[1] = sl.o[j].x[1]
L5PC.apic[siteVec[0]] cvode.record(&v(siteVec[1]),vdends.o[vdends.count()-1],tvec)
L5PC.apic[siteVec[0]] cvode.record(&cai(siteVec[1]),cadends.o[cadends.count()-1],tvec)
""")

  h("""
L5PC.soma cvode.record(&v(0.5),vsoma,tvec)
L5PC.soma cvode.record(&cai(0.5),casoma,tvec)
Napic = 0
Nbasal = 0
forsec L5PC.apical { Napic = Napic + 1 }
forsec L5PC.basal { Nbasal = Nbasal + 1 }
objref diams
""")

  secnames = []  #This will have the names of the sections where inputs will be placed
  isecs = [] #This will have the indices (to secnames) where the synapses will be located
  xsecs = [] #This will have the x along the section where the synapses will be located
  trees = [] #This will have the name of the tree

  for isyn in range(0,stim_Nsyn_exc):
    if isyn % 100 == 0:
      print("Setting AMPA/NMDA synapse "+str(isyn)+" / "+str(stim_Nsyn_exc))
    thisdist = loc_start+(loc_end-loc_start)*rand()
    loc_tree_this = loc_tree
    if loc_tree == 'both':
      #loc_tree_this = 'dend' if rand() < 282/1300. else 'apic' #probability according to maximal branch length
      #loc_tree_this = 'dend' if rand() < 3372.749191865997/(5844.271815342569+3372.749191865997) else 'apic' #probability according to total area
      loc_tree_this = 'dend' if rand() < 5133.491987391413/(5133.491987391413+7440.905948081189) else 'apic' #probability according to total dendritic length
    while loc_tree_this == 'dend' and thisdist > 282 or loc_tree_this == 'apic' and thisdist > 1300:
      thisdist = loc_start+(loc_end-loc_start)*rand()

    h("""sl = L5PC.locateSites(\""""+loc_tree_this+"""\","""+str(thisdist)+""")
diams = new Vector()
for(i=0;i<sl.count();i+=1){
  dd1 = sl.o[i].x[1]   
  dd = L5PC.apic[sl.o[i].x[0]].diam(dd1)
  diams.append(dd)
}                                       
""")
    probs = array(h.diams)/sum(array(h.diams))
    cumprobs = cumsum(probs)
    r = rand()
    myi = [j for j in range(0,len(cumprobs)) if cumprobs[j] >= r][0]
    h("""
siteVec[0] = sl.o["""+str(myi)+"""].x[0]          
siteVec[1] = sl.o["""+str(myi)+"""].x[1]          
""")
    secname = loc_tree_this+"["+str(int(h.siteVec[0]))+"]"
    if secname not in secnames:
      secnames.append(secname)
    isecname = [i for i in range(0,len(secnames)) if secname == secnames[i]][0]
    isecs.append(isecname)
    xsecs.append(h.siteVec[1])
    trees.append(loc_tree_this)

  #Make the presynaptic sections:
  axonPasLen = 100
  axonActLen = 20
  terminalLen = 0.8
  terminalDiam = 0.4
  my_volume = terminalLen * pi * (terminalDiam/2)**2 * 1e-15 #in litres; multiplied by 1e-18 to convert um3->m3 and by 1e3 for m3->l
  
  h("""
tstop = """+str(tstop)+"""
create axon[4*"""+str(Nterminals)+"""]
create terminal["""+str(Nterminals)+"""]
for (iterminal=0;iterminal<"""+str(Nterminals)+""";iterminal+=1) {
 if (iterminal % 5 == 0) {
  print "Generating iterminal ",iterminal," / """+str(Nterminals)+""" "
 }
 connect axon[4*iterminal+1](0), axon[4*iterminal+0](1)
 connect axon[4*iterminal+2](0), axon[4*iterminal+1](1)
 connect axon[4*iterminal+3](0), axon[4*iterminal+2](1)
 connect terminal[iterminal](0), axon[4*iterminal+1](1)
 for (i=0;i<4;i+=3) {
  axon[4*iterminal+i] L = """+str(axonPasLen)+"""
  axon[4*iterminal+i] diam = 1.0
  nseg = 5
 }
 for (i=1;i<3;i+=1) {
  axon[4*iterminal+i] L = """+str(axonActLen)+"""
  axon[4*iterminal+i] diam = 1.0
  axon[4*iterminal+i] insert NaTa_t
  axon[4*iterminal+i] insert K_Tst
  axon[4*iterminal+i] insert pas
  axon[4*iterminal+i] insert Ih 
  axon[4*iterminal+i] insert Im 
  axon[4*iterminal+i] insert CaDynamics_E2 
  axon[4*iterminal+i] insert Ca_LVAst 
  axon[4*iterminal+i] insert Ca_HVA
  axon[4*iterminal+i] insert SKv3_1 
  axon[4*iterminal+i] insert SK_E2 
  axon[4*iterminal+i] insert K_Pst 
  axon[4*iterminal+i] insert Nap_Et2  

  axon[4*iterminal+i] gNaTa_tbar_NaTa_t = """+str(gnabar)+"""
  axon[4*iterminal+i] gK_Tstbar_K_Tst = """+str(gkbar)+"""
  axon[4*iterminal+i] g_pas = """+str(gl)+"""
  axon[4*iterminal+i] e_pas = """+str(el)+"""
  axon[4*iterminal+i] gIhbar_Ih = 0.0001 
  axon[4*iterminal+i] gImbar_Im = 0.013322 
  axon[4*iterminal+i] decay_CaDynamics_E2 = 277.300774 
  axon[4*iterminal+i] gamma_CaDynamics_E2 = 0.000525 
  axon[4*iterminal+i] gCa_LVAstbar_Ca_LVAst = 0.000813 
  axon[4*iterminal+i] gCa_HVAbar_Ca_HVA = 0.000222 
  axon[4*iterminal+i] gSKv3_1bar_SKv3_1 = 0.473799 
  axon[4*iterminal+i] gSK_E2bar_SK_E2 = 0.000047 
  axon[4*iterminal+i] gK_Pstbar_K_Pst = 0.188851 
  axon[4*iterminal+i] gNap_Et2bar_Nap_Et2 = 0.005834 
  nseg = 5
 }
 terminal[iterminal] L = """+str(terminalLen)+"""
 terminal[iterminal].diam = """+str(terminalDiam)+"""

 terminal[iterminal] insert CaNtypeWillingReluctant
 terminal[iterminal] nseg = 1
}
terminal[0] cvode.record(&ica_CaNtypeWillingReluctant(0.5),icarec,tvec)
terminal[0] cvode.record(&cai(0.5),caterminalrec,tvec)
""")
  terminalcyts = [rxd.Region(h.terminal[i], name='terminalcyt'+str(i), nrn_region='i') for i in range(0,len(h.terminal))]
  terminal_volume = terminalLen * pi * (terminalDiam/2)**2 * 1e-15 #in litres; multiplied by 1e-18 to convert um3->m3 and by 1e3 for m3->l
  axon = h.axon
  terminal = h.terminal

  h("""
objref rds1, st1s
rds1 = new Random(1000*"""+str(myseed)+""")
rds1.uniform(0,1)
st1s = new List()
for (iterminal=0;iterminal<"""+str(Nterminals)+""";iterminal+=1) {
 st1s.append(new List())
 index_st1 = -1
 if (iterminal % 5 == 0) {
  print "Generating inputs for iterminal ",iterminal," / """+str(Nterminals)+""" "
 }
 for (itrial=0;itrial<"""+str(Ntrials)+""";itrial+=1) {
  pst=0 //presynaptic spike time
  while(pst < """+str(stim_dur)+"""){
   if (rds1.repick() < """+str(stim_prob)+""") {
    axon[4*iterminal+0] st1s.o[iterminal].append(new IClamp(0.5))
    index_st1 = index_st1 + 1
    st1s.o[iterminal].o[index_st1].del = (1+itrial)*"""+str(stim_del)+"""+pst
    st1s.o[iterminal].o[index_st1].dur = 0.5
    st1s.o[iterminal].o[index_st1].amp = 0.3
   }
   pst+= 1000/"""+str(stim_f)+"""
  }
 }
}
cai0_ca_ion = 50e-6
cai0_ca_ion = """+str(minCa)+"""
cao0_ca_ion = 2
terminal[0] area_terminal = area(0.5)
celsius = 33
objref steadyCurrents, rds2, rds2picks
rds2 = new Random(1234*"""+str(myseed)+""")
rds2.uniform(0,1)
rds2picks = new Vector()
steadyCurrents = new List()
for (itrial=0;itrial<"""+str(Ntrials)+""";itrial+=1) {
  rds2picks.append(rds2.repick())
  L5PC.soma steadyCurrents.append(new IClamp(0.5))
  steadyCurrents.o[itrial].del = (1+itrial)*"""+str(stim_del)+"""
  steadyCurrents.o[itrial].dur = """+str(stim_dur)+"""
  steadyCurrents.o[itrial].amp = """+str(steadyCurrent)+"""*(1-"""+str(steadyCurrentDev)+"""+2*"""+str(steadyCurrentDev)+"""*rds2picks.x[itrial])
  print "itrial=", itrial, ", amp=", steadyCurrents.o[itrial].amp
}  
""")
  
  #additionalblockeds = ['gCa_HVAbar_Ca_HVA','gCa_LVAstbar_Ca_LVAst','gIhbar_Ih','gImbar_Im','gK_Pstbar_K_Pst','gK_Tstbar_K_Tst','gNaTa_tbar_NaTa_t','gNaTs2_tbar_NaTs2_t','gNap_Et2bar_Nap_Et2','gSK_E2bar_SK_E2','gSKv3_1bar_SKv3_1']
  myMechs =  ['Ca_HVA','Ca_LVAst','Ih','Im','K_Pst','K_Tst','NaTa_t','Nap_Et2','SK_E2','SKv3_1','decay_CaDynamics_E2','gamma_CaDynamics_E2','minCai_CaDynamics_E2','']
  splitted = blockedStr.split('x')
  blockeds = 'x'.join(splitted[0:len(splitted)-1]).split(',')
  blockedCoeffs = splitted[len(splitted)-1].split(',')
  for iblock in range(0,len(blockeds)):
    if len(blockeds[iblock]) == 0:
      continue
    blockedStrThis = blockeds[iblock]+'x'+blockedCoeffs[iblock]
    isSomaOnly = 0
    isApicOnly = 0
    isDendOnly = 0
    if len(blockedStrThis) > 4 and blockedStrThis[0:4] == 'SOMA':
      isSomaOnly = 1
      blockedStrThis = blockedStrThis[4:]
    if len(blockedStrThis) > 4 and blockedStrThis[0:4] == 'APIC':
      isApicOnly = 1
      blockedStrThis = blockedStrThis[4:]
    if len(blockedStrThis) > 4 and blockedStrThis[0:4] == 'DEND':
      isDendOnly = 1
      blockedStrThis = blockedStrThis[4:]
    iblocked = [i for i in range(0,len(myMechs)) if myMechs[i] in blockedStrThis]
    if len(iblocked) == 0:
      print('blockedStrThis not recognized')
    else:
      xind = blockedStrThis.rfind('x')
      mysuff = myMechs[iblocked[0]]
      if isSomaOnly:
        print("""forsec L5PC.somatic if(ismembrane(\""""+mysuff+"""\")) """+blockedStrThis[0:xind]+""" = """+blockedStrThis[0:xind]+""" * """+blockedStrThis[xind+1:])
        h("""forsec L5PC.somatic if(ismembrane(\""""+mysuff+"""\")) """+blockedStrThis[0:xind]+""" = """+blockedStrThis[0:xind]+""" * """+blockedStrThis[xind+1:])
      elif isApicOnly:
        print("""forsec L5PC.apical if(ismembrane(\""""+mysuff+"""\")) """+blockedStrThis[0:xind]+""" = """+blockedStrThis[0:xind]+""" * """+blockedStrThis[xind+1:])
        h("""forsec L5PC.apical if(ismembrane(\""""+mysuff+"""\")) """+blockedStrThis[0:xind]+""" = """+blockedStrThis[0:xind]+""" * """+blockedStrThis[xind+1:])
      elif isDendOnly:
        print("""forsec L5PC.basal if(ismembrane(\""""+mysuff+"""\")) """+blockedStrThis[0:xind]+""" = """+blockedStrThis[0:xind]+""" * """+blockedStrThis[xind+1:])
        h("""forsec L5PC.basal if(ismembrane(\""""+mysuff+"""\")) """+blockedStrThis[0:xind]+""" = """+blockedStrThis[0:xind]+""" * """+blockedStrThis[xind+1:])
      else:
        print("""forall if(ismembrane(\""""+mysuff+"""\")) """+blockedStrThis[0:xind]+""" = """+blockedStrThis[0:xind]+""" * """+blockedStrThis[xind+1:])
        h("""forall if(ismembrane(\""""+mysuff+"""\")) """+blockedStrThis[0:xind]+""" = """+blockedStrThis[0:xind]+""" * """+blockedStrThis[xind+1:])


  A_terminal = h.area_terminal*1e-8 #multiplied by 1e-8 for conversion um2 -> cm2
  N_VGCC = 0.0001*1e-3*terminal_volume*6.022e23 #mM -> M -> mol -> number of molecules
  gCaNtypebar_tot = N_VGCC*gCaNtypebar_single #uS
  gCaNtypebar_per_area = gCaNtypebar_tot/A_terminal*1e-6 #uS -> uS/cm2 -> S/cm2

  h("""
for (iterminal=0;iterminal<"""+str(Nterminals)+""";iterminal+=1) {
 terminal[iterminal] gcalbar_CaNtypeWillingReluctant = """+str(gCaNtypebar_per_area)+"""
}
""")

  #Place the exc. synapses
  h("objref synlist,preconlist,nilstim,fih,synirec")
  h("synlist = new List()") #N.B. synlist will have NsynTot + NsynTotGABA elements but preTrainList and preconlist only NsynTotGABA elements.
  h("preconlist = new List()")
  h("synirec = new Vector()")
  for isyn in range(0,stim_Nsyn_exc):
    h("""
    L5PC."""+secnames[isecs[isyn]]+""" synlist.append(new AMPANMDA_externalNT("""+str(xsecs[isyn])+"""))
    syni = synlist.count()-1
    synlist.o[syni].gAMPAmax = """+str(gsyn_exc)+"""
    synlist.o[syni].gNMDAmax = """+str(gsyn_exc)+"""
    synlist.o[syni].MgCon = 0.7
    synlist.o[syni].NTcoeff = """+str(NTcoeff)+"""
""")
  if len(isecs) > 0:
    h("""L5PC."""+secnames[isecs[0]]+""" cvode.record(&synlist.o[0].i,synirec,tvec)""")
        
  species = ['gaba', 'gabaOut', 'GABABR', 'gabaGABABR', 'Gi', 'GABABRGi', 'gabaGABABRGi', 'gabaGABABRGibg', 'GiaGTP', 'GiaGDP', 'RGS', 'GiaGTPRGS', 'Gibg', 'GIRK', 'VGCC', 'GIRKGibg', 'GIRKGibg2', 'GIRKGibg3', 'GIRKGibg4', 'VGCCGibg', 'ca', 'Ffactor', 'Ffactorca4','Ves', 'Ffactorca4Ves', 'NT']
  tolstochange = 'Gi,GiaGDP,Gibg'.split(',')
  tolschange = [float(x) for x in '2,2,2'.split(',')]
  tolscales = [1.0 for i in range(0,len(species))]
  for itol in range(0,len(tolstochange)):
    for ispec in range(0,len(species)):
      if tolstochange[itol] == species[ispec]:
        tolscales[ispec] = tolscales[ispec]*10**(-tolschange[itol])

  Napic = int(h.Napic)
  Nbasal = int(h.Nbasal)
  #Insert biochemistry:
  cyts = []
  seclist = []
  for iiapic in range(0,len(list(h.L5PC.apical))):
    mysec = list(h.L5PC.apical)[iiapic]
    istart = mysec.name().find('apic')
    if mysec.name()[istart:] not in secnames: #Insert the intracellular mechanism and the GIRK channels only to those
      continue                                #sections where inputs are being present
    seclist.append(mysec)
    #print(mysec.name()+""" insert GIRK_Yim""")
    h(mysec.name()+""" insert GIRK_Yim""")
    cyts.append(rxd.Region(mysec, name='cyt_apic'+str(iiapic), nrn_region='i'))
    coords = [[mysec.x3d(i),mysec.y3d(i)] for i in range(0,mysec.n3d())]
  for iibasal in range(0,len(list(h.L5PC.basal))):
    mysec = list(h.L5PC.basal)[iibasal]
    istart = mysec.name().find('dend')
    if mysec.name()[istart:] not in secnames: #Insert the intracellular mechanism and the GIRK channels only to those
      continue                       #sections where inputs are being present
    seclist.append(mysec)
    #print(mysec.name()+""" insert GIRK_Yim""")
    h(mysec.name()+""" insert GIRK_Yim""")
    cyts.append(rxd.Region(mysec, name='cyt_basal'+str(iibasal), nrn_region='i'))
    coords = [[mysec.x3d(i),mysec.y3d(i)] for i in range(0,mysec.n3d())]
  #cyt = rxd.Region(seclist, name='cyt', nrn_region='i')
  print("cyt OK")
  iGIRK = [i for i in range(0,len(species)) if species[i] == 'GIRK'][0] #13    
  #//L5PC.distributeSyn()
  
  ks = [1.0]*31
  ks[0]   = 0.0005            # gaba --> gabaOut (forward)
  ks[1]   = 5.555000000000001 # gaba + GABABR <-> gabaGABABR (forward)
  ks[2]   = 0.005             # gaba + GABABR <-> gabaGABABR (backward)
  ks[3]   = 150.0             # gabaGABABR + Gi <-> gabaGABABRGi (forward)
  ks[4]   = 0.00025           # gabaGABABR + Gi <-> gabaGABABRGi (backward)
  ks[5]   = 0.000125          # gabaGABABRGi --> gabaGABABRGibg + GiaGTP (forward)
  ks[6]   = 0.001             # gabaGABABRGibg --> gabaGABABR + Gibg (forward)
  ks[7]   = 75.0              # GABABR + Gi <-> GABABRGi (forward)
  ks[8]   = 0.000125          # GABABR + Gi <-> GABABRGi (backward)
  ks[9]   = 5.555000000000001 # gaba + GABABRGi <-> gabaGABABRGi (forward)
  ks[10]  = 0.005             # gaba + GABABRGi <-> gabaGABABRGi (backward)
  ks[11]  = 2.0               # GiaGTP + RGS <-> GiaGTPRGS (forward)
  ks[12]  = 0.002             # GiaGTP + RGS <-> GiaGTPRGS (backward)
  ks[13]  = 0.03              # GiaGTPRGS --> GiaGDP + RGS (forward)
  ks[14]  = 1250.0            # GiaGDP + Gibg --> Gi (forward)
  ks[15]  = 14.0              # GIRK + Gibg <-> GIRKGibg (forward)
  ks[16]  = 0.001             # GIRK + Gibg <-> GIRKGibg (backward)
  ks[17]  = 14.0              # GIRKGibg + Gibg <-> GIRKGibg2 (forward)
  ks[18]  = 0.001             # GIRKGibg + Gibg <-> GIRKGibg2 (backward)
  ks[19]  = 14.0              # GIRKGibg2 + Gibg <-> GIRKGibg3 (forward)
  ks[20]  = 0.001             # GIRKGibg2 + Gibg <-> GIRKGibg3 (backward)
  ks[21]  = 14.0              # GIRKGibg3 + Gibg <-> GIRKGibg4 (forward)
  ks[22]  = 0.001             # GIRKGibg3 + Gibg <-> GIRKGibg4 (backward)
  ks[23]  = 14.0              # VGCC + Gibg <-> VGCCGibg (forward)
  ks[24]  = 0.001             # VGCC + Gibg <-> VGCCGibg (backward)
  ks[25] = 1e16*kcoeff_f      # 4*ca + Ffactor <-> Ffactorca4 (forward)
  ks[26] = 0.1*kcoeff_b       # 4*ca + Ffactor <-> Ffactorca4 (backward)
  ks[27] = 1000*kcoeff_2f     # Ffactorca4 + Ves <-> Ffactorca4Ves (forward)
  ks[28] = 0.1*kcoeff_2b      # Ffactorca4 + Ves <-> Ffactorca4Ves (backward)
  ks[29] = 4*kcoeff_3         # Ffactorca4Ves --> 10000*NT + Ffactor + Ves + 4*ca
  ks[30] = 10*kcoeff_4        # NT -->
    
  initvalues = [0.0, 0.0, 0.00039999999999999996, 0.0, 0.0026, 0.0, 0.0, 0.0, 0.0, 0.0, 0.001, 0.0, 0.0, 0.001, 9.999999999999999e-05, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Fmax, 0.0, Vesmax, 0.0, 0.0]

  #run_fitc_seed5_N2000_3_obj.pdf : initvalues and ks from this fit
  ks[0] = ks[0]*params['k[0]']
  for i in [1,9]:
    ks[i] = ks[i]*params['k[1,9]']
  for i in [2,10]:
    ks[i] = ks[i]*5.555*params['k[1,9]']*0.00011/0.005
  for i in [3,4,5,6,7,8]:
    ks[i] = ks[i]*params['k[3,4,5,6,7,8]']
  for i in [15,17,19,21,23]:
    ks[i] = ks[i]*params['k[15,17,19,21,23]']
  for i in [16,18,20,22,24]:
    ks[i] = ks[i]*params['k[16,18,20,22,24]']

  #surfDensityGIRK = 0.00022 #0.00022085685818664896 * 10**-18mol/um2, i.e. 133/um2
  h("""forall if(ismembrane("GIRK_Yim")) {
  gbar_GIRK_Yim = """+str(surfDensityGIRK)+"""*1e-18*6.022e23*1e8*"""+str(GIRKcond_single/1e9)+""" // surfDensityGIRK in attomols/um2, GIRKcond_single in nS. attomols/um2 -> mols/um2 -> count/um2 -> count/cm2 -> S/cm2
 } //                                                                                                                                                                  (*1e-18)   (*6.022e23)    (*1e8)  (*GIRKcond_single/1e9) 
""")
  print("GIRKs OK")

  
  def initial_GABABR(node):
    #print("initial_GABABR = "+str(surfDensityGABA*(pi*node.sec.diam*node.sec.L)/(pi*(node.sec.diam/2)**2*node.sec.L))+", t="+str(h.t)+", sec="+node.sec.name()) #surfDensity in 10**-18mol/um2, this gives out 10**-18mol/um3=mol/m3 = mmol/l = mM
    return surfDensityGABA*(pi*node.sec.diam*node.sec.L)/(pi*(node.sec.diam/2)**2*node.sec.L)

  def initial_GIRK(node):
    #print("initial_GIRK = "+str(surfDensityGIRK*(pi*node.sec.diam*node.sec.L)/(pi*(node.sec.diam/2)**2*node.sec.L))+", t="+str(h.t)+", sec="+node.sec.name()) #surfDensity in 10**-18mol/um2, this gives out 10**-18mol/um3=mol/m3 = mmol/l = mM
    return surfDensityGIRK*(pi*node.sec.diam*node.sec.L)/(pi*(node.sec.diam/2)**2*node.sec.L)

  def initial_VGCC(node):
    return initvalues[14] if node.sec in terminal else 0.0
  def initial_RGS(node):
    return initvalues[10]*params['OnlyExp1_RGS'] if node.sec in terminal else initvalues[10]*params['OnlyExp0_RGS'] #Use RGS concentration fit for EE synapse (post-syn compartment) in the post-syn sections and that for EE synapse (pre-syn compartment) in the pre-syn section
  def initial_Ves(node):
    return initvalues[23] if node.sec in terminal else 0.0
  def initial_Ffactor(node):
    return initvalues[21] if node.sec in terminal else 0.0

  cytsTot = cyts + terminalcyts
  
  #1) Species present in presynaptic terminals and inh. postsynaptic spines
  gaba = rxd.Species(cytsTot, name='gaba', charge=0, initial=initvalues[0], atolscale=tolscales[0])
  gabaOut = rxd.Species(cytsTot, name='gabaOut', charge=0, initial=initvalues[1], atolscale=tolscales[1])
  GABABR = rxd.Species(cytsTot, name='GABABR', charge=0, initial=initial_GABABR, atolscale=tolscales[2])
  gabaGABABR = rxd.Species(cytsTot, name='gabaGABABR', charge=0, initial=initvalues[3], atolscale=tolscales[3])
  Gi = rxd.Species(cytsTot, name='Gi', charge=0, initial=initvalues[4], atolscale=tolscales[4])
  GABABRGi = rxd.Species(cytsTot, name='GABABRGi', charge=0, initial=initvalues[5], atolscale=tolscales[5])
  gabaGABABRGi = rxd.Species(cytsTot, name='gabaGABABRGi', charge=0, initial=initvalues[6], atolscale=tolscales[6])
  gabaGABABRGibg = rxd.Species(cytsTot, name='gabaGABABRGibg', charge=0, initial=initvalues[7], atolscale=tolscales[7])
  GiaGTP = rxd.Species(cytsTot, name='GiaGTP', charge=0, initial=initvalues[8], atolscale=tolscales[8])
  GiaGDP = rxd.Species(cytsTot, name='GiaGDP', charge=0, initial=initvalues[9], atolscale=tolscales[9])
  RGS = rxd.Species(cytsTot, name='RGS', charge=0, initial=initial_RGS, atolscale=tolscales[10])
  GiaGTPRGS = rxd.Species(cytsTot, name='GiaGTPRGS', charge=0, initial=initvalues[11], atolscale=tolscales[11])
  Gibg = rxd.Species(cytsTot, name='Gibg', charge=0, initial=initvalues[12], atolscale=tolscales[12])
  GIRK = rxd.Species(cytsTot, name='GIRK', charge=0, initial=initial_GIRK, atolscale=tolscales[13])
  VGCC = rxd.Species(cytsTot, name='VGCC', charge=0, initial=initial_VGCC, atolscale=tolscales[14])
  GIRKGibg = rxd.Species(cytsTot, name='GIRKGibg', charge=0, initial=initvalues[15], atolscale=tolscales[15])
  GIRKGibg2 = rxd.Species(cytsTot, name='GIRKGibg2', charge=0, initial=initvalues[16], atolscale=tolscales[16])
  GIRKGibg3 = rxd.Species(cytsTot, name='GIRKGibg3', charge=0, initial=initvalues[17], atolscale=tolscales[17])
  GIRKGibg4 = rxd.Species(cytsTot, name='GIRKGibg4', charge=0, initial=initvalues[18], atolscale=tolscales[18])
  VGCCGibg = rxd.Species(cytsTot, name='VGCCGibg', charge=0, initial=initvalues[19], atolscale=tolscales[19])

  #2) Species present in presynaptic terminals
  ca = rxd.Species(terminalcyts, name='ca', charge=2, initial=initvalues[20], atolscale=tolscales[20])
  Ffactor = rxd.Species(terminalcyts, name='Ffactor', charge=0, initial=initial_Ffactor, atolscale=tolscales[21])
  Ffactorca4 = rxd.Species(terminalcyts, name='Ffactorca4', charge=0, initial=initvalues[22], atolscale=tolscales[22])
  Ves = rxd.Species(terminalcyts, name='Ves', charge=0, initial=initial_Ves, atolscale=tolscales[23])
  Ffactorca4Ves = rxd.Species(terminalcyts, name='Ffactorca4Ves', charge=0, initial=initvalues[24], atolscale=tolscales[24])
  NT = rxd.Species(terminalcyts, name='NT', charge=0, initial=initvalues[25], atolscale=tolscales[25])
  print('Species OK')

  gaba_flux_rates = []
  reaction_gaba_fluxes = []
  for icyt in range(0,len(seclist)):
    gaba_flux_rates.append(rxd.Parameter(cyts[icyt], initial=0))
    reaction_gaba_fluxes.append(rxd.Rate(gaba, gaba_flux_rates[icyt])) # gaba

  #Set the GABA fluxes to the GABAB receptors (presyn)
  gaba_flux_rates_presyn = []
  reaction_gaba_fluxes_presyn = []
  for icyt in range(0,len(terminalcyts)):
    gaba_flux_rates_presyn.append(rxd.Parameter(terminalcyts[icyt], initial=0))
    reaction_gaba_fluxes_presyn.append(rxd.Rate(gaba, gaba_flux_rates_presyn[icyt]))
    
  #print('working on cyt '+str(cyt))
  reaction000 = rxd.Reaction(gaba, gabaOut, ks[0])
  reaction001 = rxd.Reaction(gaba + GABABR, gabaGABABR, ks[1], ks[2])
  reaction002 = rxd.Reaction(gabaGABABR + Gi, gabaGABABRGi, ks[3], ks[4])
  reaction003 = rxd.Reaction(gabaGABABRGi, gabaGABABRGibg + GiaGTP, ks[5])
  reaction004 = rxd.Reaction(gabaGABABRGibg, gabaGABABR + Gibg, ks[6])
  reaction005 = rxd.Reaction(GABABR + Gi, GABABRGi, ks[7], ks[8])
  reaction006 = rxd.Reaction(gaba + GABABRGi, gabaGABABRGi, ks[9], ks[10])
  reaction007 = rxd.Reaction(GiaGTP + RGS, GiaGTPRGS, ks[11], ks[12])
  reaction008 = rxd.Reaction(GiaGTPRGS, GiaGDP + RGS, ks[13])
  reaction009 = rxd.Reaction(GiaGDP + Gibg, Gi, ks[14])
  reaction010 = rxd.Reaction(GIRK + Gibg, GIRKGibg, ks[15], ks[16])
  reaction011 = rxd.Reaction(GIRKGibg + Gibg, GIRKGibg2, ks[17], ks[18])
  reaction012 = rxd.Reaction(GIRKGibg2 + Gibg, GIRKGibg3, ks[19], ks[20])
  reaction013 = rxd.Reaction(GIRKGibg3 + Gibg, GIRKGibg4, ks[21], ks[22])
  reaction014 = rxd.Reaction(VGCC + Gibg, VGCCGibg, ks[23], ks[24])
  reaction015 = rxd.Reaction(4*ca + Ffactor, Ffactorca4, ks[25], ks[26]) #In Destexhe 1994 this reaction doesn't affect Ca concentration, here it does
  reaction016 = rxd.Reaction(Ffactorca4 + Ves, Ffactorca4Ves, ks[27], ks[28])
  reaction017 = rxd.Reaction(Ffactorca4Ves, 10000*NT + Ffactor + Ves + 4*ca, 10000*ks[29]*Ffactorca4Ves, 0, custom_dynamics=True) #Note: this is a bit different than in Destexhe 1994. Here the amount of Vesicles is dynamical, in Destexhe Ves was constant. Here the used vesicle and ca returns to baseline
  reaction018 = rxd.Reaction(NT, NT*0, ks[30])
  reaction019 = rxd.Rate(ca, -(ca - minCa)/decay)
  #print('cyt = '+str(cyt)+' done')
  print('Reactions OK')

  lastTimePrinted = -inf
  for icyt in range(0,len(terminalcyts)):
    if time.time() - lastTimePrinted > 5 or icyt == len(terminalcyts)-1:    
      print('Checking terminalcyts['+str(icyt)+']')
      lastTimePrinted = time.time()
    if len(NT.nodes(terminalcyts[icyt])) != 1:
      print('Warning: nseg in terminal more than one in terminalcyts['+str(icyt)+']')
  #Set the pointer for each of the synapses to point to the terminals
  lastTimePrinted = -inf
  for isyn in range(0,stim_Nsyn_exc):
    if time.time() - lastTimePrinted > 5 or isyn == stim_Nsyn_exc-1:    
      print('Setting pointer of exc. synapse '+str(isyn+1)+"/"+str(stim_Nsyn_exc))
      lastTimePrinted = time.time()
    h.setpointer(NT.nodes[isyn%Nterminals]._ref_concentration,'NT',h.synlist[isyn])
  print('Pointers OK')

  timenow = time.time()
  print('Initializing...')
  h.init()
  print('Initialization done in '+str(time.time()-timenow)+' sec')

  def set_param(param, val):
    param.nodes.value = val
    h.cvode.re_init()
  def add_param(param, val):
    #print("Old param.nodes.value = "+str(param.nodes.value)+", t="+str(h.t)+", NT="+str(h.synlist[0].NT))
    param.nodes.value = [q + val for q in param.nodes.value]
    #print("New param.nodes.value = "+str(param.nodes.value)+", t="+str(h.t)+", icyt="+str(icyt)+", name="+param.regions[0].name+", NT="+str(h.synlist[0].NT))
    h.cvode.re_init()      

  #Set the events (this has to be done after init())
  lastTimePrinted = -inf
  for icyt in range(0,len(seclist)):
    if time.time() - lastTimePrinted > 5 or icyt == len(seclist)-1:    
      print("Setting GABAB events for "+seclist[icyt].name())
      lastTimePrinted = time.time()
    #icyt = isecs_withGABAB[isyn] #Fetch the index of the corresponding cyt
    for itrial in range(0,Ntrials):
      h.cvode.event(stim_del*(itrial+1)+stim_del_GABAB,               lambda icyt=icyt: add_param(gaba_flux_rates[icyt], stim_flux_GABAB))
      h.cvode.event(stim_del*(itrial+1)+stim_del_GABAB+dur_stim_GABA, lambda icyt=icyt: add_param(gaba_flux_rates[icyt], -stim_flux_GABAB))

  lastTimePrinted = -inf
  for itrial in range(0,Ntrials):
    if time.time() - lastTimePrinted > 5 or itrial == Ntrials-1:    
      print("Setting GABAB events for trial "+str(itrial))
      lastTimePrinted = time.time()
    icyts = list(range(0,len(terminalcyts)))
    shuffle(icyts)
    for iicyt in range(0,min(NterminalsWithGABAB,len(terminalcyts))):
      h.cvode.event(stim_del*(itrial+1)+stim_del_GABAB,               lambda icyt=icyts[iicyt]: add_param(gaba_flux_rates_presyn[icyt], stim_flux_GABAB_presyn))
      h.cvode.event(stim_del*(itrial+1)+stim_del_GABAB+dur_stim_GABA, lambda icyt=icyts[iicyt]: add_param(gaba_flux_rates_presyn[icyt], -stim_flux_GABAB_presyn))
      #h.cvode.event(1000, lambda: add_param(gaba_flux_rate, gaba_input_flux/6.022e23/my_volume*1e3))
      #h.cvode.event(1000+gaba_input_dur, lambda: add_param(gaba_flux_rate, -gaba_input_flux/6.022e23/my_volume*1e3))

  
  print('Starting simulation...')
  h.continuerun(tstop)
  print("Simulation done in "+str(time.time()-timenow)+" seconds")
  times=np.array(h.tvec)
  Vsoma=np.array(h.vsoma)
  Vdends=np.array(h.vdends)
  Casoma=np.array(h.casoma)
  Cadends=np.array(h.cadends)
  iCaterminal=np.array(h.icarec)
  spikes = mytools.spike_times(times,Vsoma,-35,100)

  steadyCurrentAddition = '' if steadyCurrent == 0 else '_SC'+str(steadyCurrent)+'dev'+str(steadyCurrentDev)
  
  if dodraw:
    f,axarr = subplots(1,1)
    axarr.plot(times,Vsoma)    
    try:
      axarr.plot(spikes,[-30+50*rand() for x in spikes],'rx',mew=0.5,lw=0.3)
      f.savefig('spiking_extNTsyns_rh_lowmem'+steadyCurrentAddition+'_Ntrials'+str(Ntrials)+'_stim'+str(stim_del)+'_'+str(stim_dur)+'_'+str(stim_Nsyn_exc)+'_gsyn'+str(gsyn_exc)+'_Nterminalsrandom'+str(NterminalsWithGABAB)+'of'+str(Nterminals)+'_stimf'+str(stim_f)+'x'+str(stim_prob)+'_GABABdur'+str(dur_stim_GABA)+'_GABABdel'+str(stim_del_GABAB)+'_fluxGABAB'+str(stim_flux_GABAB)+'_'+str(stim_flux_GABAB_presyn)+'_'+str(blockedStr)+str(params_str)+'_'+str(loc)+'_tol'+str(mytol)+'_seed'+str(myseed)+'.pdf')
    except:
      print("Something wrong in savefig")

  #ts_int = [0.5*i for i in range(0,int(2*tstop))]
  ts_int = []
  for itrial in range(0,Ntrials):
    tstart = stim_del*itrial+stim_dur+100
    tend = stim_del*(itrial+1)-50
    ts1 = list(range(int(tstart),int(tend),20))
    tstart = tend
    tend = stim_del*(itrial+1)+stim_dur+100
    ts2 = [tstart+0.5*i for i in range(0,int(2*(tend-tstart)))]
    ts_int = ts_int + ts1 + ts2
  Vsoma_int = mytools.interpolate_extrapolate_constant(times,Vsoma,ts_int)
  Vdends_int = [mytools.interpolate_extrapolate_constant(times,Vdends[i],ts_int) for i in range(0,len(Vdends))]
  
  #picklelist = [times,Vsoma,distalpoints,Vdends,spikes]
  mydict = {'times': ts_int, 'Vsoma': Vsoma_int, 'distalpoints': distalpoints, 'Vdends': Vdends_int, 'spikes': spikes, 'rds2picks': array(h.rds2picks)}
  scipy.io.savemat('spiking_extNTsyns_rh_lowmem'+steadyCurrentAddition+'_Ntrials'+str(Ntrials)+'_stim'+str(stim_del)+'_'+str(stim_dur)+'_'+str(stim_Nsyn_exc)+'_gsyn'+str(gsyn_exc)+'_Nterminalsrandom'+str(NterminalsWithGABAB)+'of'+str(Nterminals)+'_stimf'+str(stim_f)+'x'+str(stim_prob)+'_GABABdur'+str(dur_stim_GABA)+'_GABABdel'+str(stim_del_GABAB)+'_fluxGABAB'+str(stim_flux_GABAB)+'_'+str(stim_flux_GABAB_presyn)+'_'+str(blockedStr)+str(params_str)+'_'+str(loc)+'_tol'+str(mytol)+'_seed'+str(myseed)+'.mat',mydict)
  #pickle.dump(picklelist,file)
  #file.close()

  h("""forall if(ismembrane("GIRK_Yim")) print secname()," ",gbar_GIRK_Yim""")

  #f,axarr =subplots(5,1); axarr[0].plot(times,iCaterminal); axarr[1].plot(times,array(vecs_all[0][20])); axarr[2].plot(times,array(vecs_all[0][22])); axarr[2].plot(times,array(vecs_all[0][24]));axarr[3].plot(times,array(vecs_all[0][25])); axarr[4].plot(times,array(h.synirec)); axarr[0].set_ylabel('iCaterminal',fontsize=7);axarr[1].set_ylabel('[Ca] terminal',fontsize=7);axarr[2].set_ylabel('[act ves,F]',fontsize=7);axarr[3].set_ylabel('[NT]',fontsize=7);axarr[4].set_ylabel('synirec',fontsize=7);f.savefig("test.pdf")
