"""

Description: This file lists essential global parameters and their default values.

Edit History: Created by Nilapratim Sengupta in July-August 2023.
              Modified by Nilapratim Sengupta in March 2025 for ModelDB upload.
              
"""

# Import statements
from neuron import h
from neuron.units import ms, mV, µm


# Parameters determining type of cell (young/aged), indices of model and parameters
type_cell = 2 # (2: Young; 3: Aged) Default 2
index_parameter = 2 # (Either 0, 1 or 2) Default 2
method_spineCorrection = 1 # (Either 1 or 2) Default 1

# Simulation parameters
membranePotential_initial = -70 * mV
duration_initial = 50 * ms
duration_extra = 100 * ms # Duration of simulation AFTER the current clamp ends.
time_currentStart = 15 * ms
time_currentStop = 2015 * ms
time_step = 0.025 * ms

# Parameters for current injection 
currentLevel_temp = 0.38 # nA
currentLevel_initial = currentLevel_temp # nA
currentLevel_final = currentLevel_temp # nA
currentLevel_step = 0.1 # nA

# Scale factor for collateral diameter
scaleFactorList_collateralDiameter = [0.9, 0.45] # [SF1,SF2] for the collaterals

# Axon and collateral parameters - for connection and recording
count_collaterals = 2
connectionSiteList_collaterals = [10,20] # [S1,S2] where both S1 and S2 are nodes along the main axon

location_start_axon = 0 # (Either 0 or 1)
location_stop_axon = 2 # (Either 1 or 2)
location_start_collateral = -1 # (Either -1 or 0 or 1, -1 when starting location is in axon)
location_stop_collateral = 2 # (Either 1 or 2)

# Perturbation and paranode-scaling code
code_perturbation = 0 # (0: Unperturbed - Default, 1: Demyelinated, >=2: Remyelinated)
code_paranodeScaling = 1 # (0: Fixed, 1: Scaled)

# For the input model file 
inputFilename_axonParameters = 'fileAxonParameters_List1' # fileAxonParameters_List1, fileAxonParameters_List50

# IMPORTANT - Number of perturbation schemes for the axon and collateral(s) should be the same

# For the axon perturbation file
inputFilename_axonPerturbations = 'fileAxonPerturbations_30seg_none' # fileAxonPerturbations_30seg_none

# For the collateral perturbation file
if (count_collaterals != 0):
    if (count_collaterals == 1):
        inputFilename_collateralPerturbations_0 = 'fileCollateralPerturbations_10seg_none'
    if (count_collaterals == 2):
        inputFilename_collateralPerturbations_0 = 'fileCollateralPerturbations_10seg_none'
        inputFilename_collateralPerturbations_1 = 'fileCollateralPerturbations_10seg_none'

# Special description
specialDescription = '''\nThis is to study the propagation along the main axon, and primary collaterals.\n\n'''

# For the output files
simulationID = 1