"""

Description: This file creates pyramidal cell(s)

Edit History: Created by Nilapratim Sengupta in July-August 2023.

"""

# Import statements
from neuron import h

# Importing necessary files
import fileSomaDendrites
import fileAxon
import fileCollateral

# Defining class pyramidal cell with soma, dendrites, axon and collateral(s)
class PyramidalCellTemplateWithoutCollateral:

    def __init__(self, count_axonSegments):
        
        # Creating the soma and dendrites
        self.pyramidalSomaDendrites = fileSomaDendrites.SomaDendritesTemplate()
        
        # Creating the axon
        self.pyramidalAxon = fileAxon.AxonTemplate(count_axonSegments)
        
        # Connecting the axon to the cell body
        self.pyramidalAxon.hill_axon.connect(self.pyramidalSomaDendrites.comp[1](0.5))

# End of PyramidalCellTemplateWithoutCollateral



# Defining class pyramidal cell with soma, dendrites, axon and collateral(s)
class PyramidalCellTemplate:

    def __init__(self, count_axonSegments, count_collaterals, countList_collateralSegments, connectionSiteList_collaterals):
        
        # Creating the soma and dendrites
        self.pyramidalSomaDendrites = fileSomaDendrites.SomaDendritesTemplate()
        
        # Creating the axon
        self.pyramidalAxon = fileAxon.AxonTemplate(count_axonSegments)
        
        # Connecting the axon to the cell body
        self.pyramidalAxon.hill_axon.connect(self.pyramidalSomaDendrites.comp[1](0.5))
        
        # Creating the collateral(s)
        if (count_collaterals > 0):
            self.pyramidalCollateral = [fileCollateral.CollateralTemplate(countList_collateralSegments[loopCounter]) for loopCounter in range(count_collaterals)]

            # Connecting the collateral(s) to the axon
            # for loopCounter in range(count_collaterals):
            #     self.pyramidalCollateral[loopCounter].nodes_collateral[0].connect(self.pyramidalAxon.nodes_axon[connectionSiteList_collaterals[loopCounter]](0.5))
            self.pyramidalCollateral[0].nodes_collateral[0].connect(self.pyramidalAxon.nodes_axon[connectionSiteList_collaterals[0]](0.5))
            if (count_collaterals > 1):
                self.pyramidalCollateral[1].nodes_collateral[0].connect(self.pyramidalCollateral[0].nodes_collateral[connectionSiteList_collaterals[1]](0.5))

# End of PyramidalCellTemplate
