## Installation Instructions

Simulations were run using Python 3.10.12. The instructions below were tested on Ubuntu Linux 22.04.

1. Install NEURON:
    ```bash
    pip3 install neuron
    ```

2. Install NetPyNE:
    ```bash
    pip3 install netpyne
    ```

3. Install OpenPyXL:
    ```bash
    pip3 install openpyxl
    ```

4. Extract the SCN1A files from the downloaded zip (`2019444.zip`) and change to the `Knox_SCN1A_model` directory.

5. Compile NEURON mechanisms:
    ```bash
    nrnivmodl ./mechanisms
    ```

6. Carry out one run using `test_SCN1A_variants.py` (optional seed number):
    ```bash
    python3 test_SCN1A_variants.py
    ```
    - The figure is saved as `vary_epsp_ei3.0_[seed].png`, where `[seed]` is the seed number.

7. Carry out a batch of simulation runs using `run_lots_of_sims.sh`:
    ```bash
    ./run_lots_of_sims.sh
    ```

8. Move the results to a subdirectory:
    ```bash
    mkdir results
    mv output_data_ei* results
    ```

9. Make the final figure (optional seed number):
    ```bash
    python3 make_fig_3.py
    ```
    - The figure is saved as `figure_3.png`.
