COMMENT
	K accum
ENDCOMMENT

NEURON {
	SUFFIX kum
	USEION k READ ik WRITE ko, ki
	NONSPECIFIC_CURRENT i
	RANGE depthko,depthki, kmax, irest, ko, ki, tau1, tau2, tau3, tau4
}

UNITS {
	(mM) = (milli/liter)
	(mA) = (milliamp)
	F = (faraday) (coulombs)
}

PARAMETER {
	depthko = 0.1 (um)	: assume volume = area*depth
:	depthki = diam
	irest = 0  (mA/cm2)		: to be initialized in hoc	
	tau1 = 2 (ms)
	tau2 = 900 (ms)	
	tau3 = 1150 (ms)
	tau4 = 1150 (ms)
	diam (um)
}

ASSIGNED {
	ik (mA/cm2)
	kmax
	i  	 (mA/cm2)
}

STATE {
	ko (mM)
	ki (mM)
}

INITIAL {
	ko=5
	ko0=5
	ki0=150
	ki=150
:	kmaxko=ko
:	kmaxki=ki
	}

BREAKPOINT {
	SOLVE integrate METHOD derivimplicit
:	if (ko>kmax) {kmaxko=ko}
:	if (ki>kmax) {kmaxki=ki}
	i=0
}

DERIVATIVE integrate {
	ko' = ((ik-irest)/depthko/F*(1e4))/tau1 - (ko-ko0)/tau2 - (ko-ko0)/tau4 
	ki' = -((ik-irest)/depthko/F*(1e4))/tau1 + (ko - ko0)/tau2 - (ki - ki0)/tau3
}
