# ReadMe

**"Mitochondria delay action potential propagation"**  
A.M. Castelfranco and P. Alcami (Communications Biology, 2025)

This code was written to run in **NEURON** (version 7.4), but has been tested in NEURON (version 8.2.6). It does not require Python.

The code consists of:
- Two membrane mechanisms:  
  - `Kv1.mod`
  - `Na.mod`
- Five hoc files:  
  - `mosinit.hoc`
  - `topo05.hoc`
  - `topo125.hoc`
  - `topo20.hoc`
  - `HVCRA_neuron.hoc`

Descriptions:
- The file `mosinit.hoc` initializes the simulation.
- The files `topo05.hoc`, `topo125.hoc`, and `topo20.hoc` specify the topology of the axon for three longitudinal mitochondrial coverages: 5%, 12.5%, and 20%, respectively.
- The file `HVCRA_neuron.hoc` specifies the properties of the model neuron, runs the simulation, computes the conduction velocity, and prints the output to the screen.

The simulation generates part of the dataset used in the plots in Figure 3 of the article.

---

**Instructions:**

1. **Compile the mechanisms:**  
   Before running the simulation, the membrane mechanisms `Kv1.mod` and `Na.mod` need to be compiled by running `mknrndll` in NEURON.

2. **Run the simulation:**  
   Double-click on the file `mosinit.hoc`.  
   Select the axon diameter and longitudinal mitochondrial coverage in the dialog box.

3. **Simulation output:**  
   The simulation computes the action potential conduction velocity and the additional delay in propagating 3 mm due to the presence of mitochondria in the axon for 8 cross-sectional mitochondrial occupancies *p* ranging from 0.1 to 0.8.  
   The conduction velocity and additional delay for each value of *p* are printed to the screen.

4. **Plots:**  
   At the conclusion of the simulation, plots of the conduction velocity and additional delay as a function of *p* are displayed.

