% Parameters for the model 
%
% See Mejias et al. Science Advances 2016 and Lindeman et al. PNAS 2021 for
% more information on previous versions of this model.

function [par]=parameters(Tmax,PCsig,PFCsig,sigext)


% We put all the relevant parameters in the parameter structure "par":
%time constants, in seconds:
par.dt=0.2e-3;par.triallength=Tmax;par.transient=5.;
sc2=1.;%with 1, gamma freq is around 35 to 50 Hz
sc5=8.;%with 8, theta freq is around 4 to 8 Hz (we also decrease Ibg, which helped here).
par.tau=[0.006*sc2 0.015*sc2 0.006*sc5 0.015*sc5]; %re2 ri2 re5 ri5
par.tstep=((par.dt)./(par.tau))';sig=0.3.*[1 1 1.5 1.5]; %sig=0.3
par.tstep2=(((par.dt.*sig.*sig)./(par.tau)).^(0.5))';


% local and interlaminar synaptic coupling strengths:
J2e=1;      % L2/3 excit to L5 excit
J2i=0.;       % L2/3 excit to L5 inhib
J5e=0.;       % L5 excit to L2/3 excit
J5i=0.75;       % L5 excit to L2/3 inhib. 0.2, if you want !=0

par.J=zeros(4,4);
%local, layer 2:
par.J(1,1)=1.5;par.J(1,2)=-3.25;
par.J(2,1)=3.5;par.J(2,2)=-2.5;
%local, layer 5:
par.J(3,3)=1.5;par.J(3,4)=-3.25;
par.J(4,3)=3.5;par.J(4,4)=-2.5;
%inter-laminar:
par.J(3,1)=J2e;par.J(4,1)=J2i;
par.J(1,3)=J5e;par.J(2,3)=J5i;

%background inputs:
par.inputbg=[4.; 0.; 1.; 0.]; %re2 ri2 re5 ri5, before: 4,0,2,0

%interareal connectivity matrix, W:
%W(a,b,c,d), with
%a=post. area
%b=pres. area
%c=post. layer: 1=supraE, 2=infraE, 3=supraI, 4=infraI
%d=pres. layer: 1=supraE, 2=infraE

%s=0.95; %feedback selectivity
par.W=zeros(2,2,4,2);x1=0.75;
par.W(2,1,1,1)=0.7*x1;      %S1 to M1, supraE to supraE
par.W(2,1,2,1)=(1-x1);  %S1 to M1, supraE to infraE
par.W(2,1,1,2)=(1-x1);  %S1 to M1, infraE to supraE
par.W(2,1,2,2)=x1;      %S1 to M1, infraE to infraE
par.W(1,2,2,1)=1;      %M1 to S1, supraE to infraE
par.W(1,2,2,2)=1;      %M1 to S1, infraE to infraE
par.W(1,2,1,1)=0.5;      %M1 to S1, supraE to supraE



%%%CEREBELUM AND THALAMUS%%%

%sigma (low pass PC signal)
par.siglpPC=PCsig;par.taulpPC=0.08;

%sigma (low pass PFC signal)
par.siglpPFC=PFCsig;par.taulpPFC=0.2;

%sigma (low pass external signal to S1 and PC)
par.siglpS1=sigext;par.taulpS1=0.08;

%Feedforward pathway: connection strengths from thalamus to S1 and M1
%cortex. Control parameters: z10=[0,1] for Pom->S1, z11=[0,1] for Pom->M1.
z10=1;z11=1;
par.Jpom1=z10*0.3;par.Jpom2=z10*0.1;par.Jpom3=z10*0.3;par.Jpom4=z10*0.1; %to S1
par.Jpome2=z11*2./6.;par.Jpomi2=z11*3./6.;par.Jpome5=z11*2./6.;par.Jpomi5=z11*3./6.;par.Jvle5=z11*6./10.; %to M1
%Feedback pathway: connection strengths from M1 cortex to thalamus and PC. 
% Control parameter: z11=0.2
z12=0.2;
par.Jpn=z12;par.Jgrc=z12;par.Jpc=z12;






