% Figure 1
%
% Jorge Mejias, 2025
%

figure('position',[100,100,1000,600]);

%first, the premovement phase:

load 'premov-traces.mat';subplot(2,3,1);
condition='Pre-movement';if PFCsig<1;condition='Movement';end
%we plot the cross-correlation as a function of the lag:
lagsM=lagsplot;corrM=corrplot;corrlim=100;
plot(lagsM*par.dt*1000,corrM,'LineWidth',2);hold on;
xline(0,'--','LineWidth',2);set(gca,'FontSize',12,'LineWidth',2,'TickLength',[0.02 0.02]);
xlim([-corrlim corrlim]);set(gca,'box','off');xlabel('Lag (ms)');ylabel('Correlation');title(condition);
% A peak of xcorr(M1,ratePC) at a lag>0 means that PC is leading M1. A peak at lag<0 means M1 is leading instead.

%now the values of lag and corr between the cerebellum and each cortical area:
lagCSp=comparisons(:,1);
corCSp=comparisons(:,3); %pearson
lagCMp=comparisons(:,4);
corCMp=comparisons(:,6); %pearson



%now, the movement phase:
load 'mov-traces.mat';subplot(2,3,2);
condition='Pre-movement';if PFCsig<1;condition='Movement';end
%we plot the cross-correlation as a function of the lag:
lagsM=lagsplot;corrM=corrplot;corrlim=100;
plot(lagsM*par.dt*1000,corrM,'LineWidth',2);hold on;
xline(0,'--','LineWidth',2);set(gca,'FontSize',12,'LineWidth',2,'TickLength',[0.02 0.02]);
xlim([-corrlim corrlim]);set(gca,'box','off');xlabel('Lag (ms)');ylabel('Correlation');title(condition);
% A peak of xcorr(M1,ratePC) at a lag>0 means that PC is leading M1. A peak at lag<0 means M1 is leading instead.

%now the values of lag and corr between the cerebellum and each cortical area:
lagCSm=comparisons(:,1);
corCSm=comparisons(:,3); %pearson
lagCMm=comparisons(:,4);
corCMm=comparisons(:,6); %pearson


%Finally, we can plot the other panels which compare mov and premov conditions:
Ntrials=length(lagCSp);points=ones(Ntrials,1);
subplot(2,3,3)
plot(points*1,corCMp,'o');hold on;
plot(points*2,corCSp,'o');hold on;
plot(points*3,corCMm,'o');hold on;
plot(points*4,corCSp,'o');
set(gca,'FontSize',12,'LineWidth',2,'TickLength',[0.02 0.02]);xlim([0 5]);ylim([0 0.3]);
set(gca,'box','off');ylabel('Correlation');legend({'Premov, M1-Cb' 'Premov, S1-Cb' 'Mov, M1-Cb' 'Mov, S1-Cb'});

subplot(2,3,4)
plot(points*1,lagCMp,'o');hold on;
plot(points*2,lagCMm,'o');
set(gca,'FontSize',12,'LineWidth',2,'TickLength',[0.02 0.02]);xlim([0 3]);ylim([-30 90]);
set(gca,'box','off');ylabel('Lag (ms)');legend({'Premov' 'Mov'});title('M1-Cb');

subplot(2,3,5)
plot(points*1,lagCSp,'o');hold on;
plot(points*2,lagCSm,'o');
set(gca,'FontSize',12,'LineWidth',2,'TickLength',[0.02 0.02]);xlim([0 3]);ylim([-30 90]);
set(gca,'box','off');ylabel('Lag (ms)');legend({'Premov' 'Mov'});title('S1-Cb');

subplot(2,3,6)
plot(points*1,corCSp,'o');hold on;
plot(points*2,corCSm,'o');
set(gca,'FontSize',12,'LineWidth',2,'TickLength',[0.02 0.02]);xlim([0 3]);ylim([0 0.3]);
set(gca,'box','off');ylabel('Correlation');legend({'Premov' 'Mov'});title('S1-Cb');








