# Code to Replicate the Computational Results from Romano et al. Nature Communications 2025

The computational model and corresponding code have been designed and implemented by **Jorge Mejias**, from the University of Amsterdam.  
**Contact**: [j.f.mejias@uva.nl](mailto:j.f.mejias@uva.nl)

---

## Instructions

Follow these steps to run the code and obtain the simulation results:

1. **Run `main1.m`**:  
   Modify any parameters within this file to reproduce the different results shown in the manuscript.

2. **Replicating Figures**:
   - **Figure 1**:  
     Run `main.m` for the following conditions:  
       - Premovement: `PFCsig = 100`  
       - Movement: `PFCsig = 0`  
     Compare the results by running the script `figure1.m`.

   - **Figures 2 and 3**:  
     Inactivate different populations (e.g., PN or VL) using the variable `optopulse`.  
     - For inactivation, use negative input values.  
     Analyze the results by building and using similar scripts.

   - **Figure 4**:  
     To simulate the stimulation of PC, simply run `figure4.m`.