function sem=SEM_calc(vect, CI)
% SEM_calc - standard error of the mean, confidence interval


error(nargchk(1,2,nargin))

if isvector(vect)
  vect=vect(:);
end


if nargin==1
  stdCI = 1.96 ; 
elseif nargin==2
  CI = CI/2 ; %Convert to 2-tail
  stdCI = abs(norminv(CI,0,1)) ;
end

sem = ( (nanstd(vect)) ./ sqrt(sum(~isnan(vect))) ) * stdCI ;    




