
%%% Condition (pre-movement vs movement)%%%


function [par,rate,ratesub,S1,M1,corrS,lagsS,corrM,lagsM]=conditionsim(optopulse,PCsig,PFCsig,sigext)


%Simulate the full system (no opto-pulse, premovement condition):
%PFCsig should reflect the prefrontal signals during movement preparation,
%which should lead to cortex leading the PC-M1 correlation (so lag(M1,PC)<0).
Nareas=2;Gw=1.;Tmax=120.;
par=parameters(Tmax,PCsig,PFCsig,sigext);
[rate,ratesub]=trial(par,optopulse,Nareas,Gw);ratePC=ratesub(1,:,1);


%we compute the cross-correlation matrix as a function of the lag:
eta=0.2;S1=eta*rate(1,:,1)+(1-eta)*rate(3,:,1);M1=eta*rate(1,:,2)+(1-eta)*rate(3,:,2);
[corrM,lagsM]=xcorr(M1,ratePC,'normalized');
[corrS,lagsS]=xcorr(S1,ratePC,'normalized');


