: this model is built-in to neuron with suffix syn_g_duo

COMMENT
synaptic current with exponential rise and decay conductance defined by
        i = g * (v - e)      i(nanoamps), g(micromhos);
        where
         g = 0 for t < onset and
         g=amp*((1-exp(-(t-onset)/tau0))-(1-exp(-(t-onset)/tau1)))
          for t > onset
ENDCOMMENT
					       
INDEPENDENT {t FROM 0 TO 1 WITH 1 (ms)}

NEURON {
	POINT_PROCESS syn_g_duo
	RANGE onset, tau0, tau1, tau2, tau3, gmax, ntar, e, i
	NONSPECIFIC_CURRENT i
}
UNITS {
	(nA) = (nanoamp)
	(mV) = (millivolt)
	(umho) = (micromho)
}

PARAMETER {
	onset=0  (ms)
	: ampa
	tau0=0.3 (ms)
	tau1=3.0 (ms)
	: nmda from Larkum 2009
	tau2=5.0 (ms) 
	tau3=90.0 (ms)
	gmax=0	 (umho)
	ntar = 0.3
	: nomad to amp ratio from Larkum 2009
	e=0	 (mV)
	v	 (mV)
}

ASSIGNED { i (nA)  g (umho) ga (umho) gn (umho) }

LOCAL   a[4]
LOCAL   tpeak
LOCAL   adjust
LOCAL   amp

BREAKPOINT {
        ga = conda(t)
        gn = condn(t)
	g = ga+gn
	i = (ga*(v - e)) + (gn*(v - e) *mgblock(v))
}

FUNCTION conda(x) {
	tpeak=tau0*tau1*log(tau0/tau1)/(tau0-tau1)
	adjust=1/((1-exp(-tpeak/tau0))-(1-exp(-tpeak/tau1)))
	amp=adjust*gmax
	if (x < onset) {
		conda = 0
	}else{
		a[0]=1-exp(-(x-onset)/tau0)
		a[1]=1-exp(-(x-onset)/tau1)
		conda = amp*(a[0]-a[1])
	}
}

FUNCTION condn(x) {
	tpeak=tau2*tau3*log(tau2/tau3)/(tau2-tau3)
	adjust=1/((1-exp(-tpeak/tau2))-(1-exp(-tpeak/tau3)))
	amp=adjust*gmax*ntar
	if (x < onset) {
		condn = 0
	}else{
		a[2]=1-exp(-(x-onset)/tau2)
		a[3]=1-exp(-(x-onset)/tau3)
		condn = amp*(a[2]-a[3])
	}
}

FUNCTION mgblock(v) {
	: from Jahr & Stevens

	mgblock = 1 / (1 + exp(0.062 * -v) * (2 / 3.57))
}
