// genesis

// Setting the axonal propagation velocity
float CABLE_VEL = 1	// scale factor = 1/(cable velocity) sec/meter

float destlim = {P5RSa_P23RSa_destlim}

/*
 * Usage :
 * planarconnect source-path destination-path
 *		 [-relative]
 *		 [-sourcemask {box,ellipse} x1 y1 x2 y2]
 *		 [-sourcehole {box,ellipse} x1 y1 x2 y2]
 *		 [-destmask   {box,ellipse} x1 y1 x2 y2]
 *		 [-desthole   {box,ellipse} x1 y1 x2 y2]
 *		 [-probability p]
 */

echo Making connections from the P5RSa cells to the P23RSa cells.

//P5RSa - P23RSa AMPA

str s

//Load synapse location array

str locations = "apdend3 apdend4aL apdend4bL apdend4aR apdend4bR apdend5aLLL apdend5aLL apdend5aLR apdend5aLRR apdend5aRRR apdend5aRR apdend5aRL apdend5aRLL"

foreach s ({arglist {locations}})

    rvolumeconnect /P5RSanet/P5RSa[]/soma/spk23  \
	      /P23RSanet/P23RSa[]/{s}/Ex_ch1P5RSAMPA@all	    \
	      -relative			    \
	      -sourcemask box -1 -1  -1  1  1  1  \
	      -destmask   box -{destlim} -{destlim}  -1 {destlim}  {destlim}  1   \
          -probability 0.07692*{P5RSa_P23RSa_prob}

end

//P5RSa - P23RSa NMDA

str s

//Load synapse location array

str locations = "apdend3 apdend4aL apdend4bL apdend4aR apdend4bR apdend5aLLL apdend5aLL apdend5aLR apdend5aLRR apdend5aRRR apdend5aRR apdend5aRL apdend5aRLL"

foreach s ({arglist {locations}})

    rvolumeconnect /P5RSanet/P5RSa[]/soma/spk23  \
	      /P23RSanet/P23RSa[]/{s}/Ex_ch1P5RSNMDA@all	    \
	      -relative			    \
	      -sourcemask box -1 -1  -1  1  1  1  \
	      -destmask   box -{destlim} -{destlim}  -1 {destlim}  {destlim}  1   \
          -probability 0.07692*{P5RSa_P23RSa_prob}

end

echo Setting weights and delays for P5RSa->P23RSa connections.
// assigning delays using the planardelay function

/* 
 * Usage :
 * planardelay path 
 * [-fixed delay]
 * [-radial propagation_velocity] 
 * [-uniform range]   (not used here)
 * [-gaussian sd max] (not used here)
 * [-exp mid max]     (not used here)
 * [-absoluterandom]  (not used here)
 */

rvolumedelay /P5RSanet/P5RSa[]/soma/spk23 -radial  {P5RSa_P23RSa_axdelayCV} -add -gaussian {P5RSa_P23RSa_axdelaystdev} {P5RSa_P23RSa_axdelaymaxdev}

//P5RSa - P23RSa AMPA

str s

//Load synapse location array

str locations = "apdend3 apdend4aL apdend4bL apdend4aR apdend4bR apdend5aLLL apdend5aLL apdend5aLR apdend5aLRR apdend5aRRR apdend5aRR apdend5aRL apdend5aRLL"

foreach s ({arglist {locations}})

    syndelay    /P23RSanet/P23RSa[]/{s}/Ex_ch1P5RSAMPA {P5RSa_P23RSa_syndelay} -add -gaussian {P5RSa_P23RSa_syndelaystdev} {P5RSa_P23RSa_syndelaymaxdev}

end

//P5RSa - P23RSa NMDA

str s

//Load synapse location array

str locations = "apdend3 apdend4aL apdend4bL apdend4aR apdend4bR apdend5aLLL apdend5aLL apdend5aLR apdend5aLRR apdend5aRRR apdend5aRR apdend5aRL apdend5aRLL"

foreach s ({arglist {locations}})

    syndelay    /P23RSanet/P23RSa[]/{s}/Ex_ch1P5RSNMDA {P5RSa_P23RSa_syndelay} -add -gaussian {P5RSa_P23RSa_syndelaystdev} {P5RSa_P23RSa_syndelaymaxdev}

end

// assigning weights using the planarweight function

/* 
 * Usage :
 *  planarweight sourcepath 
 *          [-fixed weight]
 *          [-decay decay_rate max_weight min_weight]
 *          [-uniform range] 
 *          [-gaussian sd max] 
 *          [-exponential mid max]
 *          [-absoluterandom]
 */

rvolumeweight /P5RSanet/P5RSa[]/soma/spk23 -decay {P5RSdecayrate} {P5RSmaxwgt} {P5RSminwgt}




