// genesis

// Setting the axonal propagation velocity
float CABLE_VEL = 1	// scale factor = 1/(cable velocity) sec/meter

float destlim = {P23RSd_P6RSa_destlim}

/*
 * Usage :
 * volumeconnect source-path destination-path
 *		 [-relative]
 *		 [-sourcemask {box,ellipse} x1 y1 x2 y2]
 *		 [-sourcehole {box,ellipse} x1 y1 x2 y2]
 *		 [-destmask   {box,ellipse} x1 y1 x2 y2]
 *		 [-desthole   {box,ellipse} x1 y1 x2 y2]
 *		 [-probability p]
 */

echo Making connections from the P23RSd cells to the P6RSa cells.


//P23RSd - P6RSa AMPA

str s

//Load synapse location array

str locations = "apdend3 apdend4 apdend5 apdend6 apdend7 apdend8 apdend9 apdend10"

foreach s ({arglist {locations}})

    rvolumeconnect /P23RSdnet/P23RSd[]/soma/spk4  \
	      /P6RSanet/P6RSa[]/{s}/Ex_ch11P23RSAMPA@all	    \
	      -relative			    \
	      -sourcemask box -1 -1  -1  1  1  1   \
	      -destmask   box -{destlim} -{destlim}  -1  {destlim}  {destlim}  1   \
          -probability 0.12500*{P23RSd_P6RSa_prob}

end

//P23RSd - P6RSa NMDA

str s

//Load synapse location array

str locations = "apdend3 apdend4 apdend5 apdend6 apdend7 apdend8 apdend9 apdend10"

foreach s ({arglist {locations}})

    rvolumeconnect /P23RSdnet/P23RSd[]/soma/spk4  \
	      /P6RSanet/P6RSa[]/{s}/Ex_ch11P23RSNMDA@all	    \
	      -relative			    \
	      -sourcemask box -1 -1  -1  1  1  1   \
	      -destmask   box -{destlim} -{destlim}  -1  {destlim}  {destlim}  1   \
          -probability 0.12500*{P23RSd_P6RSa_prob}

end

echo Setting weights and delays for P23RSd->P6RSa connections.

// assigning delays using the volumedelay function

/* 
 * Usage :
 * volumedelay path 
 * [-fixed delay]
 * [-radial propagation_velocity] 
 * [-uniform range]   (not used here)
 * [-gaussian sd max] (not used here)
 * [-exp mid max]     (not used here)
 * [-absoluterandom]  (not used here)
 */

rvolumedelay /P23RSdnet/P23RSd[]/soma/spk4 -radial  {P23RSd_P6RSa_axdelayCV} -add -gaussian {P23RSd_P6RSa_axdelaystdev} {P23RSd_P6RSa_axdelaymaxdev}

//P23RSd - P6RSa AMPA

str s

//Load synapse location array

str locations = "apdend3 apdend4 apdend5 apdend6 apdend7 apdend8 apdend9 apdend10"

foreach s ({arglist {locations}})

    syndelay    /P6RSanet/P6RSa[]/{s}/Ex_ch11P23RSAMPA {P23RSd_P6RSa_syndelay} -add -gaussian {P23RSd_P6RSa_syndelaystdev} {P23RSd_P6RSa_syndelaymaxdev}

end

//P23RSd - P6RSa NMDA

str s

//Load synapse location array

str locations = "apdend3 apdend4 apdend5 apdend6 apdend7 apdend8 apdend9 apdend10"

foreach s ({arglist {locations}})

    syndelay    /P6RSanet/P6RSa[]/{s}/Ex_ch11P23RSNMDA {P23RSd_P6RSa_syndelay} -add -gaussian {P23RSd_P6RSa_syndelaystdev} {P23RSd_P6RSa_syndelaymaxdev}

end

// assigning weights using the volumeweight function

/* 
 * Usage :
 *  volumeweight sourcepath 
 *          [-fixed weight]
 *          [-decay decay_rate max_weight min_weight]
 *          [-uniform range] 
 *          [-gaussian sd max] 
 *          [-exponential mid max]
 *          [-absoluterandom]
 */

rvolumeweight /P23RSdnet/P23RSd[]/soma/spk4 -decay {P23RSdecayrate} {P23RSmaxwgt} {P23RSminwgt}




