COMMENT

   **************************************************
   File generated by: neuroConstruct v1.7.1 
   **************************************************

   This file holds the implementation in NEURON of the Cell Mechanism:
   NaxSH0_ChannelML (Type: Channel mechanism, Model: ChannelML based process)

   with parameters: 
   /channelml/@units = Physiological Units 
   /channelml/notes = ChannelML file containing a single Channel description 
   /channelml/channel_type/@name = NaxSH0_ChannelML 
   /channelml/channel_type/@density = yes 
   /channelml/channel_type/status/@value = stable 
   /channelml/channel_type/status/comment = Agreement of generated NEURON and GENESIS to original NEURON mod. Compared voltage and n traces on single comp with current pulse 
   /channelml/channel_type/status/contributor/name = Padraig Gleeson 
   /channelml/channel_type/notes = Na Channel 
   /channelml/channel_type/authorList/modelTranslator/name = Padraig Gleeson 
   /channelml/channel_type/authorList/modelTranslator/institution = UCL 
   /channelml/channel_type/authorList/modelTranslator/email = p.gleeson - at - ucl.ac.uk 
   /channelml/channel_type/current_voltage_relation/@cond_law = ohmic 
   /channelml/channel_type/current_voltage_relation/@ion = na 
   /channelml/channel_type/current_voltage_relation/@default_gmax = 40 
   /channelml/channel_type/current_voltage_relation/@default_erev = 67 
   /channelml/channel_type/current_voltage_relation/@charge = 1 
   /channelml/channel_type/current_voltage_relation/q10_settings/@q10_factor = 2 
   /channelml/channel_type/current_voltage_relation/q10_settings/@experimental_temp = 24 
   /channelml/channel_type/current_voltage_relation/gate[1]/@name = m 
   /channelml/channel_type/current_voltage_relation/gate[1]/@instances = 3 
   /channelml/channel_type/current_voltage_relation/gate[1]/closed_state/@id = m0 
   /channelml/channel_type/current_voltage_relation/gate[1]/open_state/@id = m 
   /channelml/channel_type/current_voltage_relation/gate[1]/open_state/@fraction = 1 
   /channelml/channel_type/current_voltage_relation/gate[1]/transition[1]/@name = alpha 
   /channelml/channel_type/current_voltage_relation/gate[1]/transition[1]/@from = m0 
   /channelml/channel_type/current_voltage_relation/gate[1]/transition[1]/@to = m 
   /channelml/channel_type/current_voltage_relation/gate[1]/transition[1]/@expr_form = exp_linear 
   /channelml/channel_type/current_voltage_relation/gate[1]/transition[1]/@rate = 2.880000018 
   /channelml/channel_type/current_voltage_relation/gate[1]/transition[1]/@scale = 7.2 
   /channelml/channel_type/current_voltage_relation/gate[1]/transition[1]/@midpoint = -30 
   /channelml/channel_type/current_voltage_relation/gate[1]/transition[2]/@name = beta 
   /channelml/channel_type/current_voltage_relation/gate[1]/transition[2]/@from = m 
   /channelml/channel_type/current_voltage_relation/gate[1]/transition[2]/@to = m0 
   /channelml/channel_type/current_voltage_relation/gate[1]/transition[2]/@expr_form = exp_linear 
   /channelml/channel_type/current_voltage_relation/gate[1]/transition[2]/@rate = 0.892800005 
   /channelml/channel_type/current_voltage_relation/gate[1]/transition[2]/@scale = -7.2 
   /channelml/channel_type/current_voltage_relation/gate[1]/transition[2]/@midpoint = -30 
   /channelml/channel_type/current_voltage_relation/gate[1]/time_course/@name = tau 
   /channelml/channel_type/current_voltage_relation/gate[1]/time_course/@from = m0 
   /channelml/channel_type/current_voltage_relation/gate[1]/time_course/@to = m 
   /channelml/channel_type/current_voltage_relation/gate[1]/time_course/@expr_form = generic 
   /channelml/channel_type/current_voltage_relation/gate[1]/time_course/@expr = 1/( (alpha + beta) * temp_adj_m ) &lt; 0.02 ? (0.02 * temp_adj_m) : 1/(alpha + beta)   
   /channelml/channel_type/current_voltage_relation/gate[2]/@name = h 
   /channelml/channel_type/current_voltage_relation/gate[2]/@instances = 1 
   /channelml/channel_type/current_voltage_relation/gate[2]/closed_state/@id = h0 
   /channelml/channel_type/current_voltage_relation/gate[2]/open_state/@id = h 
   /channelml/channel_type/current_voltage_relation/gate[2]/open_state/@fraction = 1 
   /channelml/channel_type/current_voltage_relation/gate[2]/transition[1]/@name = alpha 
   /channelml/channel_type/current_voltage_relation/gate[2]/transition[1]/@from = h0 
   /channelml/channel_type/current_voltage_relation/gate[2]/transition[1]/@to = h 
   /channelml/channel_type/current_voltage_relation/gate[2]/transition[1]/@expr_form = exp_linear 
   /channelml/channel_type/current_voltage_relation/gate[2]/transition[1]/@rate = 0.045 
   /channelml/channel_type/current_voltage_relation/gate[2]/transition[1]/@scale = 1.5 
   /channelml/channel_type/current_voltage_relation/gate[2]/transition[1]/@midpoint = -45 
   /channelml/channel_type/current_voltage_relation/gate[2]/transition[2]/@name = beta 
   /channelml/channel_type/current_voltage_relation/gate[2]/transition[2]/@from = h 
   /channelml/channel_type/current_voltage_relation/gate[2]/transition[2]/@to = h0 
   /channelml/channel_type/current_voltage_relation/gate[2]/transition[2]/@expr_form = exp_linear 
   /channelml/channel_type/current_voltage_relation/gate[2]/transition[2]/@rate = 0.015 
   /channelml/channel_type/current_voltage_relation/gate[2]/transition[2]/@scale = -1.5 
   /channelml/channel_type/current_voltage_relation/gate[2]/transition[2]/@midpoint = -45 
   /channelml/channel_type/current_voltage_relation/gate[2]/time_course/@name = tau 
   /channelml/channel_type/current_voltage_relation/gate[2]/time_course/@from = h0 
   /channelml/channel_type/current_voltage_relation/gate[2]/time_course/@to = h 
   /channelml/channel_type/current_voltage_relation/gate[2]/time_course/@expr_form = generic 
   /channelml/channel_type/current_voltage_relation/gate[2]/time_course/@expr = 1/( (alpha + beta) * temp_adj_h ) &lt; 0.5 ? (0.5 * temp_adj_h) : 1/(alpha + beta)   
   /channelml/channel_type/current_voltage_relation/gate[2]/steady_state/@name = inf 
   /channelml/channel_type/current_voltage_relation/gate[2]/steady_state/@from = h0 
   /channelml/channel_type/current_voltage_relation/gate[2]/steady_state/@to = h 
   /channelml/channel_type/current_voltage_relation/gate[2]/steady_state/@expr_form = sigmoid 
   /channelml/channel_type/current_voltage_relation/gate[2]/steady_state/@rate = 1 
   /channelml/channel_type/current_voltage_relation/gate[2]/steady_state/@scale = 4 
   /channelml/channel_type/current_voltage_relation/gate[2]/steady_state/@midpoint = -50 
   /channelml/channel_type/impl_prefs/table_settings/@max_v = 100 
   /channelml/channel_type/impl_prefs/table_settings/@min_v = -100 
   /channelml/channel_type/impl_prefs/table_settings/@table_divisions = 2000 

// File from which this was generated: /home/Simon/NML2_Test/AOB_MC_neuroConstruct/cellMechanisms/NaxSH0_ChannelML/NaChannel.xml

// XSL file with mapping to simulator: /home/Simon/NML2_Test/AOB_MC_neuroConstruct/cellMechanisms/NaxSH0_ChannelML/ChannelML_v1.8.1_NEURONmod.xsl

ENDCOMMENT


?  This is a NEURON mod file generated from a ChannelML file

?  Unit system of original ChannelML file: Physiological Units

COMMENT
    ChannelML file containing a single Channel description
ENDCOMMENT

TITLE Channel: NaxSH0_ChannelML

COMMENT
    Na Channel
ENDCOMMENT


UNITS {
    (mA) = (milliamp)
    (mV) = (millivolt)
    (S) = (siemens)
    (um) = (micrometer)
    (molar) = (1/liter)
    (mM) = (millimolar)
    (l) = (liter)
}


    
NEURON {
      

    SUFFIX NaxSH0_ChannelML
    USEION na READ ena WRITE ina VALENCE 1 ? reversal potential of ion is read, outgoing current is written
           
        
    RANGE gmax, gion
    
    RANGE minf, mtau
    
    RANGE hinf, htau
    
}

PARAMETER { 
      

    gmax = 0.04 (S/cm2)  ? default value, should be overwritten when conductance placed on cell
    
}



ASSIGNED {
      

    v (mV)
    
    celsius (degC)
          

    ? Reversal potential of na
    ena (mV)
    ? The outward flow of ion: na calculated by rate equations...
    ina (mA/cm2)
    
    
    gion (S/cm2)
    minf
    mtau (ms)
    hinf
    htau (ms)
    
}

BREAKPOINT { 
                        
    SOLVE states METHOD cnexp
        
    gion = gmax * ((1*m)
^3) * ((1*h)
^1)      

    ina = gion*(v - ena)
            

}



INITIAL {
    
    ena = 67
        
    rates(v)
    m = minf
        h = hinf
        
    
}
    
STATE {
    m
    h
    
}



DERIVATIVE states {
    rates(v)
    m' = (minf - m)/mtau
            h' = (hinf - h)/htau
            

}

PROCEDURE rates(v(mV)) {  
    
    ? Note: not all of these may be used, depending on the form of rate equations
    LOCAL  alpha, beta, tau, inf, gamma, zeta
, temp_adj_m,
         A_alpha_m, B_alpha_m, Vhalf_alpha_m,
         A_beta_m, B_beta_m, Vhalf_beta_m
, temp_adj_h,
         A_alpha_h, B_alpha_h, Vhalf_alpha_h,
         A_beta_h, B_beta_h, Vhalf_beta_h,
         A_inf_h, B_inf_h, Vhalf_inf_h
    
    TABLE minf, mtau,hinf, htau
 DEPEND celsius FROM -100 TO 100 WITH 2000
    
    UNITSOFF
    
    ? There is a Q10 factor which will alter the tau of the gates 
                 

    temp_adj_m = 2^((celsius - 24)/10)     

    temp_adj_h = 2^((celsius - 24)/10)
            
                
           

        
    ?      ***  Adding rate equations for gate: m  ***
        
    ? Found a parameterised form of rate equation for alpha, using expression: A*((v-Vhalf)/B) / (1 - exp(-((v-Vhalf)/B)))
    A_alpha_m = 2.880000018
    B_alpha_m = 7.2
    Vhalf_alpha_m = -30 
    alpha = A_alpha_m * vtrap((v - Vhalf_alpha_m), B_alpha_m)
    
    
    ? Found a parameterised form of rate equation for beta, using expression: A*((v-Vhalf)/B) / (1 - exp(-((v-Vhalf)/B)))
    A_beta_m = 0.892800005
    B_beta_m = -7.2
    Vhalf_beta_m = -30 
    beta = A_beta_m * vtrap((v - Vhalf_beta_m), B_beta_m)
    
     
    ? Found a generic form of the rate equation for tau, using expression: 1/( (alpha + beta) * temp_adj_m ) < 0.02 ? (0.02 * temp_adj_m) : 1/(alpha + beta)  
    
    
    if (1/( (alpha + beta) * temp_adj_m ) < 0.02 ) {
        tau =  (0.02 * temp_adj_m) 
    } else {
        tau =  1/(alpha + beta)  
    }
    mtau = tau/temp_adj_m
    minf = alpha/(alpha + beta)
    


    ?     *** Finished rate equations for gate: m ***
    

    
            
                
           

        
    ?      ***  Adding rate equations for gate: h  ***
        
    ? Found a parameterised form of rate equation for alpha, using expression: A*((v-Vhalf)/B) / (1 - exp(-((v-Vhalf)/B)))
    A_alpha_h = 0.045
    B_alpha_h = 1.5
    Vhalf_alpha_h = -45 
    alpha = A_alpha_h * vtrap((v - Vhalf_alpha_h), B_alpha_h)
    
    
    ? Found a parameterised form of rate equation for beta, using expression: A*((v-Vhalf)/B) / (1 - exp(-((v-Vhalf)/B)))
    A_beta_h = 0.015
    B_beta_h = -1.5
    Vhalf_beta_h = -45 
    beta = A_beta_h * vtrap((v - Vhalf_beta_h), B_beta_h)
    
     
    ? Found a generic form of the rate equation for tau, using expression: 1/( (alpha + beta) * temp_adj_h ) < 0.5 ? (0.5 * temp_adj_h) : 1/(alpha + beta)  
    
    
    if (1/( (alpha + beta) * temp_adj_h ) < 0.5 ) {
        tau =  (0.5 * temp_adj_h) 
    } else {
        tau =  1/(alpha + beta)  
    }
    htau = tau/temp_adj_h
    
    ? Found a parameterised form of rate equation for inf, using expression: A / (1 + exp((v-Vhalf)/B))
    A_inf_h = 1
    B_inf_h = 4
    Vhalf_inf_h = -50 
    inf = A_inf_h / (exp((v - Vhalf_inf_h) / B_inf_h) + 1)
    
    hinf = inf
    


    ?     *** Finished rate equations for gate: h ***
    

         

}


? Function to assist with parameterised expressions of type linoid/exp_linear

FUNCTION vtrap(VminV0, B) {
    if (fabs(VminV0/B) < 1e-6) {
    vtrap = (1 + VminV0/B/2)
}else{
    vtrap = (VminV0 / B) /(1 - exp((-1 *VminV0)/B))
    }
}

UNITSON


