function [vrev fitresult, gof] = T_TypeFit(StimAct, peaksActNa)
%CREATEFIT(STIMACT,PEAKSACTNA)
%  Create a fit.
%
%  Data for 'T_Type' fit:
%      X Input : StimAct
%      Y Output: peaksActNa
%  Output:
%      fitresult : a fit object representing the fit.
%      gof : structure with goodness-of fit info.
%
%  See also FIT, CFIT, SFIT.

%  Auto-generated by MATLAB on 29-Jul-2016 13:43:19


%% Fit: 'T_Type'.
[xData, yData] = prepareCurveData( StimAct, peaksActNa );

% Set up fittype and options.
ft = fittype( 'gmax*(x-vrev)/(1+exp((vhalf-x)/k))', 'independent', 'x', 'dependent', 'y' );
opts = fitoptions( 'Method', 'NonlinearLeastSquares' );
opts.Display = 'Off';
opts.StartPoint = [1 5 -30 55];

% Fit model to data.
[fitresult, gof] = fit( xData, yData, ft, opts );
temp = coeffvalues(fitresult);
vrev = temp(4);


