function Data_Sleep_Epochs()
% Load the data
load('Data/Timeseries_FULL');

% Cut data for WAKE epoch
time = linspace(0, 30, 30*100);   
time_epoch = [0:1:30*100-1] + 700*30*100;
Epoch_WAKE = struct('time', time, ...
                   'time_epoch', time_epoch(1)/360000, ...
                   'Vp',  Vp(time_epoch),... 
                   'Na',  Na(time_epoch),... 
                   'f_W', f_W(time_epoch),... 
                   'f_N', f_N(time_epoch), ...
                   'f_R', f_R(time_epoch), ...
                   'C_E', C_E(time_epoch),... 
                   'C_G', C_G(time_epoch), ...
                   'C_A', C_A(time_epoch), ...
                   'sigma_p', sigma_p(time_epoch), ...
                   'g_KNa', g_KNa(time_epoch), ...
                   'h', h(time_epoch));

% Cut data for N1 epoch
time_epoch = [0:1:30*100-1] + 1598*30*100;
Epoch_N1 =  struct('time', time, ...
                   'time_epoch', time_epoch(1)/360000, ...
                   'Vp',  Vp(time_epoch),... 
                   'Na',  Na(time_epoch),... 
                   'f_W', f_W(time_epoch),... 
                   'f_N', f_N(time_epoch), ...
                   'f_R', f_R(time_epoch), ...
                   'C_E', C_E(time_epoch),... 
                   'C_G', C_G(time_epoch), ...
                   'C_A', C_A(time_epoch), ...
                   'sigma_p', sigma_p(time_epoch), ...
                   'g_KNa', g_KNa(time_epoch), ...
                   'h', h(time_epoch));
                          
% Cut data for N2 epoch    
time_epoch = [0:1:30*100-1] + 1611*30*100;
Epoch_N2 =  struct('time', time, ...
                   'time_epoch', time_epoch(1)/360000, ...
                   'Vp',  Vp(time_epoch),... 
                   'Na',  Na(time_epoch),... 
                   'f_W', f_W(time_epoch),... 
                   'f_N', f_N(time_epoch), ...
                   'f_R', f_R(time_epoch), ...
                   'C_E', C_E(time_epoch),... 
                   'C_G', C_G(time_epoch), ...
                   'C_A', C_A(time_epoch), ...
                   'sigma_p', sigma_p(time_epoch), ...
                   'g_KNa', g_KNa(time_epoch), ...
                   'h', h(time_epoch));
               
% Cut data for N3 epoch    
time_epoch = [0:1:30*100-1] + 1714*30*100;
Epoch_N3 =  struct('time', time, ...
                   'time_epoch', time_epoch(1)/360000, ...
                   'Vp',  Vp(time_epoch),... 
                   'Na',  Na(time_epoch),... 
                   'f_W', f_W(time_epoch),... 
                   'f_N', f_N(time_epoch), ...
                   'f_R', f_R(time_epoch), ...
                   'C_E', C_E(time_epoch),... 
                   'C_G', C_G(time_epoch), ...
                   'C_A', C_A(time_epoch), ...
                   'sigma_p', sigma_p(time_epoch), ...
                   'g_KNa', g_KNa(time_epoch), ...
                   'h', h(time_epoch));
                                  
% Cut data for REM epoch      
time_epoch = [0:1:30*100-1] + 1850*30*100;
Epoch_REM = struct('time', time, ...
                   'time_epoch', time_epoch(1)/360000, ...
                   'Vp',  Vp(time_epoch),... 
                   'Na',  Na(time_epoch),... 
                   'f_W', f_W(time_epoch),... 
                   'f_N', f_N(time_epoch), ...
                   'f_R', f_R(time_epoch), ...
                   'C_E', C_E(time_epoch),... 
                   'C_G', C_G(time_epoch), ...
                   'C_A', C_A(time_epoch), ...
                   'sigma_p', sigma_p(time_epoch), ...
                   'g_KNa', g_KNa(time_epoch), ...
                   'h', h(time_epoch));
               
% Cut data for WAKE-NREM epoch
time = linspace(0, 90, 90*100);   
time_epoch = [0:1:90*100-1] + 1592*30*100;
Epoch_WAKE_NREM = struct(  'time', time, ...
                           'time_epoch', time_epoch(1)/360000, ...
                           'Vp',  Vp(time_epoch),... 
                           'Na',  Na(time_epoch),... 
                           'f_W', f_W(time_epoch),... 
                           'f_N', f_N(time_epoch), ...
                           'f_R', f_R(time_epoch), ...
                           'C_E', C_E(time_epoch),... 
                           'C_G', C_G(time_epoch), ...
                           'C_A', C_A(time_epoch), ...
                           'sigma_p', sigma_p(time_epoch), ...
                           'g_KNa', g_KNa(time_epoch), ...
                           'h', h(time_epoch));

% Cut data for NREM-REM transition epoch
time_epoch = [0:1:90*100-1] + 2060*30*100;
Epoch_NREM_REM =  struct(  'time', time, ...
                           'time_epoch', time_epoch(1)/360000, ...
                           'Vp',  Vp(time_epoch),... 
                           'Na',  Na(time_epoch),... 
                           'f_W', f_W(time_epoch),... 
                           'f_N', f_N(time_epoch), ...
                           'f_R', f_R(time_epoch), ...
                           'C_E', C_E(time_epoch),... 
                           'C_G', C_G(time_epoch), ...
                           'C_A', C_A(time_epoch), ...
                           'sigma_p', sigma_p(time_epoch), ...
                           'g_KNa', g_KNa(time_epoch), ...
                           'h', h(time_epoch));
                       
                       
% Cut data for REM-NREM transition epoch
time_epoch = [0:1:90*100-1] + 1868*30*100;
Epoch_REM_NREM =  struct(  'time', time, ...
                           'time_epoch', time_epoch(1)/360000, ...
                           'Vp',  Vp(time_epoch),... 
                           'Na',  Na(time_epoch),... 
                           'f_W', f_W(time_epoch),... 
                           'f_N', f_N(time_epoch), ...
                           'f_R', f_R(time_epoch), ...
                           'C_E', C_E(time_epoch),... 
                           'C_G', C_G(time_epoch), ...
                           'C_A', C_A(time_epoch), ...
                           'sigma_p', sigma_p(time_epoch), ...
                           'g_KNa', g_KNa(time_epoch), ...
                           'h', h(time_epoch));
               
save('Data/Sleep_Epochs', 'Epoch_WAKE', 'Epoch_N1', 'Epoch_N2', 'Epoch_N3', 'Epoch_REM', 'Epoch_WAKE_NREM', 'Epoch_NREM_REM', 'Epoch_REM_NREM');   
end